        
<?php foreach($data['Events'] as $country => $events): ?>
<div style="border: 1px solid #EEE; padding: 5px; margin-bottom: 5px">
    <div class="row-fluid">
        <label class="pull-left"><?php echo strtoupper($country); ?></label>
        <a class="pull-right expand_event" href="javascript:void(0)" ><?php echo count($events).' webinar(s)' ?>&nbsp;&nbsp;<span class="icon-caret-down"></span></a>
    </div>
</div>
<div style="display: none;">
    <table class="table">
        <tr style="background: #F5F5F6">
            <th>Title</th>
            <th>Date</th>
            <th>Presenter</th>
            <th>Major</th>
            <th>&nbsp;</th>
        </tr>
        <?php foreach($events as $e): ?>
        <tr>
            <td>
                <a href="<?php echo $this->createUrl('view',array('id' => $e['Event']['event_id'],'event_type' => $event_type)); ?>" title="view this event"><?php echo (strlen($e['Event']['event_title']) > 30) ? substr($e['Event']['event_title'],0,27).'...' : $e['Event']['event_title']; ?></a>
                <?php //echo (strlen($e['Event']['event_title']) > 30) ? substr($e['Event']['event_title'],0,27).'...' : $e['Event']['event_title']; ?>
            </td>
            <td>
                <?php
                    $start_time = DateTime::createFromFormat('Y-m-d H:i:s', $e['Event']['event_start_time'], new DateTimeZone('UTC'));
                    $start_time->setTimeZone(new DateTimeZone($e['Event']['timezone']));
                    //echo $start_time->format('l h:ia, jS M, Y');
                ?>
                <a href="<?php echo $this->createUrl('view',array('id' => $e['Event']['event_id'],'event_type' => $event_type)); ?>" title="view this event"><?php echo $start_time->format('l h:ia, jS M, Y'); ?></a>
            </td>
            <td>
                <?php
                    echo isset($e['Event']['speaker_name'])?$e['Event']['speaker_name']:'';
                ?>
            </td>
            <td>
                <?php
                    if(count($e['Department']) > 5){
                        echo 'Total '.count($e['Department']).' majors selected';
                    }else{
                        echo isset($e['Department'][0])?implode('<br />',$e['Department']):'';
                    }
                ?>
            </td>
            <td>
                <a href='<?php echo $this->createUrl('edit',array('id' => $e['Event']['event_id'],'event_type' => $event_type)) ?>' title='Edit This Event'>Edit</a>
            </td>
        </tr>
        <?php endforeach; ?>

    </table>

</div>
<?php endforeach; ?>
