<?php
    $this->renderPartial('//_pms_left_menu',array('active' => 'webinar'));
    Yii::app()->clientScript->registerScriptFile(Yii::app()->theme->baseUrl . '/views/layouts/js/jquery.multiselect.min.js');
    Yii::app()->clientScript->registerCssFile(Yii::app()->theme->baseUrl . '/views/layouts/css/jquery/jquery.multiselect.css');
?>
<style>.popup{margin-left: 230px;}</style>
<div class="content">
      
    <ul class="breadcrumb">
        <li><span><?php echo CHtml::link('Manage Webinars', $this->createUrl('index',array('event_type' => $event_type))) ?></span></li>
        <li><span class="divider"> > </span></li>
        <li><span>Edit Webinar</span></li>
    </ul>

    <?php
        foreach(Yii::app()->user->getFlashes() as $key => $message) {
            echo '<div style="padding:10px;margin-bottom:5px;" class="'. $key . '">' . $message . "</div>\n";
        }
    ?>    
    
    
    <ul class="nav nav-tabs">
        <li class="<?php echo $event_type?'':'active'; ?>"><a href="<?php echo $this->createUrl('index'); ?>">UPCOMING WEBINARS</a></li>
        <li class="<?php echo $event_type?'active':''; ?>"><a href="<?php echo $this->createUrl('index',array('event_type' => 1)); ?>">PAST WEBINARS</a></li>
    </ul>        
    
    <div class="container-fluid">
        <?php 
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'edit-event',
                'method' => 'POST',
                'enableAjaxValidation' => false,
                'enableClientValidation' => true,
                'clientOptions' => array(
                    'validateOnSubmit' => true,
                     'validateOnChange' => true,
                     'validateOnType' => false,
                    //'afterValidate' => 'js:function(form, data, hasError){if(hasError){for (var error_id in data) break; console.log(error_id); $("#"+error_id).focus(); return false;} return true;}',
                     'afterValidate' => 'js:afterValidate',
                ),
                'htmlOptions'=>array(
                    'enctype' => 'multipart/form-data',
                ),
            ));
        ?>

        <div class="row-fluid">
            
            <div class="block-body border-bottom">
                
                <div class="form-row">
                    <label class="pull-left span3">Event Title</label>
                    <?php 
                        echo CHtml::textField('title', $event->event_title, array('readonly' => true,'class' => 'input-xxlarge'));
                    ?>
                </div>

                <div class="form-row">
                    <label class="pull-left span3">Event Type</label>
                    <?php 
                        echo $form->dropDownList($event,'event_type',array('webinar' => 'webinar', 'offline' => 'offline'), array('class' => 'input-large'));
                        echo $form->error($event, 'event_type', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Event Start Time</label>
                    <div>
                        <?php 
                            $start_time = DateTime::createFromFormat('Y-m-d H:i:s', $event->event_start_time, new DateTimeZone('UTC'));
                            $start_time->setTimeZone(new DateTimeZone($event->timezone));
                            echo $start_time->format('l h:ia, jS M, Y');
                        ?>
                    </div>
                </div>
                <div style="clear:both"></div>
                
                <div class="form-row">
                    <label class="pull-left span3">Event End Time</label>
                    <div>
                        <?php 
                            $end_time = DateTime::createFromFormat('Y-m-d H:i:s', $event->event_end_time, new DateTimeZone('UTC'));
                            $end_time->setTimeZone(new DateTimeZone($event->timezone));
                            echo $end_time->format('l h:ia, jS M, Y');
                        ?>
                    </div>
                </div>
                <div style="clear:both"></div>
                
                <div class="form-row">
                    <label class="pull-left span3">Event Time Zone</label>
                    <?php
                        echo CHtml::textField('timezone', $event->timezone, array('class' => 'input-xlarge','readonly' => true));
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Event Description</label>
                    <?php 
                        echo CHtml::textArea('desc',$event->event_desc, array('class' => 'input-xxlarge','readonly' => true));
                    ?>
                </div>

                <?php if($event_type == 1): ?>
                
                    <div class="form-row">
                        <label class="pull-left span3">Full Video Link</label>
                        <?php 
                            echo $form->textField($event,'event_video_url',array('class' => 'input-xxlarge','placeholder' => 'Video Link'));
                            echo $form->error($event, 'event_video_url', array('class'=>' errorMessage popup'));
                        ?>
                    </div>
                
                    <?php
                        $pramotional_videos = $event->webinarEventVideos;
                    ?>
                
                    <?php if($pramotional_videos): $first_video = array_shift($pramotional_videos); ?>
                        <div class="form-row" id="_promotional_videos">
                            <label class="pull-left span3 vlabel">Promotional Videos</label>
                            <div class="relative pull-left">
                                <input value="<?php echo $first_video->title; ?>" type="text" maxlength="200" name="promotional_titles[]" class="input-large promotional_titles" placeholder="Video Title" />
                                <div style="display:none; left: 15px;" class="errorMessage popup right"><div class="holder">Invalid video title</div></div>
                            </div>
                            <div class="relative pull-left">
                                <input value="<?php echo $first_video->video_link; ?>" type="text" maxlength="200" name="promotional_videos[]" class="input-large promotional_videos" placeholder="Video Link" />
                                <div style="display:none; left: 248px;" class="errorMessage popup right"><div class="holder">Invalid video link</div></div>
                            </div>
                            
                            <?php
                                echo CHtml::dropDownList('is_promoted[]', $first_video->is_promoted, array('N' => 'Not Promoted', 'Y' => 'Promoted'), array('class' => '_is_promoted input-small'));
                            ?>
                            <a  href="javascript:void(0);" id="add_more_videos">add more..</a>
                        </div>
                
                        <?php foreach($pramotional_videos as $video): ?>
                            <div class="form-row">
                                <label class="pull-left span3 vlabel">&nbsp;</label>
                                <div class="relative pull-left">
                                    <input value="<?php echo $video->title; ?>" type="text" maxlength="200" name="promotional_titles[]" class="input-large promotional_titles" placeholder="Video Title" />
                                    <div style="display:none; left: 15px;" class="errorMessage popup right"><div class="holder">Invalid video title</div></div>
                                </div>
                                <div class="relative pull-left">
                                    <input value="<?php echo $video->video_link; ?>" type="text" maxlength="200" name="promotional_videos[]" class="input-large promotional_videos" placeholder="Video Link" />
                                    <div style="display:none; left: 248px;" class="errorMessage popup right"><div class="holder">Invalid video link</div></div>
                                </div>

                                <?php
                                    echo CHtml::dropDownList('is_promoted[]', $video->is_promoted, array('N' => 'Not Promoted', 'Y' => 'Promoted'), array('class' => '_is_promoted input-small'));
                                ?>
                                <a href="javascript:void(0);" id="remove_video">remove</a>
                            </div>
                
                        <?php endforeach; ?>
                
                    <?php else: ?>
                        <div class="form-row" id="_promotional_videos">
                            <label class="pull-left span3 vlabel">
                                Promotional Videos
                            </label>
                            <div class="relative pull-left">
                                <input type="text" maxlength="200" name="promotional_titles[]" class="input-large promotional_titles" placeholder="Video Title" />
                                <div style="display:none; left: 15px;" class="errorMessage popup right"><div class="holder">Invalid video title</div></div>
                            </div>
                            <div class="relative pull-left">
                                <input type="text" maxlength="200" name="promotional_videos[]" class="input-large promotional_videos" placeholder="Video Link" />
                                <div style="display:none; left: 248px;" class="errorMessage popup right"><div class="holder">Invalid video link</div></div>
                            </div>
                            
                            <select name="is_promoted[]" class="_is_promoted input-small">
                                <option value="N">Not Promoted</option>
                                <option value="Y" selected="selected">Promoted</option>
                            </select>
                            <a  href="javascript:void(0);" id="add_more_videos">add more..</a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <div class="form-row">
                    <label class="pull-left span3">Speaker Name</label>
                    <?php 
                        echo $form->textField($event,'speaker_name',array('class' => 'input-large','placeholder' => 'Speaker Name'));
                        echo $form->error($event, 'speaker_name', array('class'=>' errorMessage popup'));
                        
                        echo $form->dropDownList($event,'speaker_name_visible',array('Y' => 'Yes','N' => 'No'),array('class' => 'input-large','empty' => 'Visible To Student?'));
                        echo $form->error($event, 'speaker_name_visible', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Speaker Designation</label>
                    <?php 
                        echo $form->textField($event,'speaker_designation',array('class' => 'input-large','placeholder' => 'Speaker Designation'));
                        echo $form->error($event, 'speaker_designation', array('class'=>' errorMessage popup'));
                        
                        echo $form->dropDownList($event,'speaker_desig_visible',array('Y' => 'Yes','N' => 'No'),array('class' => 'input-large','empty' => 'Visible To Student?'));
                        echo $form->error($event, 'speaker_desig_visible', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Speaker Organization</label>
                    <?php 
                        echo $form->textField($event,'speaker_org',array('class' => 'input-large','placeholder' => 'Speaker Organization'));
                        echo $form->error($event, 'speaker_org', array('class'=>' errorMessage popup'));
                        
                        echo $form->dropDownList($event,'speaker_org_visible',array('Y' => 'Yes','N' => 'No'),array('class' => 'input-large','empty' => 'Visible To Student?'));
                        echo $form->error($event, 'speaker_org_visible', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Speaker Sign (jpg or png only)</label>
                    <?php
                        echo $form->fileField($event,'speaker_sign',array('accept' => 'image/*'));
                        echo $form->error($event,'speaker_sign');
                    ?>
                </div>
                
                <div class="form-row">
                    <label class="pull-left span3">Applicable Countries</label>
                    <?php 
                        
                        $selected_countries = CHtml::listData($event->tblEventsCountries,'country_ref_id','country_ref_id')?CHtml::listData($event->tblEventsCountries,'country_ref_id','country_ref_id'):array();
                        $options = array();
                        foreach($selected_countries as $country_id){
                            $options[$country_id] = array('selected' => 'selected');
                        }
                    
                        $country_data = CHtml::listData(TblCountryMaster::model()->findAll(array('select' => 'country_id,country_name,is_stud_interested','condition' => 'is_active="Y"','order' => 'is_stud_interested, country_name')), 'country_id', 'country_name');
                        $WebinarEventCountries = new WebinarEventCountries;
                        echo $form->dropDownList($WebinarEventCountries, 'country_ref_id', $country_data, array('multiple' => true, 'class' => 'input-xlarge','options' => $options));
                        echo $form->error($WebinarEventCountries, 'country_ref_id', array('class'=>' errorMessage popup'));
                        $focused_counties = CHtml::listData(Yii::app()->db->createCommand()->from('tbl_country_master')->select('country_id')->where('is_stud_interested = "Y" AND is_active = "Y"')->queryAll(),'country_id','country_id');
                    ?>
                </div>

                <div class="form-row">
                    <label class="pull-left span3">Applicable Majors</label>
                    <?php 
                        $selected_departments = CHtml::listData($event->tblEventsDepartments, 'department_ref_id', 'department_ref_id')?CHtml::listData($event->tblEventsDepartments, 'department_ref_id', 'department_ref_id'):array();
                        $options = array();
                        foreach($selected_departments as $department_id){
                            $options[$department_id] = array('selected' => 'selected');
                        }
                        $major_data = CHtml::listData(LookupDepartment::model()->findAll(array('select' => 'department_id,department_name','condition' => 'is_active="Y" AND parent_dept_id = 0','order' => 'department_name')), 'department_id', 'department_name');
                        $WebinarEventDepartments = new WebinarEventDepartments;
                        echo $form->dropDownList($WebinarEventDepartments, 'department_ref_id', $major_data, array('multiple' => true, 'class' => 'input-xlarge','options' => $options));
                        echo $form->error($WebinarEventDepartments, 'department_ref_id', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
                <?php if($event_type == 1): ?>
                    <div class="form-row">
                        <label class="pull-left span3">Associated Di account</label>
                        <?php 
                            $DiWebinar = DiWebinar::model()->find('webinar_ref_id = :event_id', array(':event_id' => $event->event_id));
                            if(!$DiWebinar) $DiWebinar = new DiWebinar;
                            echo CHtml::dropDownList('DiWebinar[di_ref_id]', $DiWebinar->di_ref_id, $di_accounts, array('class' => 'input-large','empty' => 'Select Di Account'));
                        ?>
                    </div>
                
                    <div class="form-row" id="_di_product" style="display:<?php echo $DiWebinar->di_ref_id?'block':'none'; ?>;">
                        <label class="pull-left span3">Select Di Products</label>
                        <?php 
                            $di_products = array();
                            if($DiWebinar->di_webinar_product_ref_id){
                                $di_products = CHtml::listData(DiWebinarProduct::model()->findAll('di_ref_id = '.$DiWebinar->di_ref_id), 'di_webinar_product_id', 'product_name');
                            }
                            echo CHtml::dropDownList('DiWebinar[di_webinar_product_ref_id]', $DiWebinar->di_webinar_product_ref_id, $di_products, array('class' => 'input-large'));
                        ?>
                    </div>
                
                <?php endif; ?>
                
                <div class="form-row">
                    <label class="pull-left span3">Webinar Active</label>
                    <?php 
                        echo $form->dropDownList($event,'is_active', array('Y' => 'Yes','N' => 'No'), array('class' => 'input-large','placeholder' => 'Speaker Organization'));
                        echo $form->error($event, 'is_active', array('class'=>' errorMessage popup'));
                    ?>
                </div>
                
            </div>
            <?php echo CHtml::submitButton('Save & Preview', array('class' => "btn btn-primary", 'style' => 'margin: 1em 0;')); ?>
            <?php echo CHtml::button('Cancel', array('class' => "btn", 'style' => 'margin: 1em 0;', "onclick"=>"window.location.href='". $this->createUrl('index',array('event_type' => $event_type))."';")); ?>
        </div>
        <?php $this->endWidget(); ?>
    </div>
</div>
    

<script type="text/javascript">

$(function(){
    var focused_countries = '<?php echo implode(',',$focused_counties) ?>';
    $("#WebinarEventCountries_country_ref_id").multiselect({'noneSelectedText':'Select Countries',checkAll:function(event,ui){$(this).val(focused_countries.split(',')); $("#WebinarEventCountries_country_ref_id").multiselect('refresh');}, 'checkAllText':'Select Focused Countries'});
    $("#WebinarEventDepartments_department_ref_id").multiselect({'noneSelectedText':'Select Departments'});
});

$('body').on('click', '#add_more_videos', function(){
    var _video_div = $('#_promotional_videos').clone();
    $(_video_div).find('.vlabel').html('&nbsp;');
    $(_video_div).find('input, select').each(function(){$(this).val('');});
    $(_video_div).removeAttr('id');
    $(_video_div).find('#add_more_videos').remove();
    $(_video_div).append('<a href="javascript:void(0);" id="remove_video">remove</a>');
    $('#_promotional_videos').after(_video_div);
});
$('body').on('click', '#remove_video', function(){
    
    $(this).parent().remove();
});


$('body').on('change', '._is_promoted', function(){var _val = $(this).val(); $('._is_promoted').val(''); $(this).val(_val)});

function afterValidate(form, data, hasError){
    _return = true;
    if(hasError){
        for(var error_id in data)break; 
        console.log(error_id);
        $("#"+error_id).focus();
        _return = false;
    }
    var promotional_videos = new Array;
    $('.promotional_videos').each(function(){
        if($(this).val() !== ''){
            var _link = $(this).val();
            if(!_link.match(/^(?:https?:\/\/)?(?:www\.)?youtube\.com\/watch\?(?=.*v=((\w|-){11}))(?:\S+)?$/)){
                $(this).next('div.errorMessage').html('<div class="holder">Invalid video link</div>').show();
                $(this).parent().addClass('error');
                _return = false;
                if($(this).parent().parent().find('.promotional_titles').val() == ''){
                    $(this).parent().parent().find('.promotional_titles').next('div.errorMessage').html('<div class="holder">Invalid video title</div>').show();
                    $(this).parent().parent().find('.promotional_titles').parent().addClass('error');
                    _return = false;
                }
            }else{
                if($(this).parent().parent().find('.promotional_titles').val() == ''){
                    $(this).parent().parent().find('.promotional_titles').next('div.errorMessage').html('<div class="holder">Invalid video title</div>').show();
                    $(this).parent().parent().find('.promotional_titles').parent().addClass('error');
                    _return = false;
                }
            }
            if($.inArray(_link, promotional_videos) !== -1){
                $(this).parent().addClass('error');
                $(this).next('div.errorMessage').html('<div class="holder">Duplicate video link</div>').show();
                _return = false;
            }
            promotional_videos.push(_link)
        }
    });
    var promotional_titles = new Array;
    $('.promotional_titles').each(function(){
        if($(this).val() !== ''){
            var _link = $(this).parent().next().find('.promotional_videos').val();
            if(_link == '' || !_link.match(/^(?:https?:\/\/)?(?:www\.)?youtube\.com\/watch\?(?=.*v=((\w|-){11}))(?:\S+)?$/)){
                $(this).parent().next().find('.promotional_videos').next('div.errorMessage').html('<div class="holder">Invalid video url</div>').show();
                $(this).parent().next().find('.promotional_videos').parent().addClass('error');
                _return = false;
            }
            
            var _title = $(this).val();
            if($.inArray(_title, promotional_titles) !== -1){
                $(this).parent().addClass('error');
                $(this).next('div.errorMessage').html('<div class="holder">Duplicate title</div>').show();
                _return = false;
            }
            promotional_titles.push(_title)
        }
    });
    
    if(!_return) $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 250 }, 1000);
    
    return _return;
}
$("body").on('focus', 'input, select',function(){$(this).next('div.errorMessage').hide('slow'); $(this).parent().removeClass('error');});

    $('body').on('change', '#DiWebinar_di_ref_id', function(){
        
        if($('#DiWebinar_di_ref_id').val() !== ''){
            $('#_di_product').show();
            $.ajax({
                type: 'get',
                url: '<?php echo $this->createUrl('get_di_products'); ?>?di_id='+$(this).val(),
                success: function(data){$('#DiWebinar_di_webinar_product_ref_id').html(data);}
            });
            
        }else{
            $('#_di_product').hide();
        }
    });
    
</script>