<?php
Yii::app()->clientScript->registerCoreScript('jquery.ui');
$user = TblUserMaster::model()->findByPk($user_id);

$years_12 = array(); $year = date('Y');
if ($user->class_status != 'Completed') {
    for ($i = 0;$i < 5;$i++) {
        $y = $year + $i;
        $years_12[$y] = $y;
    }
} else {
    for ($i = 4;$i >= 0;$i--) {
        $y = $year - $i;
        $years_12[$y] = $y;
    }
}
$year = $user->passout_year ? $user->passout_year : date('Y');
$school_name = '';
if ($user->membership_ref_id == 2 || $user->membership_ref_id == 4) {
    $instData = TblSiDi::GetInstIdFromSchoolId($user->school_ref_id);
    $inst_det = TblSiDi::model()->findByPk($instData->inst_id);
    $school_name = $inst_det->inst_name;
    if ($instData->inst_id) {
        $boardList12 = TblSiBoard::getSchoolBoardByCategory($instData->inst_id, '12');
    } else {
        $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
    }
} else {
    $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
}
$education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$user_id));


$userParams = array('uid' => $user_id,'cityId' => $user->city_ref_id);
$userParam = array('user_id' => $user_id);
?>

<div class="visible clearfix">
    <div class="grid_3 pull small_gutter_r rwd_no_ft text-right small_gutter_t"><strong class="classStatus"> 12th (<?php echo ($user->class_status == 'Completed') ? 'Completed' : 'Expected'; ?>) </strong></div>
    <div class="grid_8 pull small_gutter_r small_gutter_t small">
        <div data-class="12class">
            <div class="gutter_vertical visible clearfix">
                <div class="left small-right relative">
                    <?php
                    $model->school_name_12 = $education_12->school_name ? $education_12->school_name : $school_name ;
                    $this->widget('zii.widgets.jui.CJuiAutoComplete', array(
                        'model' =>$model,
                        'attribute' => 'school_name_12',
                        'source' => $this->createUrl('/myProfile/getSchoolList', $userParams),
                        'options' => array(
                            'minLength' => '2',
                            'select' => "js:function(event, ui) {
                             schoolId = ui.item.id;
                             $('#ProfileData_school_id').val(schoolId);
                            $.post(ibase_url + 'myProfile/getBoardsBySchool', {schoolId:schoolId}, function(resp){
                            $('#ProfileData_board_12').replaceWith(resp);});
                    }",
                    'change' => "js:function(event, ui) {
                        if(ui.item == null){
                        $('#ProfileData_school_id').val('');
                         $.post(ibase_url + 'myProfile/getBoardsBySchool', {schoolId:0}, function(resp){
                            $('#ProfileData_board_12').replaceWith(resp);
                    });
                        }
                    }"
                        ),
                        'htmlOptions' => array(
                            'placeholder' => 'Enter School Name',
                            'class' => 'grid_2'
                        ),
                    ));
                    echo CHtml::hiddenField('ProfileData[school_id]', $user->school_ref_id);
                    echo $form->error($model, 'school_name_12', array('class'=>'popup errorMessage'));
                    ?>
                </div>
                <div class="left small-right relative styledSelect2">
                    <?php
                    $model->year_12 = $education_12->year ? $education_12->year : $user->passout_year;
                    echo $form->dropDownList($model, 'year_12', $years_12, array('empty' => ' Passout year', 'class'=>'grid_2', 'onchange'=>'change_10_year(this.value)'));
                    echo $form->error($model, 'year_12', array("class" => "errorMessage popup"));
                    ?>
                </div>
                <div class="left small-right relative styledSelect2">
                    <?php
                    $model->board_12 = $education_12->board_ref_id;
                    if ($user->present_board_ref_id && !$model->board_12) {
                        $board_det = LookupBoardEquivalent::model()->findByAttributes(array('class_level'=>'12', 'board_ref_id'=>$user->present_board_ref_id));
                        if ($board_det) {
                            $model->board_12 = $board_det->board_equivalent_id;
                        }
                    }

                    echo $form->dropDownList($model, 'board_12', $boardList12, array('empty' => ' Curriculum', 'class'=>'grid_2', 'onchange'=>'getMarks("12", this.value)'));
                    echo $form->error($model, 'board_12', array("class" => "errorMessage popup"));

                    $disp_marks_12 = $disp_marks_gpa_12 = $disp_points_12 = $disp_grades_12 = 'none';
                    if ($education_12->board_ref_id) {

                        $board_12 = LookupBoardEquivalent::model()->findByPk($education_12->board_ref_id);
                        switch ($board_12->overall_type) {
                            case 'Marks':
                                $disp_marks_12 = 'block';
                                $education_12->overall_marks = (float)$education_12->overall_marks;
                                $model->overall_marks_12 = $education_12->overall_marks;
                                break;
                            case 'Marks-GPA':
                                $disp_marks_gpa_12 = 'block';
                                $education_12->overall_marks = (float)$education_12->overall_marks;
                                $model->overall_marks_gpa_12 = $education_12->overall_marks;
                                break;
                            case 'Points':
                                $disp_points_12 = 'block';
                                $education_12->overall_marks = (int)$education_12->overall_marks;
                                $model->overall_points_12 = $education_12->overall_marks;
                                break;
                            case 'Grades':
                                $disp_grades_12 = 'block';
                                break;
                        }
                    } else {
                        $disp_marks_12 = 'block';
                    }
                    ?>
                </div>
                <?php if ($model->board_12) { ?>
                <script>
                    $(document).ready(function(){
                        getMarks("12", <?php echo $model->board_12; ?>);
                    });
                </script>

                <?php } ?>
                <div class="left small-right marks_12 visible  relative " id="12_board_marks" style="display: <?php echo $disp_marks_12; ?>" >
                    <?php
                    echo $form->textField($model,'overall_marks_12', array( 'class'=>'grid_2','placeholder' => 'Score', 'maxlength'=>'3'));
                    echo $form->error($model, 'overall_marks_12', array('class'=>'popup errorMessage'));
                    ?>
                </div>
                <div class="left small-right marks_12 visible  relative " id="12_board_marks-gpa" style="display: <?php echo $disp_marks_gpa_12; ?>">
                    <?php
                    echo $form->textField($model,'overall_marks_gpa_12', array( 'class'=>'grid_2','placeholder' => 'Score', 'maxlength'=>'3'));
                    echo $form->error($model, 'overall_marks_gpa_12', array('class'=>'popup errorMessage'));
                    ?>
                </div>
                <div class="left small-right marks_12 visible relative styledSelect2" id="12_board_points" style="display: <?php echo $disp_points_12; ?>">
                    <?php
                    $pointsList = array();
                    for($i = 45; $i > 0; $i--) {
                        $pointsList[$i] = $i;
                    }
                    echo $form->dropDownList($model, 'overall_points_12', $pointsList, array('empty' => ' Points ', 'class'=>'grid_2'));
                    echo $form->error($model, 'overall_points_12', array('class'=>'popup errorMessage'));
                    ?>
                </div>
                <div class="clearfix grid_8 pull  marks_12" id="12_board_grades" style="display: <?php echo $disp_points_12; ?>">
                    <div class="small"> <?php echo ($user->class_status == 'Completed') ? 'Enter number of Grades Received' : 'Enter number of Grades Expected';?> </div>
                    <?php
                    if ($disp_grades_12 == 'block') {
                        $grade_count = StudentGradeCount::model()->findAll(array('condition' => 'student_education_ref_id = '.$education_12->student_education_id));
                        foreach ($grade_count as $grade) {
                            $ref = $grade['board_conversion_ref_id'];
                            $model->overall_grade_12[$ref] = $grade['grade_count'];
                        }
                    }
                    ?>
                    <?php
                    $grades = LookupBoardConversion::getGradesByBoard(10,true);
                    $alphabet = array('A*','A','B','C','D','E');
                    $j = 0;
                    foreach($grades as $k=>$val) {
                        ?>
                        <div class="left small-right relative styledSelect2" style="width: 85px;">
                            <?php
                            $aa = array();
                            for($i=1;$i<8;$i++){
                                $aa[$i] = $i.' '.$val;
                            }
                            echo $form->dropDownList($model, "overall_grade_12[$k]", $aa, array('empty' => $alphabet[$j], 'class'=>'full-width', 'style'=>'font-family: verdana;'));
                            if($j == 0){
                                echo $form->error($model, "overall_grade_12[$k]", array("class" => "errorMessage popup"));
                            }
                            ?>
                        </div>
                        <?php $j++;} ?>

                </div>
            </div>
        </div>
    </div>
</div>



<script>
    var marks_type = new Array();
    marks_type[31] = marks_type[29] = 'marks-gpa';
    marks_type[10] = marks_type[3]  = 'grades';
    marks_type[12] = marks_type[27] = 'points';
    marks_type[13] = marks_type[20]  = marks_type[18] = marks_type[14] = marks_type[11] = marks_type[17] = marks_type[1] = marks_type[2] = marks_type[4] = marks_type[15] = 'marks';

    var user_id = <?php echo $user_id ?>;
    function getMarks(id, board) {
        var val = marks_type[board];
        if(val) {
            var val = marks_type[board];
        } else {
            var val = 'marks';
        }

        $('.marks_'+id).hide();
        $('#'+id+'_board_'+val).show();
        if (id == 10 && board == 1) {
            $("#ProfileData_overall_marks_"+id).attr("placeholder", "Marks or CGPA");
        }
        else if(board == 20 || board == 18){
            $("#ProfileData_overall_marks_"+id).attr("placeholder", "Overall CGPA");
        }
        else {
            var txtVal = $(".classStatus").html();
            if(id == 10){
                $("#ProfileData_overall_marks_10").attr("placeholder", "Score");
            } else{
                if(txtVal == ' 12th (Expected) ' || board == 31){
                    $("#ProfileData_overall_marks_12").attr("placeholder", "Expected Score");
                    if(board == 31){
                        $("#ProfileData_overall_marks_gpa_12").attr("placeholder", "Expected Score");
                    }
                }else {
                    $("#ProfileData_overall_marks_12").attr("placeholder", " Score");
                }
            }
        }
    }

</script>
