<style>
    #token-input-ProfileData_country_pref_0_pref_location{
        outline: none; width: 400px !important;
        font-size: 12px;
        height: 27px !important;
    }
    ul.token-input-list-facebook{
        width: 480px;
    }
    li.token-input-token-facebook p, div.token-input-dropdown-facebook{
        font-size: 12px !important;
    }
    ul.token-input-list-facebook > li{
        padding: 2px 4px !important;
        line-height: 14px !important;
        font-size: 12px !important;
    }
</style>
<?php
$cs = Yii::app()->clientScript;
$cs->registerCssFile(Yii::app()->baseUrl."/css/token-input-facebook.css");
$cs->registerScriptFile(Yii::app()->baseUrl."/js/jquery.tokeninput.js", CClientScript::POS_END);
Yii::app()->clientScript->registerCoreScript('jquery.ui');

$countriesList = TblCountryMaster::getUnivarietyCountries();
$countries = CHtml::listData($countriesList,'country_id', 'country_name');

$allCountryList = TblCountryMaster::getCountryList();
$uniqueCountryList = array_diff($allCountryList, $countries);
$countries['Others'] = $uniqueCountryList;

$user = TblUserMaster::model()->findByPk($user_id);
$prefCountires = $user->getPreferredCountries();
$keys = array();
foreach($prefCountires as $pref=>$value) {
    $keys[] = $pref;
}
$checked = '';
$studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($user_id);
if ($studentPreferredCountries[0]->not_sure == 1) {
    $checked = 'checked';
}

$checked_dept = '';
$studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($user_id);

if ($studentPreferredDepartments[0]->not_sure == 1) {
    $checked_dept = 'checked';
}
$model->country_pref[0]['countryids'] = $keys[0]; $model->country_pref[1]['countryids'] = $keys[1];
$model->is_location_entered = $user->is_location_entered;
?>
<div class="visible clearfix">
    <div class="grid_3 pull small_gutter_r rwd_no_ft text-right small_gutter_t"><strong>Preferred Countries</strong></div>
    <div class="grid_6 pull small_gutter_r small_gutter_t small">
        <div class="grid_6">
            <?php echo $form->checkBox($model,'country_not_sure', array('style'=>'width:auto; height: auto;','class'=>'left small-right', 'checked' => $checked)); ?> I haven't finalized countries where I want to study
        </div>

        <div class="allCountriessBlock <?php echo $checked ? 'hidden' : '';?>">
            <div class="countrySection clearfix">
                <div class="gutter_vertical">
                    <div class="styledSelect2 left grid_3 small-right gutter_vertical">
                        <?php
                        echo $form->dropDownList($model, 'country_pref[0][countryids]', $countries, array('empty' => '1st preferred country', 'class'=>'full-width selects prefCountry'
                        ));
                        echo $form->error($model, 'country_pref[0][countryids]', array("class" => "errorMessage popup"));
                        ?>
                    </div>
                    <div class="styledSelect2 grid_3 pull right gutter_vertical">
                        <?php
                        echo $form->dropDownList($model, 'country_pref[1][countryids]', $countries, array('empty' => '2nd preferred country', 'class'=>'full-width selects prefCountry'
                        ));
                        echo $form->error($model, 'country_pref[1][countryids]', array("class" => "errorMessage popup"));
                        ?>
                    </div>
                </div>
            </div>

            <div style="display: block" class="scholarshipSection gutter_vertical clearfix">
                <div class="left small-right small_gutter_t small clearfix scholarshipText width_pnew">
                    Do you have any specific locations where you want to study ?
                </div>
                <div class="right small_gutter_t">
                <div class="right  styledSelect2" style="width: 100px;">
                    <?php
                    echo $form->dropDownList($model, 'is_location_entered', array('Y'=>'Yes','N'=>'No'), array('empty' => 'Select', 'class'=>'full-width'
                    ));
                    echo $form->error($model, 'is_location_entered', array("class" => "errorMessage popup"));
                    ?>
                </div></div>
            </div>
            <div class="visible <?php ($model->is_location_entered == 'N') ? 'hidden' : ''; ?>">
                <div class="prefLocationDiv relative">
                    <?php
                    echo $form->textField($model,"country_pref[0][pref_location]", array('class' => 'full-width input pref_location') );
                    echo $form->error($model, "country_pref[0][pref_location]", array('class'=>'popup errorMessage'));
                    ?>
                </div>
            </div>
        </div>

    </div>
</div>
<?php
foreach($studentPreferredCountries as $studentPreferredCountry) {
    if($studentPreferredCountry->country_ref_id)
    {
        if($studentPreferredCountry->preference_order == 1) {
            $locations = StudentPreferredLocation::studentPreferredLoc($user_id, $studentPreferredCountry->preferred_country_id);
            $subOptions = array();
            foreach($locations as $val) {
                if($val->city_name){
                    $subOptions[] = array('id'=>'c'.$val->city_ref_id, 'name'=>$val->city_name); // c for city
                }
                if($val->name){
                    $subOptions[] = array('id'=>'s'.$val->state_ref_id, 'name'=>$val->name);     // s for state
                }
                if($val->region_name){
                    $subOptions[] = array('id'=>'r'.$val->region_ref_id, 'name'=>$val->region_name);  // r for region
                }
                if($val->cluster_name){
                    $subOptions[] = array('id'=>'t'.$val->cluster_ref_id, 'name'=>$val->cluster_name);  // t for cluster
                }
            }
        }
        if($studentPreferredCountry->preference_order == 2) {
            $locations = StudentPreferredLocation::studentPreferredLoc($user_id, $studentPreferredCountry->preferred_country_id);
            $subOptions2 = array();
            foreach($locations as $val) {
                if($val->city_name){
                    $subOptions2[] = array('id'=>'c'.$val->city_ref_id, 'name'=>$val->city_name); // c for city
                }
                if($val->name){
                    $subOptions2[] = array('id'=>'s'.$val->state_ref_id, 'name'=>$val->name);     // s for state
                }
                if($val->region_name){
                    $subOptions2[] = array('id'=>'r'.$val->region_ref_id, 'name'=>$val->region_name);  // r for region
                }
                if($val->cluster_name){
                    $subOptions2[] = array('id'=>'t'.$val->cluster_ref_id, 'name'=>$val->cluster_name);  // t for cluster
                }
            }
        }
    }
}
$locations = array_merge($subOptions,$subOptions2);
?>
<script>
    var CountryLocationOptions = <?php echo json_encode($locations); ?>;
    $(function(){
        $('.prefCountry').on('change', function() {
            var $self = $(this), selectedVal = $self.val();
            var parent = $self.closest('div.countrySection');
            // clear exsiting tokens
            $('#ProfileData_country_pref_0_pref_location').tokenInput('clear');
        })

        $(".pref_location").tokenInput(
                function(){
                    var country1 = $("#ProfileData_country_pref_0_countryids").val() ? $("#ProfileData_country_pref_0_countryids").val() : 0;
                    var country2 = $("#ProfileData_country_pref_1_countryids").val() ? $("#ProfileData_country_pref_1_countryids").val() : 0;
                    return 'myProfile/getPrefLocations?cid='+ country1+','+country2;
                },
                {theme: "facebook", placeholder: 'Enter preferred cities/states/zones in selected countries', preventDuplicates: true, hintText: 'Type to search',
                    tokenLimit: 4,
                    prePopulate: CountryLocationOptions
                }
        );
    })
    
    $('#ProfileData_country_not_sure').change(function() {
        if($(this).is(':checked')) {
            $("#ProfileData_country_pref_0_countryids").val('');
            $("#ProfileData_country_pref_1_countryids").val('');
            $("#ProfileData_is_location_entered").val('');
            $(".allCountriessBlock").hide('');
        }
        else {
            $(".allCountriessBlock").show('');
            $(".allCountriessBlock").css({"overflow":"inherit"});
        }
    });

    $('#ProfileData_is_location_entered').change(function() {
        if($(this).val() == 'N') {
            $('.prefLocationDiv').hide();
        } else{
            $('.prefLocationDiv').show();
        }
    });
</script>