<?php

class EmailController extends Controller
{
    
    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights', // perform access control for CRUD operations
        );
    }
    
    /**
     * Declares class-based actions.
     */
    public function actions()
    {
        return array(
        // captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
              'class' => 'CCaptchaAction',
              'backColor' => 0xFFFFFF
        ),
        // page action renders "static" pages stored under 'protected/views/site/pages'
        // They can be accessed via: index.php?r=site/page&view=FileName
           'page' => array(
             'class' => 'CViewAction'
             )
             );
    }

    public function actionBrowser($k)
    {

        $result =  EmailRecipient::model()->findByUniqueKey($k);

        if($result)
        {
            $emailMessage = $result->emailMessageRef;
            $model = new EmailRecipient;
            $model->updateAll(array('opened_on' => date('Y-m-d H:i')),'unique_key=:key', array(':key' => $k));
            $bodyMessage = $emailMessage->attributes['body'];
             
            $this->renderPartial('browser',array('emailMessage'=>$emailMessage));
        }
        else
        {
            throw new CHttpException(404,'The requested page does not exist.');
        }
    }

    public function actionUnSubscribe($email)
    {
        $model= new EmailUnsubscribe;
        $result =  EmailRecipient::model()->findByEmail($email);
        $emailMessage = $result->emailMessageRef;
        $emailTypeRefId = $emailMessage->attributes['email_type_ref_id'];
        $emailTypeResult = EmailType::model()->findByPk($emailTypeRefId);
        $catagory = $emailTypeResult->attributes['category'];

        // uncomment the following code to enable ajax-based validation
        /*
         if(isset($_POST['ajax']) && $_POST['ajax']==='email-recipient-unsubscribe-form')
         {
         echo CActiveForm::validate($model);
         Yii::app()->end();
         }
         */

        if(!empty($_POST['EmailUnsubscribe']))
        {
            $model->attributes = $_POST['EmailUnsubscribe'];
            $emailCount   = EmailUnsubscribe::model()->getUnsubscribeCount($email);
            //$model->validate();

            //if(!$emailCount && $model->validate())
            if(!$emailCount)
            {
                $model->save();
                echo "<script>window.location = 'thankyou/msg/unsubscribe/category/".$catagory."'</script>";
            }
            else
            {
                echo "<script>window.location = 'thankyou/msg/unsubscribe/category/".$catagory."'</script>";
            }
        }

        $this->render('unsubscribe',array('model'=>$model,'email'=>$email,'catagory'=>$catagory));
    }

    public function actionResponse($k,$res)
    {
        $result =  EmailRecipient::model()->findByUniqueKey($k);
         
        if($result)
        {
            $emailTypeId = $result->emailMessageRef->email_type_ref_id;
            $response = EmailTypeResponse::model()->getEmailResponse($emailTypeId,$res);
            $emailResponseValues = EmailTypeResponse::model()->getEmailResponses($emailTypeId);

            if($response)
            {
                $emailTypeRefId = $response->emailTypeRef;
                $isChangable = $emailTypeRefId->attributes['is_response_changable'];
                $emailTypeResponseId = $response->email_type_response_id;
                $countResponse = $result->email_type_response_ref_id;


                if($countResponse == 0 && $isChangable == 0)
                {
                    EmailRecipient::model()->updateAll(array('email_type_response_ref_id' => $emailTypeResponseId),'unique_key=:key', array(':key' => $k));
                    $this->render('response',array('emailResponseValues' =>$emailResponseValues,'res'=>$res,'k' =>$k));
                }
                if($countResponse >= 1 && $isChangable == 0)
                {
                    $this->render('response',array('emailResponseValues' =>$emailResponseValues,'res'=>$res,'notChangable'=>1));
                }
                else if($isChangable == 1)
                {
                    EmailRecipient::model()->updateAll(array('email_type_response_ref_id' => $emailTypeResponseId),'unique_key=:key', array(':key' => $k));
                    $this->render('response',array('emailResponseValues' =>$emailResponseValues,'res'=>$res,'k' =>$k));
                }
            }
            else
            {
                throw new CHttpException(404,'The requested page does not exist.');
            }
             
        }

    }

    public function actionResponseUpdate()
    {

        if($_POST)
        {
            $uniqueKey = $_POST['unique_key'];
            $response  = $_POST['response'];
            $result =  EmailRecipient::model()->findByUniqueKey($uniqueKey);
            if($result)
            {
                $emailTypeId = $result->emailMessageRef->email_type_ref_id;
                $response = EmailTypeResponse::model()->getEmailResponse($emailTypeId,$response);

                if($response)
                {
                    $emailTypeResponseId = $response->email_type_response_id;
                    EmailRecipient::model()->updateAll(array('email_type_response_ref_id' => $emailTypeResponseId),'unique_key=:key', array(':key' => $uniqueKey));
                    $this->redirect(Yii::app()->params['cbasepath']);
                }
            }
        }
    }

    public function actionImageView($k)
    {
        $model = new EmailRecipient;
        $model->updateAll(array('opened_on' => date('Y-m-d H:i')),'unique_key=:key', array(':key' => $k));

    }

    public function actionAddMessage()
    {
       if(!isset($_POST['EmailMessage']))
        {
            echo 'Invalid Request';
        }
        else
        {           
			extract($_POST);
			            	
            $key =  Yii::app()->params['emailCron']['curlKey'];
            if($EmailMessage['apiKey'] == $key && !empty($EmailMessage['toEmail']))
            {
                $header = $this->renderPartial('_header','',true);
                $footer = $this->renderPartial('_footer','',true);

                $EmailMessage['body'] = $header.$EmailMessage['body'].$footer;			
                $EmailMessage['siteUrl'] = $this->createAbsoluteUrl('/');
                $email  = new EmailMessage;
                $result = $email->addEmailMessage($EmailMessage);
                	
                if ($result)
                {
                    //echo 'Success';
                }
                else
                {
                    echo 'Error occured';
                }

                return true;
            }
            else
            {
                echo 'Authentication failed';
            }
        }         
    }

    public function actionThankyou($msg,$category)
    {
        $this->render('thankyou',array('msg'=>$msg,'category'=>$category));
    }
    public function actionHelpful($k,$res)
    {

        $model = new EmailRecipient;
        //if($res == 0)
        // {
        $this->render('comment',array('key' => $k,'res' => $res));
        //}
        $model->updateAll(array('is_helpful' => $res,'feedback_comment' => ''),'unique_key=:key', array(':key' => $k));
    }

    public function actionComment()
    {
        $model = new EmailRecipient;
        //print_r($_POST['Comment']);
        if($_POST['Comment'])
        {
            $comment = $_POST['Comment'];
            $model->updateAll(array('feedback_comment' => $comment['comments']),'unique_key=:key', array(':key' => $comment['unique_key']));
            echo "Successfully added comment";
            $this->redirect(Yii::app()->params['cbasepath']);
        }
    }
     
    /*
     *
     * The studentWidget form updates is submitted here
     */

    public function actionStudentWidgetFormSave()
    {

        extract($_POST);

         
        //return true;
         

        //   	if(!$name)
        //   	{
        //   	  $error .= '<li>Please enter your name</li>';
        //   	}

        if(!$email)
        {
            $error .= '<li>Please enter your email</li>';
        }else if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
            $error .= '<li>Please enter a valid email</li>';
        }

        if(!$phone)
        {
            $error .= '<li>Please enter your phone number</li>';
        }else if(!filter_var($phone, FILTER_VALIDATE_REGEXP, array(
        	"options" => array('regexp' => "/^\d{6,12}$/")
        ))){
            $error .= '<li>Please enter a valid phone number</li>';
        }
        
         
        // ToDo get the user from session. remove the hardcode line
        //$user = Yii::app()->user->getUser();
         
        $login = LoginMaster::model()->findByPk(Yii::app()->user->id);
        $user = $login->getUserMaster();
         
         
        $isDuplicate = LoginMaster::model()->isDuplicateEmail($email, $login->login_id);
         
        if($isDuplicate)
        {
            $error = '<li>This email is already registered with univariety</li>';
        }
         
        if($error)
        {
            $this->renderPartial('studentWidgetFormSave', array('error' => '<ul>'.$error.'</ul>'));
        }
        else
        {
            //TODO: #994 removed save email or phone Fields
			$login->username     = $email;
            $user->primary_phone = $phone;
            $user->save(false);
            $login->save(false);
            $this->renderPartial('studentWidgetFormSave', array('login' => $login));
        }
        	
    }
     
    /*
     *
     * The studentHypotheses form is submitted here
     */

    public function actionStudentHypothesesSave()
    {
        print_r($_POST);
    }

    // auto complete action for course
    public function actionCourse(){
         
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term)
        {
            $term = mysql_escape_string($term);
            $sql = 'SELECT main_dept_id, popular_subdept_course_id  AS id, `course_name` AS "value", `sub_department_ref_id`  FROM `lookup_popular_subdept_course`  join `lookup_department` where LCASE(`course_name`) LIKE :course_name and `sub_department_ref_id` = `department_id`  ORDER BY (CASE WHEN course_name LIKE "' . $term . '%" THEN 0 ELSE 1 END ), course_name limit 0,10' ;
            $cmd = Yii::app()->db->createCommand($sql);
            $cmd->bindValue(":course_name","%".strtolower($term)."%", PDO::PARAM_STR);
            $res = $cmd->queryAll();
        }
        echo CJSON::encode($res);
        Yii::app()->end();
    }

    /*
     *
     * The studentQuestions form is submitted here
     */

    public function actionStudentQuestionsSave()
    {
        if(!isset($_POST['StudentQuestion'])){
            Yii::app()->end();
        }
        
        $userId = Yii::app()->user->sub_id;
        $studentQuestions = $_POST['StudentQuestion'];
        $qCnt = 0;
        
        //Add to umail
        $basepath = Yii::app()->getBasePath().'/../..';
        require_once ($basepath."/page_include/inc_questions_to_umail.php");
        
        foreach($studentQuestions as $question){
            if(empty($question['question_text'])){
                continue;
            }
            $studentQuestion = new StudentQuestion;
            $studentQuestion->attributes = $question;
            $studentQuestion->user_ref_id = $userId;
            $studentQuestion->modified_on = $studentQuestion->added_on = date('Y-m-d H:i:s');
            $bl = $studentQuestion->save();
            
            //Adding umail.
            sendUserQuestionAsUmail(htmlentities($question['question_text'], ENT_QUOTES, "UTF-8"), $userId, $question['question_category_ref_id']);
            $qCnt++;
        }
        if($qCnt == 0){
            $op['message'] = '<div class="error" style=" color: #f00;">Please enter atleast one question</div>';
        }else{
            $op['message'] = '<div class="success">Your questions are successfully posted</div>';
        }
        echo $op['message'];
    }

    /*
     *
     * The studentCountryPreferenses form is submitted here
     */

    public function actionStudentCountryPreferencesSave()
    {
        $userId = Yii::app()->user->sub_id;
         
        $user = TblUserMaster::model()->findByPk($userId);
        $result = $user->setPreferredCountries($_POST['country']);
         
        if(true == $result)
        {
            $user = TblUserMaster::model()->findByPk($userId);
            $this->renderPartial('studentCountryPreferencesSave', array('data' => $user->getPreferredCountries()));
        }
        else
        {
            $this->renderPartial('studentCountryPreferencesSave', array('error' => $result), false, true);
        }
         
    }

    /*
     *
     * The studentCoursePreferences Widget form is submitted here
     */

    public function actionStudentCoursePreferencesSave()
    {
         
        $userId = Yii::app()->user->sub_id;
         
        $user = TblUserMaster::model()->findByPk($userId);
        //   	$user->setPreferredCountries($_POST['country']);
        $careerids = array();
        $countryids = array();
        extract($_POST);		
        foreach($courseids as $id)
        {
            if(empty($id))    continue;
            $course = explode('|', $id);
            $list[$course[2]]['main_dept_ref_id'] = $course[1];
            $list[$course[2]]['sub_dept_ref_id'] = $course[0];
        }
        $list1 = array();
        foreach($careerids as $id)
        {
            if(empty($id))    continue;
            $career = explode('|', $id);
            if($career[2])
            {
                $list1[$career[2]]['main_dept_ref_id'] = $career[1];
                $list1[$career[2]]['sub_dept_ref_id'] = $career[0];
            }
        }
		 $i = 0;
		 $countryList = array();
		 foreach($countryids as $countryid)
         {  
			if(!empty($countryid))
            {
                $countryList[$i] = $countryid;                
            }
			$i++;
        }
        $result = $user->setPreferredCourses($list);
        
        //if(count($list1)>0){
         $result1 = $user->setPreferredCareers($list1);
		 
		 $result1 = $user->setPreferredCountries($countryList);
        //}
        
        if(true == $result)
        {
            // Save to student milestone table for future reference.
            $userMilestone = new UserMilestone;
            $userMilestone->user_ref_id = $userId;
            $userMilestone->milestone_id = 1;
            $userMilestone->status = UserMilestone::STATUS_CONFIRMED;
            $x = $userMilestone->checkNSave();
            
            $user = TblUserMaster::model()->findByPk($userId);
            
            $this->renderPartial('studentCoursePreferencesSave', array('careers' => $user->getPreferredCareers(),'data' => $user->getPreferredCourses(),'countries' => $user->getPreferredCountries()));
        }
        else
        {
            $this->renderPartial('studentCoursePreferencesSave', array('error' => $result));
        }
    }

    // auto complete action for career
    public function actionCareer(){

        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term)
        {
            $term = mysql_escape_string($term);
            $sql = "SELECT main_dept_ref_id, career_id, career_name AS 'value', `sub_dept_ref_id`  FROM `lookup_career` where LCASE(`career_name`) LIKE :career_name ORDER BY (CASE WHEN career_name LIKE '$term%' THEN 0 ELSE 1 END ), career_name limit 0,10";
            $cmd = Yii::app()->db->createCommand($sql);
            $cmd->bindValue(":career_name","%".strtolower($term)."%", PDO::PARAM_STR);
            $res = $cmd->queryAll();
        }
        
        echo CJSON::encode($res);
        Yii::app()->end();
    }
	
	public static function getInstituteLogo($fldInstLogo)
	{		
		if($fldInstLogo != "")
		{
			 $siteURL =  CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
			 $logoPath		=  $siteURL."/uploads/institute/logos/".$fldInstLogo;
			
			
			if(!file_exists($logoPath))
			{
				//$logoPath	= $siteURL."/images/no_uni_logo.jpg";
			}
			$fldInstLogoSrc	= $logoPath;
			return $fldInstLogoSrc;
		}
	}

}

