<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 62);
$milestone = UserMilestone::model()->find($criteria);
?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 6,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->
		<?php 
		    $msId = 62;
		    for($i = 61; $i < 64; ++$i):
		?>
			<a class="alertbutton<?php echo ($msId == $i) ? ' on': ''; ?>" href="<?php echo Yii::app()->createUrl('sms/milestone/ms' . $i . 'Helper', array('studentId' => $student->user_id)); ?>">Step <?php echo $i - 60; ?></a>
		<?php 
		    endfor;
		?>
		</div>
		<div class="clear">&nbsp;</div>

		
		<?php
           if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>
		Student did not finish this milestone yet.
		</div>
		<?php
		    else:
		?>
		
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="adminform" >
          <tr>
            <th scope="col" width="50%">Confirmed date - <?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?></th>
            <th scope="col" width="50%" style="text-align:right;">
				  <?php
						/*echo CHtml::ajaxButton(
							"Invalidate", 
							Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
							array ( 
								'type' => 'POST',
								'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
								'dataType' => 'json',
								'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
								'beforeSend' => 'js:  function(){ }',
								'complete' => 'js:  function(){ }',
							),
							array(
								'id' => 'invalidate-button',
								'class' =>'alertbutton on' 
							)
						);
						*/
						
					?>          
            </th>
          </tr>
        </table>  
        <div class="clear">&nbsp;</div>
		 <div class="datagrid3">
		 <?php 
	    // Lists to display.
$listTypes = array(
    StudentIdealList::TYPE_ASPIRATIONAL,
    StudentIdealList::TYPE_BEST_FIT,
    StudentIdealList::TYPE_SAFE
);

$listLabels = StudentIdealList::getTypeLabels();

?>
        <table width="100%" border="0" cellspacing="1" cellpadding="0" >
          <tr>
          <?php 
              foreach($listTypes as $listType):
          ?>
            <th scope="col" width="30%"><?php echo $listLabels[$listType]; ?></th>
         <?php 
             endforeach;
         ?>
          </tr>
          <tr>
          <?php 
              foreach($listTypes as $listType):
          ?>
            <td scope="col" width="30%">
            <?php 
                switch($listType){
                    case StudentIdealList::TYPE_ASPIRATIONAL:
                            $list = $student->admissionReceivedAspirationalUniversities;
                            break;
                    case StudentIdealList::TYPE_BEST_FIT:
                            $list = $student->admissionReceivedBestFitUniversities;
                            break;
                    case StudentIdealList::TYPE_SAFE:
                            $list = $student->admissionReceivedSafeUniversities;
                            break;
        	    }
            ?>
            	<ul>
					<?php
                        foreach($list as $university):
                    ?>
                        <li style="padding:5px;">
                            <?php echo $university->uni_ref_id ? $university->university->uni_name: $university->uni_name; ?>
                        </li>
                    <?php
                        endforeach;
                    ?>
                </ul>
            </td>
            <?php 
                endforeach;
            ?>
          </tr>
        </table>
        </div>
		<?php 
		endif;
		?>
	</div>
</div>


