<?php
$cs=Yii::app()->clientScript;
$cs->registerCoreScript('yiiactiveform');

$cs->registerScriptFile('//ajax.googleapis.com/ajax/libs/angularjs/1.3.15/angular.min.js', CClientScript::POS_HEAD);
$cs->registerScriptFile('//ajax.googleapis.com/ajax/libs/angularjs/1.3.15/angular-sanitize.min.js', CClientScript::POS_HEAD);
$cs->registerScriptFile(Yii::app()->baseUrl."/js/careerplan-app.js", CClientScript::POS_HEAD);
$cs->registerCssFile(Yii::app()->baseUrl."/css/careerplan-app.css");
$cs->registerCssFile(Yii::app()->baseUrl."/css/angular-slick.css");

$cs->registerCssFile(Yii::app()->baseUrl."/css/token-input-facebook.css");
$cs->registerScriptFile(Yii::app()->baseUrl."/js/jquery.tokeninput.js", CClientScript::POS_END);

$cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.mousewheel-3.0.6.pack.js', CClientScript::POS_END);
$cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.pack.js', CClientScript::POS_END);
$cs->registerCssFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.css');
$cs->registerScriptFile('//maps.googleapis.com/maps/api/js?libraries=places&sensor=false', CClientScript::POS_END);
$cs->registerScriptFile('//cdn.jsdelivr.net/jquery.slick/1.5.0/slick.min.js', CClientScript::POS_END);
$cs->registerScriptFile(Yii::app()->baseUrl."/js/angular-slick.js", CClientScript::POS_END);

?>
<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/less/hover-mask.css" />
<link href="/app/themes/new_grid_theme/views/layouts/less/jquery.circliful.css" rel="stylesheet" type="text/css" />
<script src="/app/themes/new_grid_theme/views/layouts/javascript/jquery.circliful.js"></script>

<div class="clearfix browser-fix" ng-app="carrerPlanApp" style="min-height: 550px">
    <h2 class="center uppercase">Your customised career plan</h2>
    <h4 class="normal center gutter_vertical">Here's a step by step personalised career planning schedule</h4>
    <div class="row gutter_vertical hidden" id="customcareerplan" ng-controller="careerPlanCtrl">

        <div class="row multi_line gutter_vertical center" ng-show="showloading" style="margin-top: 100px">
            <i class="fa fa-spinner fa-spin fa-4x"></i>
        </div>

        <div ng-hide="showloading">

            <div class="grid_3 pull small_gutter_r row multi_line small-gutter dark-gray no-clear fixed-height-block color5 on relative" data-hook='profile_complete_info' onclick="location='/app/myProfile'">
                <div class="view view-fifth">
                    <div class="main-slide">
                        <div id="profileCompletion" class="color-white" data-dimension="220" data-text="{{profileScore}}%" data-info="Profile Completed" data-width="10" data-fontsize="40" data-percent="{{profileScore}}" data-fgcolor="#ffffff" data-bgcolor="#69c5ff" data-fill="#5096c2"></div>
                    </div>
                    <div class="mask color5 row multi_line small-gutter color-white">
                        <div class="div-inner-gutter-space">
                            <div class="div-inner-gutter-space" style="margin-top: 30px;">
                                <h3 class="uppercase center">Profile</h3>
                                <h4 class="uppercase center thin">View / Edit</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="stepBlock grid_3 pull small_gutter_r row multi_line small-gutter dark-gray no-clear fixed-height-block relative"
             ng-repeat="Step in planningSteps"
             ng-class="{ {{Step.colorcls}} : Step.complete || selectedstep==Step.stepname, 'activeBlock' : selectedstep==Step.stepname}"
             ng-click="goToView(Step.stepname);">
            <div class="color-white view view-fifth">
                <div class="main-slide">
                    <h4 class="gutter_vertical">{{$index + 1}}
                        <span class="right" ng-if="Step.complete"><i class="fa fa-check fa-lg"></i></span>
                    </h4>
                    <div class="uppercase border-bottom div-inner-gutter-space">
                        <span class="{{Step.iconcls}} fixed-block left small-right">&nbsp;</span>
                        <strong>{{Step.title}} </strong>
                    </div>
                    <div ng-if="!Step.complete" class="small_gutter_t">
                        <div>
                            <i class="fa fa-clock-o fa-lg small_gutter_r"></i>
                            <span ng-if="Step.timeleft[2] == 'passed'">
                                <span class="strike">{{Step.date}}</span>
                                <span class='small'>(Date Missed)</span>
                            </span>
                            <span ng-if="Step.timeleft[2] != 'passed'">
                                <span class="">{{Step.date}}</span>
                                <span class='small'>({{Step.timeleft.join(' ')}})</span>
                            </span>
                        </div>
                        <div><i class="fa fa-exclamation-triangle fa-lg small_gutter_r"></i> Incomplete</div>
                    </div>
                    <div ng-if="Step.complete" class="small_gutter_t">
                        <div>&nbsp;</div>
                        <div>Completed</div>
                    </div>
                </div>
                <div class="mask {{Step.colorcls}} row multi_line small-gutter">
                    <h4 class="">{{$index + 1}}</h4>
                    <div class="div-inner-gutter-space" ng-if="Step.complete" style="margin-top: 30px;">
                        <h3 class="center uppercase">Completed</h3>
                        <h4 class="uppercase center thin">View / Edit</h4>
                    </div>
                    <div ng-if="!Step.complete">
                        <div class="large-font center">{{Step.timeleft[0]}}</div>
                        <h4 class="uppercase center thin">{{Step.timeleft[1]}} {{Step.timeleft[2]}}</h4>
                        <h3 class="center uppercase">Complete Now</h3>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>

    <?php
        $this->render('careerplan_partials/cp_finalize_country_tmpl');
        $this->render('careerplan_partials/cp_finalize_major_tmpl');
        $this->render('careerplan_partials/cp_identify_test_tmpl');
        $this->render('careerplan_partials/cp_coaching_center_tmpl');
        $this->render('careerplan_partials/cp_shortlist_college_tmpl');
        $this->render('careerplan_partials/cp_application_status_tmpl');
        $this->render('careerplan_partials/cp_admission_status_tmpl');
    ?>
</div>

<div id="overlayDiv" style="display:none;background: none repeat scroll 0% 0% rgba(51, 51, 51, 0.5); width: 100%; height: 100%; top: 0px; left: 0px; position: fixed; z-index: 99999;"></div>

