<?php
$cs=Yii::app()->clientScript;

$cs->registerScriptFile('//ajax.googleapis.com/ajax/libs/angularjs/1.3.15/angular.min.js', CClientScript::POS_HEAD);
$cs->registerScriptFile('//ajax.googleapis.com/ajax/libs/angularjs/1.3.15/angular-sanitize.min.js', CClientScript::POS_HEAD);

$cs->registerScriptFile(Yii::app()->baseUrl."/js/careerplan-app.js", CClientScript::POS_HEAD);
$cs->registerCssFile(Yii::app()->baseUrl."/css/careerplan-app.css");
$cs->registerCssFile(Yii::app()->baseUrl."/css/angular-slick.css");

$cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.mousewheel-3.0.6.pack.js', CClientScript::POS_END);
$cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.pack.js', CClientScript::POS_END);
$cs->registerCssFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.css');

$cs->registerScriptFile('//maps.googleapis.com/maps/api/js?libraries=places&sensor=false', CClientScript::POS_END);
$cs->registerScriptFile('//cdn.jsdelivr.net/jquery.slick/1.5.0/slick.min.js', CClientScript::POS_END);
$cs->registerScriptFile(Yii::app()->baseUrl."/js/angular-slick.js", CClientScript::POS_END);

?>
<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/less/hover-mask.css" />

<div class="clearfix browser-fix" ng-app="carrerPlanApp" style="min-height: 250px">
    <h2 class="center uppercase">Your customised career plan</h2>
    <h4 class="normal center gutter_vertical">Here's a step by step personalised career planning schedule</h4>
    <div class="row gutter_vertical hidden" id="customcareerplan" ng-controller="careerPlanCtrl">

        <div class="row multi_line gutter_vertical center" ng-show="showloading" style="margin-top: 50px">
            <i class="fa fa-spinner fa-spin fa-4x"></i>
        </div>

        <div ng-hide="showloading">


            <div class="stepBlock grid_3 pull small_gutter_r row multi_line small-gutter dark-gray no-clear fixed-height-block relative"
             ng-repeat="Step in planningSteps"
             ng-class="{ {{Step.colorcls}} : Step.complete || selectedstep==Step.stepname, 'activeBlock' : selectedstep==Step.stepname}"
             ng-click="goToView(Step.stepname);">
            <div class="color-white view view-fifth">
                <div class="main-slide">
                    <h4 class="gutter_vertical">{{$index + 1}}
                        <span class="right" ng-if="Step.complete"><i class="fa fa-check fa-lg"></i></span>
                    </h4>
                    <div class="uppercase border-bottom div-inner-gutter-space">
                        <span class="{{Step.iconcls}} fixed-block left small-right">&nbsp;</span>
                        <strong>{{Step.title}} </strong>
                    </div>
                    <div ng-if="!Step.complete" class="small_gutter_t">
                        <div>
                            <i class="fa fa-clock-o fa-lg small_gutter_r"></i>
                            <span ng-if="Step.timeleft[2] == 'passed'">
                                <span class="strike">{{Step.date}}</span>
                                <span class='small'>(Date Missed)</span>
                            </span>
                            <span ng-if="Step.timeleft[2] != 'passed'">
                                <span class="">{{Step.date}}</span>
                                <span class='small'>({{Step.timeleft.join(' ')}})</span>
                            </span>
                        </div>
                        <div><i class="fa fa-exclamation-triangle fa-lg small_gutter_r"></i> Incomplete</div>
                    </div>
                    <div ng-if="Step.complete" class="small_gutter_t">
                        <div>&nbsp;</div>
                        <div>Completed</div>
                    </div>
                </div>
                <div class="mask {{Step.colorcls}} row multi_line small-gutter">
                    <h4 class="">{{$index + 1}}</h4>
                    <div class="div-inner-gutter-space" ng-if="Step.complete" style="margin-top: 30px;">
                        <h3 class="center uppercase">Completed</h3>
                        <h4 class="uppercase center thin">View / Edit</h4>
                    </div>
                    <div ng-if="!Step.complete">
                        <div class="large-font center">{{Step.timeleft[0]}}</div>
                        <h4 class="uppercase center thin">{{Step.timeleft[1]}} {{Step.timeleft[2]}}</h4>
                        <h3 class="center uppercase">Complete Now</h3>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>

    <?php
        $this->render('careerplan_partials/cp_shortlist_career_tmpl');
        $this->render('careerplan_partials/cp_shortlist_stream_tmpl');
        $this->render('careerplan_partials/cp_identify_test_tmpl', array('hideMockTest'=>true));
        $this->render('careerplan_partials/cp_coaching_center_tmpl');
    ?>
</div>

<div id="overlayDiv" style="display:none;background: none repeat scroll 0% 0% rgba(51, 51, 51, 0.5); width: 100%; height: 100%; top: 0px; left: 0px; position: fixed; z-index: 99999;"></div>

