<?php
Yii::import('application.modules.managewebinar.models.*');

class DashboardController extends Controller {

    public $userId, $loginRefId = 0;
    public $imageUploadErrorMessage = '';
    public $userImage = '';
    public $isUserImageAvailable = false;
    public $isUploading = false;
    public $userParams = array();
    public $userData;
    public $defaultUserData = array('M' => array('gender' => 'Male', 'defaultImage' => 'user_img_male.jpg'), 'F' => array('gender' => 'Female', 'defaultImage' => 'user_img_female.jpg'));

    public $dates_val = array(1=>'01', 2=>'02', 3=>'03', 4=>'04', 5=>'05', 6=>'06', 7=>'07', 8=>'08', 9=>'09', 10=>10, 11=>11, 12=>12, 13=>13, 14=>14, 15=>15, 16=>16, 17=>17, 18=>18, 19=>19, 20=>20, 21=>21, 22=>22, 23=>23, 24=>24, 25=>25, 26=>26, 27=>27, 28=>28, 29=>29, 30=>30, 31=>31);



	
	//Added to update the profile completion percentage
	public function actionUpdateStatus()
	{
		try{
			$userId = Yii::app()->user->sub_id;	
			$profilePercentage = CommonUtils::calculateCriticalPercentage($userId);
			if(!is_numeric($profilePercentage))
			{
				$profilePercentage=0;
			}
			//$data = array('percentage' => $profilePercentage);
			echo $profilePercentage;
			Yii::app()->end();			
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	

    public function actionGetNextBlock() {
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
		
        Yii::import('application.components.profilevalidation.*');
        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        if (!$profile_verify) {
            $obj = new ValidateStudent();
            $obj->userId=Yii::app()->user->sub_id;
            $obj->validateProfileAfterSignup();

            $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        }
        $obj = new ValidateStudent();
        $obj->userId = $userId;
        $obj->validate_after_confirmation($profile_verify->profile_verification_score_id, $user);


        $time = time();
        $sql = "SELECT country_pref, course_pref, education_pref, education_pref_10,phone,pref_country_score,pref_dept_score,marks_100,marks_above_95,marks_diff,profile_pic,gender,dob,ethnicity,citizenship,currently_living_in,location,entrance_exam, appearance_year ,exam_score ,school_10, completion_year_10 ,school_12 ,  passout_12,about_me,$time FROM student_b2cform_lookup WHERE user_ref_id=".Yii::app()->user->sub_id;
        $result = Yii::app()->db->createCommand($sql)->queryAll();
       
        if($result == NULL) {
            $insertSql = "INSERT INTO student_b2cform_lookup (user_ref_id) VALUES ('".Yii::app()->user->sub_id."')";
            Yii::app()->db->createCommand($insertSql)->execute();
            $displayBlock = "country_pref";
        } else {
            foreach ($result[0] as $key=>$val) {
                if(($val == 0) && !in_array($key, array('marks_100', 'marks_above_95', 'marks_diff'))) {
                    $displayBlock = $key;
                    break;
                }
            }
        }
    
        if( $displayBlock == "country_pref" ) {
           // $sql = "SELECT country_ref_id,$time FROM student_preferred_country WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result =Yii::app()->db->createCommand($sql)->queryAll();
            //if(count($result) != 0 ) {
                //$displayCountryPrefBlock = true;
                $updateSql = "UPDATE student_b2cform_lookup SET country_pref=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "course_pref";
           // }
        }
        if($displayBlock == "course_pref") {
            //$sql = "SELECT *,$time FROM student_preferred_department WHERE user_ref_id=".Yii::app()->user->sub_id;
           // $result =Yii::app()->db->createCommand($sql)->queryAll();
            //if(count($result) != 0 ) {
                $updateSql = "UPDATE student_b2cform_lookup SET course_pref=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "education_pref";
           // }
        }

        if($displayBlock == "education_pref") {
           // $sql = "SELECT board_ref_id, overall_marks,$time FROM student_education WHERE class_level='12' AND user_ref_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryAll();
           // if($result[0]['board_ref_id']) {
                $updateSql = "UPDATE student_b2cform_lookup SET education_pref=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock= "education_pref_10";
           // }
        }

        if($displayBlock == "education_pref_10") {
           // $sql = "SELECT board_ref_id, overall_marks,$time FROM student_education WHERE class_level='10' AND user_ref_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryAll();
           // if($result[0]['board_ref_id']) {
                $updateSql = "UPDATE student_b2cform_lookup SET education_pref_10=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock= "phone";
           // }
        }

        if($displayBlock == "phone") {

           // $sql = "SELECT *,$time FROM student_contact_number WHERE user_ref_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryAll();
           // if(count($result) != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET phone=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "pref_country_score";
           // }

            /*
            $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>Yii::app()->user->sub_id));
            if (!$profile_verify->profile_verification_score_id) {
                Yii::import('application.components.profilevalidation.*');
                $obj = new ValidateStudent();
                $obj->userId=Yii::app()->user->sub_id;
                $obj->validateProfileAfterSignup();
            }*/
        }
        if($displayBlock == "pref_country_score") {
            //$sql = "SELECT pref_country_score,$time FROM profile_verification_score WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET pref_country_score=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "pref_dept_score";
            //}
        }
        if($displayBlock == "pref_dept_score") {
            //$sql = "SELECT pref_dept_score,$time FROM profile_verification_score WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET pref_dept_score=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "marks_100";
            //}
        }
        if($displayBlock == "marks_100") {
            //$sql = "SELECT marks_100,$time FROM profile_verification_score WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET marks_100=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "marks_above_95";
            //}
        }
        if($displayBlock == "marks_above_95") {
            //$sql = "SELECT marks_above_95,$time FROM profile_verification_score WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET marks_above_95=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "marks_diff";
            //}
        }
        if($displayBlock == "marks_diff") {
            //$sql = "SELECT marks_diff,$time FROM profile_verification_score WHERE user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET marks_diff=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "profile_pic";
            //}
        }
        if($displayBlock == "profile_pic") {
            //$this->userParams = array('uid' => Yii::app()->user->sub_id);
            //$sql = "SELECT user_photo,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
            //$result =Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != '') {
                //$displayCountryPrefBlock = true;
                $updateSql = "UPDATE student_b2cform_lookup SET profile_pic=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "gender";
            //}
        }
        if($displayBlock == "gender") {
            //$sql = "SELECT gender,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
           // if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET gender=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "dob";
            //}
        }
        if($displayBlock == "dob") {
            //$sql = "SELECT dob,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryScalar();
           // if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET dob=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "ethnicity";
            //}
        }
        if($displayBlock == "ethnicity") {
            //$sql = "SELECT ethnicity_ref_id,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET ethnicity=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "citizenship";
            //}
        }
        if($displayBlock == "citizenship") {
            $sql = "SELECT *,$time FROM student_citizenship WHERE user_ref_id=".Yii::app()->user->sub_id;
            $result = Yii::app()->db->createCommand($sql)->queryAll();
            if(count($result) != 0) {
                $updateSql = "UPDATE student_b2cform_lookup SET citizenship=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "currently_living_in";
            }
        }

        if($displayBlock == "currently_living_in") {
            //$sql = "SELECT country_ref_id,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET currently_living_in=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "location";
           // }
        }

        if($displayBlock == "location") {

            //$sql = "SELECT city_ref_id,post_code,$time FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryAll();
          // if( ($result[0]['city_ref_id'] != '') && ($result[0]['post_code'] != '')) {
                $updateSql = "UPDATE student_b2cform_lookup SET location=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "entrance_exam";
          //  }
        }



        if($displayBlock == "entrance_exam") {
            /*$sql = "SELECT * FROM user_entrance_exam WHERE user_ref_id=".Yii::app()->user->sub_id;
            $result = Yii::app()->db->createCommand($sql)->queryAll();
            if(count($result) != 0) { */
                $updateSql = "UPDATE student_b2cform_lookup SET entrance_exam=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "appearance_year";
            //}
        }

        if($displayBlock == "appearance_year") {
            /* $sql = "SELECT exam_year FROM user_entrance_exam WHERE user_ref_id=".Yii::app()->user->sub_id;
             $result = Yii::app()->db->createCommand($sql)->queryScalar();
             if( $result != '') { */
                 $updateSql = "UPDATE student_b2cform_lookup SET appearance_year=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                 Yii::app()->db->createCommand($updateSql)->execute();

                /*
                 $sql = "SELECT exam_status FROM user_entrance_exam WHERE user_ref_id=".Yii::app()->user->sub_id;
                 $res = Yii::app()->db->createCommand($sql)->queryScalar();
                // echo $res."#####";
                 if($res == 'Planned') { */
                     $updateSql = "UPDATE student_b2cform_lookup SET exam_score=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                     Yii::app()->db->createCommand($updateSql)->execute();
                     $displayBlock = "school_10";
               /*  } else {
                     $displayBlock = "exam_score";
                 }

             } */
        }

        if($displayBlock == "exam_score") {
          /*  $sql = "SELECT overall_marks FROM user_entrance_exam WHERE user_ref_id=".Yii::app()->user->sub_id;
            $result = Yii::app()->db->createCommand($sql)->queryScalar();
            if( $result != 0) { */
                $updateSql = "UPDATE student_b2cform_lookup SET exam_score=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "school_10";
            //}
        }

        if($displayBlock == "school_10") {
           // $sql = "SELECT school_name,$time FROM student_education WHERE class_level='10' AND user_ref_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
           //if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET school_10=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "completion_year_10";
           // }
        }

        if($displayBlock == "completion_year_10") {
           // $sql = "SELECT year, month,$time FROM student_education WHERE class_level='10' AND user_ref_id=".Yii::app()->user->sub_id;
          //  $result = Yii::app()->db->createCommand($sql)->queryAll();
          //  if( ($result[0]['year'] != '') && ($result[0]['month'] != '')) {
                $updateSql = "UPDATE student_b2cform_lookup SET completion_year_10=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "school_12";
          //  }
        }

        if($displayBlock == "school_12") {
           // $sql = "SELECT school_name,$time FROM student_education WHERE class_level='12' AND user_ref_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryScalar();
          //  if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET school_12=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "passout_12";
           // }
        }

        if($displayBlock == "passout_12") {
          //  $sql = "SELECT year, month,$time FROM student_education WHERE class_level='12' AND user_ref_id=".Yii::app()->user->sub_id;
           // $result = Yii::app()->db->createCommand($sql)->queryAll();
          //  if( ($result[0]['year'] != '') && ($result[0]['month'] != '')) {
                $updateSql = "UPDATE student_b2cform_lookup SET passout_12=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "about_me";
           // }
        }

        if($displayBlock == "about_me") {
            //$sql = "SELECT introduce_yourself FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
            //$result = Yii::app()->db->createCommand($sql)->queryScalar();
            //if( $result != '') {
                $updateSql = "UPDATE student_b2cform_lookup SET about_me=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
                Yii::app()->db->createCommand($updateSql)->execute();
                $displayBlock = "";
            //}

        }

        //$displayBlock="education_pref";
       // $displayBlock="marks_100";
        switch($displayBlock) {
            case 'country_pref' : $countriesList = TblCountryMaster::getUnivarietyCountries();
                $countries = CHtml::listData($countriesList,'country_id', 'country_name');
                $allCountryList = TblCountryMaster::getCountryList();
                $uniqueCountryList = array_diff($allCountryList, $countries);
                $countries['Others'] = $uniqueCountryList;

                $data = array();
                $data['ctryList'] = $countries;
                $data['model'] = new B2CDashboard('country_pref');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_country', $data, true);
                break;
            case 'education_pref':
                /*$cdbCriteria = new CDbCriteria();
                $cdbCriteria->select = 'DISTINCT t.board_id, t.board_desc';
                $cdbCriteria->order= 't.board_desc';
                $modelData = LookupBoard::model()->findAll($cdbCriteria);
                $boardList = CHtml::listData($modelData, 'board_id', 'board_desc'); */

                $boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
                $boardList12 = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');

                $data = array();
                $data['boardList'] = $boardList12;
                $data['model'] = new B2CDashboard('education_pref');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_education_pref', $data, true);
                break;
            case 'education_pref_10':
               /* $cdbCriteria = new CDbCriteria();
                $cdbCriteria->select = 'DISTINCT t.board_id, t.board_desc';
                $cdbCriteria->order= 't.board_desc';
                $modelData = LookupBoard::model()->findAll($cdbCriteria);
                $boardList = CHtml::listData($modelData, 'board_id', 'board_desc');
                */
                $boardLookup10 = LookupBoardEquivalent::GetSchoolBoardList('10');
                $boardList10 = CHtml::listData($boardLookup10, 'board_equivalent_id', 'board_desc');

                $data = array();
                $data['boardList'] = $boardList10;
                $data['model'] = new B2CDashboard('education_pref_10');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_education_pref_10', $data, true);
                break;
            case 'course_pref':
                $dept_list = LookupDepartment::getMainDepartmentList();
                $model = new B2CDashboard('course_pref');

                $data = array();
                $data['model'] = $model;
                $data['userId'] = Yii::app()->user->sub_id;
                $data['dept_list'] = $dept_list;
                echo $this->renderPartial('_course_pref', $data, true);
                break;
            case 'phone':
                $cdbCriteria = new CDbCriteria();
                $cdbCriteria->select = 't.phone_code, t.country_id , t.country_name';
                $cdbCriteria->order = 't.country_name';
                $modelData = TblCountryMaster::model()->findAll($cdbCriteria);
                $countries = array();
                foreach($modelData  as $model)
                {
                    $countries[$model['phone_code']."-".$model['country_id']] = $model['country_name']." (+".$model['phone_code'].")";
                }
                $data = array();
                $data['model'] = new B2CDashboard('phone');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['ctryList'] = $countries;
                echo $this->renderPartial('_phone', $data, true);
                break;
            case 'profile_pic':
                $data = array();
            	$this->userData = TblUserMaster::getUserDetails($userId);
        	$userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
                $data['model'] = new B2CDashboard('dob');
                $data['userId'] = Yii::app()->user->sub_id;
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                $data['userImage'] = $this->userImage;
                $data['isUploading'] = $this->isUploading;
                $data['isUserImageAvailable'] = $this->isUserImageAvailable;
                $data['imageUploadErrorMessage'] = $this->imageUploadErrorMessage;
                $data['userParams'] = $this->userParams;
                echo $this->renderPartial('_profile_pic', $data, true);
                break;
            case 'gender':
                $genderList = array('M'=>'Male', 'F'=>'Female');
                $data = array();
                $data['genderList'] = $genderList;
                $data['model'] = new B2CDashboard('gender');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_gender', $data, true);
                break;
            case 'school':
                break;
            case 'dob':
                $data = array();
                $data['model'] = new B2CDashboard('dob');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_dob', $data, true);
                break;

            case 'ethnicity':
                $data = array();
                $data['model'] = new B2CDashboard('ethnicity');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_ethnicity', $data, true);
                break;

            case 'citizenship':
                $data = array();
                $data['model'] = new B2CDashboard('citizenship');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_citizenship', $data, true);
                break;
            case 'currently_living_in':
                $data = array();
                $data['model'] = new B2CDashboard('currently_living_in');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_currently_living_in', $data, true);
                break;
            case 'location' :
                $sql = "SELECT country_ref_id FROM tbl_user_master WHERE user_id=".Yii::app()->user->sub_id;
                $ctryId = Yii::app()->db->createCommand($sql)->queryScalar();
                $data = array();
                $data['model'] = new B2CDashboard('location');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['countryId'] = $ctryId;
                echo $this->renderPartial('_location', $data, true);
                break;

            case 'entrance_exam' :
                $studentPreferredDepartmentIds = array();
                $userInfo = TblUserMaster::getUserDetails(Yii::app()->user->sub_id);
                $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
                if (count($studentPreferredDepartments) > 0) {
                    foreach ($studentPreferredDepartments as $deptPref) {
                        $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
                    }
                }
                $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails(Yii::app()->user->sub_id);
                if(count($preferredCountryListData) > 0) {
                    foreach ($preferredCountryListData as $key => $value) {
                        $studentPreferredCountryIds[] = $value->country_ref_id;
                    }
                }
                $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);
                $result = EntranceExam::getTestDetailsByCountryDepartmentArr($studentPreferredCountryIds, $studentPreferredDepartmentIds);
                foreach($result as $key=>$value){
                    $examlist[$value->entrance_id] = $value->entrance_short_name;
                }
                $data = array();
                $data['model'] = new B2CDashboard('entrance_exam');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['statusList'] = array('Planned'=>'Planned', 'Completed'=>'Completed');
                $data['examlist'] = $examlist;
                echo $this->renderPartial('_entrance_exam', $data, true);
                break;
            case 'appearance_year':
                $sql = "SELECT exam_status FROM user_entrance_exam WHERE user_ref_id=".Yii::app()->user->sub_id;
                $status = Yii::app()->db->createCommand($sql)->queryScalar();
                $data = array();
                $data['model'] = new B2CDashboard('appearance_year');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['status'] = $status;
                echo $this->renderPartial('_appearance_year', $data, true);
                break;
            case 'exam_score':
                $data = array();
                $data['model'] = new B2CDashboard('exam_score');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_exam_score', $data, true);
                break;
            case 'school_10':
                $data = array();
                $data['model'] = new B2CDashboard('school_10');
                $data['userId'] = Yii::app()->user->sub_id;
                $this->renderPartial('_school_10', $data, false,true);
                break;
            case 'completion_year_10':
                $data = array();
                $data['model'] = new B2CDashboard('completion_year_10');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_completion_year_10', $data, true);
                break;

            case 'school_12':
                $data = array();
                $data['model'] = new B2CDashboard('school_10');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_school_12', $data, true, true);
                break;
            case 'passout_12':
                $data = array();
                $data['model'] = new B2CDashboard('passout_12');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_passout_12', $data, true);
                break;

            case 'about_me':
                $data = array();
                $data['model'] = new B2CDashboard('about_me');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_about_me', $data, true);
                break;
            case 'marks_100':
                $data = array();
                $data['model'] = new B2CDashboard('marks_100');
                $data['userId'] = Yii::app()->user->sub_id;
                echo $this->renderPartial('_marks_100', $data, true);
                break;
            case 'pref_country_score':
                $data = array();
                $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $data['model'] = new B2CDashboard('countryMissing');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['user'] = $user;
                echo $this->renderPartial('_country_discrepancy', $data, true);
                break;
            case 'pref_dept_score':
                $data = array();
                $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $data['model'] = new B2CDashboard('majorMissing');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['user'] = $user;
                echo $this->renderPartial('_major_discrepancy', $data, true,true);
                break;
            case 'marks_100':
                $data = array();
                $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $data['model'] = new B2CDashboard('marks_100');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['user'] = $user;
                echo $this->renderPartial('_marks_100', $data, true,true);
                break;
            case 'marks_above_95':
                $data = array();
                $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $data['model'] = new B2CDashboard('marks_above_95');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['user'] = $user;
                echo $this->renderPartial('_marks_above_95', $data, true,true);
                break;
            case 'marks_diff':
                $data = array();
                $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $data['model'] = new B2CDashboard('marks_diff');
                $data['userId'] = Yii::app()->user->sub_id;
                $data['user'] = $user;
                echo $this->renderPartial('_marks_diff', $data, true,true);
                break;
        }


    }

    public function actionUpdateStudentMarks(){
        $userId = Yii::app()->request->getParam('userId');
        $type_10 = Yii::app()->request->getParam('type_10');
        $type_12 = Yii::app()->request->getParam('type_12');
        $marks_10 = Yii::app()->request->getParam('marks_10');
        $marks_12= Yii::app()->request->getParam('marks_12');
        $boardId12= Yii::app()->request->getParam('boardId12');
        $boardId10= Yii::app()->request->getParam('boardId10');

        $page = Yii::app()->request->getParam('page');

        $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'10'));
        if ($edu_det->student_education_id) {
            $criteria = new CDbCriteria;
            $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
            StudentGradeCount::model()->deleteAll($criteria);

            $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
        } else {
            $edu_obj = new StudentEducation();
            $edu_obj->user_ref_id = $userId;
            $edu_obj->class_level = '10';
            $edu_obj->added_on = date('Y-m-d H:i:s');
        }
        $edu_obj->board_ref_id = $boardId10;

        switch($type_10) {
            case 'grades':
                $edu_obj->overall_marks = NULL;
                break;
            case 'marks':
            case 'points':
            case 'marks-gpa':
                $edu_obj->overall_marks =$marks_10;
                break;
        }
        $edu_obj->save(false);


        if ($type_10 == 'grades') {
            $gradeArr = json_decode($marks_10,true);
            $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'10'));
            if ($edu_det_new->student_education_id) {
                if ($gradeArr['aa']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 1;$grade_model->grade_count = $gradeArr['aa'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
                if ($gradeArr['a']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 2;$grade_model->grade_count = $gradeArr['a'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['b']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 3;$grade_model->grade_count = $gradeArr['b'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['c']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 4;$grade_model->grade_count = $gradeArr['c'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['d']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 5;$grade_model->grade_count = $gradeArr['d'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
            }
        }


        $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
        if ($edu_det->student_education_id) {
            $criteria = new CDbCriteria;
            $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
            StudentGradeCount::model()->deleteAll($criteria);

            $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);

        } else {
            $edu_obj = new StudentEducation();
            $edu_obj->user_ref_id = $userId;
            $edu_obj->class_level = '12';
            $edu_obj->added_on = date('Y-m-d H:i:s');
        }
        $edu_obj->board_ref_id = $boardId12;

        switch($type_12) {
            case 'grades':
                $edu_obj->overall_marks = NULL;
                break;
            case 'marks':
            case 'points':
            case 'marks-gpa':
                $edu_obj->overall_marks =$marks_12;
                break;
        }
        $edu_obj->save(false);


        if ($type_12 == 'grades') {
            $gradeArr = json_decode($marks_12,true);
            $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
            if ($edu_det_new->student_education_id) {
                if ($gradeArr['aa']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 1;$grade_model->grade_count = $gradeArr['aa'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
                if ($gradeArr['a']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 2;$grade_model->grade_count = $gradeArr['a'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['b']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 3;$grade_model->grade_count = $gradeArr['b'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['c']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 4;$grade_model->grade_count = $gradeArr['c'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['d']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 5;$grade_model->grade_count = $gradeArr['d'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
            }
        }
        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        $profile_verify->marks_100 = $profile_verify->marks_above_95 = $profile_verify->marks_diff = 1;
        $profile_verify->marks_100_date = $profile_verify->marks_above_95_date = $profile_verify->marks_diff_date = date('Y-m-d H:i:s');
        $profile_verify->save(false);


    }

    // redo after checking
    public function actionUpdateValidMajors(){

        $userId = Yii::app()->request->getParam('userId');

        $dept1 = Yii::app()->request->getParam('dept1');
        $dept2 = Yii::app()->request->getParam('dept2');

        $sub_dept1 = Yii::app()->request->getParam('sub_dept1');
        $sub_dept2 = Yii::app()->request->getParam('sub_dept2');

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        StudentPreferredDepartment::model()->deleteAll($criteria);

        $obj = new StudentPreferredDepartment();
        $obj->{user_ref_id} = $userId;
        $obj->{main_dept_ref_id} = $dept1;
        $obj->{sub_dept_ref_id} = $sub_dept1;
        $obj->{preference_order} = 1;
        $obj->{course_ref_id} = null;
        $obj->save(false);

        $obj2 = new StudentPreferredDepartment();
        $obj2->{user_ref_id} = $userId;
        $obj2->{main_dept_ref_id} = $dept2;
        $obj2->{sub_dept_ref_id} = $sub_dept2;
        $obj2->{preference_order} = 2;
        $obj2->{course_ref_id} = null;

        $obj2->save(false);

        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        $profile_verify->user_ref_id = $userId;
        $profile_verify->pref_dept_score = 1;
        $profile_verify->pref_dept_score_date = date('Y-m-d H:i:s');
        $profile_verify->save(false);


    }
    public function actionUpdateValidCountries(){
        $ctry1 = Yii::app()->request->getParam('ctry1');
        $ctry2 = Yii::app()->request->getParam('ctry2');
        $ctry3 = Yii::app()->request->getParam('ctry3');
        $userId = Yii::app()->request->getParam('userId');

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        StudentPreferredCountry::model()->deleteAll($criteria);
        if ($ctry1) {
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} =$ctry1;
            $obj->{preference_order} = 1;
            $obj->save();
        }
        if ($ctry2) {
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} =$ctry2;
            $obj->{preference_order} = 2;
            $obj->save();
        }

        if ($ctry3) {
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} =$ctry3;
            $obj->{preference_order} = 3;
            $obj->save();
        }

        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        $profile_verify->user_ref_id = $userId;
        $profile_verify->pref_country_score = 1;
        $profile_verify->pref_country_score_date = date('Y-m-d H:i:s');
        $profile_verify->save(false);

    }

    public function actionGetCountry() {
        $userId = $_GET['uid'];
        $user = TblUserMaster::model()->findByPk($userId);
        $this->renderPartial('_countryInvalidAjax', array('user'=>$user,'userId'=>Yii::app()->user->sub_id), false, true);
    }

    public function actionChangeCountry() {

        if ($_GET['did'] && $_GET['pref'] && $_GET['uid']) {
           
            $userId = $_GET['uid'];

            $criteria = new CDbCriteria;
            $criteria->condition = "country_ref_id = '".$_GET['did']."' AND user_ref_id = ".$userId;
            StudentPreferredCountry::model()->deleteAll($criteria);

            $criteria = new CDbCriteria;
            $criteria->condition = "preference_order = '".$_GET['pref']."' AND user_ref_id = ".$userId;
            StudentPreferredCountry::model()->deleteAll($criteria);

            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} = $_GET['did'];
            $obj->{preference_order} = $_GET['pref'];
            $obj->save();
        }
    }

    public function actionUploadUserImage() {
        $userId = Yii::app()->user->sub_id;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
        $this->isUserImageAvailable = false;

        $path = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $valid_formats = array(".jpg", ".png", ".gif");
        if (isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST") {
            $name = $_FILES['photoimg']['name'];
            $size = $_FILES['photoimg']['size'];

            if (strlen($name)) {
                //list($txt, $ext) = strrchr($name, '.');//explode(".", $name);
                $ext = strrchr($name, '.');
                $ext = strtolower($ext);
                if (in_array($ext, $valid_formats)) {
                    if ($size < (1024 * 1024)) {
                        $actual_image_name = 'img_U_' . time() . $ext; //time() . substr(str_replace(" ", "_", $txt), 5) . "." . $ext;
                        $tmp = $_FILES['photoimg']['tmp_name'];
                        if (move_uploaded_file($tmp, $path . $actual_image_name)) {
                            $this->actionDeleteUserImage(false);
                            $this->isUserImageAvailable = true;
                            $this->userImage = $actual_image_name;

                            $studentModel = TblUserMaster::model()->findByPk($userId);
                            $studentModel->user_photo = $this->userImage;
                            $studentModel->save(false);

                            $imgPath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/' . $actual_image_name;
                            $imgPathThumb = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/thumb_90x90/' . $actual_image_name;
                            Yii::import('application.extensions.image.Image');
                            $image = new Image($imgPath); // Instantiate the library

                            list($width, $height) = getimagesize($imgPath);

                            $newWidth = 90;
                            $newHeight = 90;
                            if ($width > 90 || $height > 90) {
                                $image->resize($newWidth, $newHeight);
                            }
                            $image->save($imgPathThumb);
                            $criticalFields = array(
                                'picture' => 1,
                            );
                            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                        } else {
                            $this->isUploading = true;
                            $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Image upload failed</p></div></div>";
                        }
                    } else {
                        $this->isUploading = true;
                        $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Image file size max 1 MB</p></div></div>";
                    }
                } else {
                    $this->isUploading = true;
                    $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Invalid file format..</p></div></div>";
                }
            } else {
                $this->isUploading = true;
                $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Please select image..!</p></div></div>";
            }

            $this->userData = TblUserMaster::getUserDetails($userId);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($this->userData->user_photo != '') {
                if (file_exists($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = true;
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                } else {
                    $this->isUserImageAvailable = false;
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                }
            } else {
                $this->isUserImageAvailable = false;
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
            $this->renderPartial('_studentImage');
            exit;
        }
    }

    public function actionDeleteUserImage($useSubView = true) {
        $userId = Yii::app()->user->sub_id;
        $this->isUserImageAvailable = false;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');

        $this->userData = TblUserMaster::getUserDetails($userId);
        //$studentModel = TblUserMaster::model()->find()
        $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                if (unlink($userImagePath . $this->userData->user_photo)) {
                    @unlink($userImagePath.'thumb_90x90/' . $this->userData->user_photo);
                    $this->isUserImageAvailable = false;
                    $studentModel = TblUserMaster::model()->findByPk($userId);
                    $studentModel->setAttributes(array('user_photo' => ''));
                    $studentModel->save(false);
                    $criticalFields = array(
                        'picture' => 0,
                    );
                    TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                } else {
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                    $this->isUserImageAvailable = true;
                }
            }
        } else {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }
        if ($useSubView) {
            $this->renderPartial('_studentImage');
        }
    }

    public function actionUpdateCourseProfile() {

        $postData = array();
        $userId = Yii::app()->request->getParam('userId');
        $postData['dept_pref1'] = Yii::app()->request->getParam('dept1');
        $postData['dept_pref2'] =  Yii::app()->request->getParam('dept2');
        $postData['sub_dept_pref1'] = Yii::app()->request->getParam('sub_dept1');
        $postData['sub_dept_pref2'] = Yii::app()->request->getParam('sub_dept2');
        $postData['other_sub_dept_pref1'] = Yii::app()->request->getParam('course1');
        $postData['other_sub_dept_pref2'] = Yii::app()->request->getParam('course2');

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        StudentPreferredDepartment::model()->deleteAll($criteria);

        $dept = $sub_dept = $others_dept = 0;
        for ($i = 1; $i< 3; $i++) {
            $course_id = null;
            $save = true;
            if($postData['dept_pref'.$i]!= ""){
                if ($postData['other_sub_dept_pref'.$i] != "") {
                    $criteria = new CDbCriteria;
                    $criteria->select = 'course_id';
                    $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '0' ";
                    $data = Courses::model()->find($criteria);
                    if ($data) {
                        $course_id = $data->course_id;
                    } else {
                        $obj = new Courses();
                        $obj->course_name = $postData['other_sub_dept_pref'.$i];
                        $obj->main_dept_ref_id = $postData['dept_pref'.$i];
                        $obj->sub_dept_ref_id = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                        $obj->user_entered = '1';
                        $obj->added_on = date('Y-m-d H:i:s');
                        $obj->save(false);

                        $criteria->select = 'course_id';
                        $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '1' ";
                        $data = Courses::model()->find($criteria);
                        $course_id = $data->course_id;
                    }
                }

                if (($i == 2) && (($dept == $postData['dept_pref2']) && ($sub_dept == $postData['sub_dept_pref2']) && ($others_dept == $postData['other_sub_dept_pref2']))) {
                    $save = false;
                }
                if ($save == true) {
                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $userId;
                    $obj->{main_dept_ref_id} = $postData['dept_pref'.$i];
                    $obj->{sub_dept_ref_id} = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                    $obj->{preference_order} = $i;
                    $obj->{course_ref_id} = $course_id;
                    $obj->save(false);

                }

                if ($i == 1) {
                    $dept = $postData['dept_pref1'];
                    $sub_dept = $postData['sub_dept_pref1'];
                    $others_dept = $postData['other_sub_dept_pref1'];
                }
            }
        }

        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        $profile_verify->pref_dept = 1;
        $profile_verify->pref_dept_date = date('Y-m-d H:i:s');
			
        $conditions_obj = new Conditions();
        $conditions_obj->userId = $userId;
        $profile_verify->pref_dept_date = date('Y-m-d H:i:s');
        $profile_verify->pref_dept_score = $conditions_obj->validateDepartment();
        if ($profile_verify->pref_dept_score == 1) {
            $profile_verify->pref_dept_score_date = date('Y-m-d H:i:s');
        }

        $profile_verify->save(false);

    }

    public function actionSearch(){
        $res = array();
        if (isset($_GET['term'])) {
            $term = $_GET['term'];
            $criteria = new CDbCriteria;
            $criteria->select = '*';
            $criteria->condition = " course_name like '%$term%' AND user_entered = '0' ";
            $criteria->with = array('mainDeptRef'=>array('select'=>'mainDeptRef.department_name', 'joinType'=>'LEFT JOIN' ), 'subDeptRef'=>array('select'=>'subDeptRef.department_name', 'joinType'=>'LEFT JOIN'));
            $data = Courses::model()->findAll($criteria);

            foreach ($data as $result) {
                $res[] = array(
                    'id'=>$result->course_id,
                    'value'=>$result->course_name,
                    'dept_id'=>$result->main_dept_ref_id,
                    'dept_name'=>$result->mainDeptRef->department_name,
                    'sub_dept_id'=>$result->sub_dept_ref_id,
                    'sub_dept_name'=>$result->subDeptRef->department_name,
                );
            }
        }
        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function actionUpdatePhone(){
        $ctryCode = Yii::app()->request->getParam('ctryCode');
        $arr = explode("-",$ctryCode);

        $phone = Yii::app()->request->getParam('phone');
        $userId = Yii::app()->request->getParam('userId');

        $obj = new StudentContactNumber();
        $obj->{user_ref_id} = $userId;
        $obj->{contact_type_ref_id} = 1;
        $obj->{number} = $phone;
        $obj->{country_code} = $arr[0];
        $obj->{country_ref_id} = $arr[1];
        $obj->{is_primary} = 1;
        $obj->{added_on} = date('Y-m-d H:i:s');
        $obj->{added_by} = $userId;
        $obj->save();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET phone=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
		
    }

    public function actionUpdateAboutMe(){
        $userId = Yii::app()->request->getParam('userId');
        $about_me = Yii::app()->request->getParam('about_me');

        $tumObj = TblUserMaster::model()->findByAttributes(array('user_id'=>$userId));
        $tumObj->{introduce_yourself} = $about_me;
        $tumObj->save();
    }

    public function actionUpdateCompletion10() {
        $year = Yii::app()->request->getParam('year');
        $month = Yii::app()->request->getParam('month');
        $userId = Yii::app()->request->getParam('userId');

        $entranceExam = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'10'));
        $entranceExam->{year}=$year;
        $entranceExam->{month}=$month;
        $entranceExam->save();

    }
    public function actionUpdateSchoolName10() {
        $schoolName = Yii::app()->request->getParam('schoolName');
        $userId = Yii::app()->request->getParam('userId');

        $entranceExam = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'10'));
        $entranceExam->{school_name}=$schoolName;
        $entranceExam->save();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET school_name=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();

    }

    public function actionUpdateSchoolName12() {
        $schoolName = Yii::app()->request->getParam('schoolName');
        $userId = Yii::app()->request->getParam('userId');

        $entranceExam = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
        $entranceExam->{school_name}=$schoolName;
        $entranceExam->save();
		
	

    }

    public function actionUpdateCompletion12() {
        $year = Yii::app()->request->getParam('year');
        $month = Yii::app()->request->getParam('month');
        $userId = Yii::app()->request->getParam('userId');

        $entranceExam = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
        $entranceExam->{year}=$year;
        $entranceExam->{month}=$month;
        $entranceExam->save();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET completion_year=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
    }


    public function actionUpdateExamScore() {
        $score = Yii::app()->request->getParam('score');
        $userId = Yii::app()->request->getParam('userId');
        $entranceExam = UserEntranceExam::model()->findByAttributes(array('user_ref_id'=>$userId));
        $entranceExam->{overall_marks}=$score;
        $entranceExam->save();
    }

    public function actionUpdateAppearanceYear() {
        $year = Yii::app()->request->getParam('year');
        $userId = Yii::app()->request->getParam('userId');
        $entranceExam = UserEntranceExam::model()->findByAttributes(array('user_ref_id'=>$userId));
        $entranceExam->{exam_year}=$year;
        $entranceExam->save();

    }

    public function actionUpdateEntranceExam() {
        $exam = Yii::app()->request->getParam('name');
        $status = Yii::app()->request->getParam('status');
        $userId = Yii::app()->request->getParam('userId');

        $obj = new UserEntranceExam();
        $obj->{user_ref_id} = $userId;
        $obj->{entrance_exam_ref_id} = $exam;
        $obj->{exam_status} = $status;
        $obj->{added_on} = date('Y-m-d H:i:s');
        $obj->{added_by} = $userId;
        $obj->{overall_marks} = 0;
        $obj->save();

    }

    public function actionUpdateLocation() {
        $state = Yii::app()->request->getParam('state');
        $city = Yii::app()->request->getParam('city');
        $zipcode = Yii::app()->request->getParam('zipcode');
        $userId = Yii::app()->request->getParam('userId');

        if($state != '') {
            $sql = "UPDATE tbl_user_master SET state_ref_id='".$state."' WHERE user_id=".$userId;
            Yii::app()->db->createCommand($sql)->execute();
        }

        $sql = "UPDATE tbl_user_master SET city_ref_id='".$city."', post_code ='".$zipcode."' WHERE user_id=".$userId;
        Yii::app()->db->createCommand($sql)->execute();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET likely_start_period=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
		
    }

    public function actionUpdateDOB(){
        $date = Yii::app()->request->getParam('date');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $userId = Yii::app()->request->getParam('userId');

        $dob = $year."-".$month."-".$date;
        $sql = "UPDATE tbl_user_master SET dob='".$dob."' WHERE user_id=".$userId;
        Yii::app()->db->createCommand($sql)->execute();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET dob=1,likely_start_period=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
					
    }


    public function actionUpdateGender(){
        $gender = Yii::app()->request->getParam('gdr');
        $userId = Yii::app()->request->getParam('userId');

        $sql = "UPDATE tbl_user_master SET gender='".$gender."' WHERE user_id=".$userId;
        Yii::app()->db->createCommand($sql)->execute();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET gender=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
    }

    public function actionUpdateCurrentlyLivingIn(){
        $gender = Yii::app()->request->getParam('ctry1');
        $userId = Yii::app()->request->getParam('userId');

        $sql = "UPDATE tbl_user_master SET country_ref_id='".$gender."' WHERE user_id=".$userId;
        Yii::app()->db->createCommand($sql)->execute();
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET country=1,likely_start_period=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
		
    }

    public function actionUpdateEthnicity(){
        $gender = Yii::app()->request->getParam('ethnicity');
        $userId = Yii::app()->request->getParam('userId');

        /*echo $gender;
        echo $userId;exit;*/

        $sql = "UPDATE tbl_user_master SET ethnicity_ref_id='".$gender."' WHERE user_id=".$userId;
        Yii::app()->db->createCommand($sql)->execute();
		
		
    }

    public function actionIndex() {

        Yii::app()->theme = 'new_grid_theme';
        //$this->layout = "//layouts/new_grid_inner";
        $this->layout = "//layouts/new_grid_signup";

        $this->render("index");
    }
	
	//To update the stats section on shortlist/remove from the dashboard.s
	public function actionschstats()
	{
		try{
			if(isset($_POST['type_val'])){
				$value=$_POST['type_val'];
			}
			else $value=0;
			$userId=Yii::app()->user->sub_id;
			$Shortlistdata=0;
			if($value==1) { //colleges				
				$testtSql = "SELECT count(*) FROM student_shortlist_university WHERE shortlist_status != 'Reject' AND user_ref_id=".$userId;
			}
			else if($value==2) { //scholorship				
				$testtSql = "SELECT count(*) FROM user_scholarship WHERE user_ref_id=".$userId;				
			}
			else if($value==3) //tests
			{				
				$testtSql = "SELECT count(*) FROM user_entrance_exam WHERE  user_ref_id=".$userId." AND (exam_status='Planned' OR exam_status=' ') AND shortlist_status='1' ";
				//$testtSql = "SELECT count(*) FROM user_entrance_exam WHERE  user_ref_id=".$userId." AND (exam_status='Planned' OR exam_status=' ')";
			}
			$Shortlistdata = Yii::app()->db->createCommand($testtSql)->queryScalar();
			if(is_numeric($Shortlistdata))
			{
				echo $Shortlistdata;
			}
			else echo "0";
			exit;
		}
		catch(Exception $ex){
			echo $ex;
		}
	}
	
	//To know whether profile is validated or not.
	public function valid_profile($user_id)
	{
		try{
			$valid_info=0;
			/*$valid_det=Yii::app()->db->createCommand()
				->select('lm.is_email_confirmed,lm.is_class_status_confirmed,lm.is_preference_confirmed')
				->from('login_master lm')
				->join('tbl_user_master um','um.login_ref_id=lm.login_id')
				->where('um.user_id=:id',array(':id'=>$user_id))
				->queryRow();
			*/
			$prof_validation_score=Yii::app()->db->createCommand()
				->select('*')
				->from('profile_verification_score')				
				->where('user_ref_id=:id',array(':id'=>$user_id))
				->queryRow();
				
			if(!empty($prof_validation_score))
			{
				$temp_data=count(array_filter($prof_validation_score));
				$score_data=count($prof_validation_score);
				//it will check the 7 conditions are 1. if yes then dashboard without validate now button. else confirmation page.
				if($prof_validation_score['passout_year']==1 && $prof_validation_score['board_10']==1 && $prof_validation_score['board_12']==1 && $prof_validation_score['marks_10']==1 && $prof_validation_score['marks_12']==1 && $prof_validation_score['pref_country']==1 && $prof_validation_score['pref_dept']==1) {
					if($temp_data== $score_data) {
						$valid_info=0;
					}
					else $valid_info=2; //It will display dashboard with validate Now.
				}
				else {
					$valid_info=1;
				}				
				//it will check whether 16 conditions are 1. if yes redirects to dashboard with out validate now button.
				/*if($temp_data== $score_data){
					$valid_info=0;
				}				
							
				else $valid_info=1;*/
			}
			else $valid_info=1;			
			return $valid_info;
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
	
	public function getDates($type = 'all', $id = false, $month = false, $year = false) {
        $return = array();        
        unset($dates);
        Yii::import('application.components.dates.*');

        $dates_obj = new DatesHelper();
        $dates_obj->userId = Yii::app()->user->sub_id;

        $start_date = '2011-01-01 00:00:00';

        $time = time()+(5*365*24*3600);
        $end_date = date('Y-m', $time).'-'.date('t', $time).' 23:59:59';

        if ($type == 'all') {
            $dates = $dates_obj->getDates($start_date, $end_date);
        } elseif ($type == 'college') {
            $dates = $dates_obj->collegeDates($start_date, $end_date, $id);
        } elseif ($type == 'test') {
            $dates = $dates_obj->testDates($start_date, $end_date, $id);
        } elseif ($type == 'event') {
            $dates = $dates_obj->eventDates($start_date, $end_date, $id);
        }

        if ($month != false && $year != false) {
            $current_year = $year;
            $current_month = $month;
        } else {
            $current_year = date('Y');
            $current_month = date('n');
        }

        $current_month_dates = $dates[$current_year][$current_month];
       // ksort($current_month_dates);
        $return['current_month_dates'] = $current_month_dates;

        $data = array();
        foreach ($dates as $year=>$year_dates) {
            foreach ($year_dates as $month=>$month_dates) {
                foreach ($month_dates as $day=>$day_dates) {
                    foreach($day_dates as $key=>$dates) {
                        foreach ($dates as $date) {
                            if ($key == 'test') {
                                $test_det = EntranceExam::model()->findByPk($date['entrance_exam_ref_id']);
                                if ($test_det) {
                                    $data[$year][$month][$day] .= '<b>'.$test_det->entrance_full_name.' - </b>'.str_replace("'", "`", $date['label'])."<br/>";
                                } unset($test_det);
                            } elseif ($key == 'college') {
                                $uni_det = TblUniversityMaster::model()->findByPk($date['uni_ref_id']);
                                if ($uni_det) {
                                    $data[$year][$month][$day] .= '<b>'.$uni_det->uni_name.' - </b>'.str_replace("'", "`", $date['date_description'])."<br/>";
                                }unset($uni_det);
                            } else {
                                $data[$year][$month][$day] .= '<b>Webinar:  </b> '.str_replace("'", "`", $date['event_title'])."<br/>";
                            }
                        }
                    }
                    $cnt = 0;
                    $cnt = strlen($data[$year][$month][$day]) - 5;
                    $data[$year][$month][$day] = substr($data[$year][$month][$day], 0, $cnt);
                }
            }
        }
        unset($dates);

        $final_data = array();
        foreach ($data as $year=>$year_dates) {
            foreach ($year_dates as $month=>$month_dates) {
                foreach ($month_dates as $day=>$day_dates) {
                    $key =  $this->dates_val[$month].'-'.$this->dates_val[$day].'-'.$year;
                    $final_data[$key] = $day_dates;
                }
            }
        }
        $return['final_data'] = $final_data;
        return $return;
    }
	
	

    public function actionGetOverallAndSubjects() {
        $formName = 'B2CDashboard';

        $classLevel = Yii::app()->request->getParam('class_level');
        $boardId = Yii::app()->request->getParam('boardId', 0);

        $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $boardId);
        $overallMax = $boardDetails['overall_max'];
        $overallType = strtolower($boardDetails['overall_type']);

        $content = '<input type="hidden" id="'.$formName.'_overall_type" name="'.$formName.'[overall_type]" value="' . $overallType . '"><input type="hidden" id="'.$formName.'_overall_max" name="'.$formName.'[overall_max]" value="' . $boardDetails['overall_max'] . '" >';

        switch ($boardDetails['overall_type']) {
            case 'Marks-GPA':
            {
                $overAll = CHtml::textField($formName.'[overall_marks_gpa]', '', array('id' =>$formName.'_overall_marks_gpa', 'maxlength' => 3, 'placeholder' => 'Enter Overall Marks or GPA', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="'.$formName.'_overall_marks_gpa_em_" class="errorMessage popup"></div>';

                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_4">
                    Overall Marks or GPA
                </div>
                <div class="left grid_4 relative">
                '.$overAll.'
                 </div>
                </div>';
                break;

            }
            case 'Grades':
            {
                $gradeList = range(1, $overallMax);
                $gradeList = array_combine($gradeList, $gradeList);
                $gradeList[0] = '--';
                ksort($gradeList);

                    $overAll = '<div class="left relative">A* '.CHtml::dropDownList($formName.'[overall_grade_aa]', '', $gradeList, array( 'rel' => $formName.'[overall_grade_aa]', 'id' => $formName.'_overall_grade_aa', 'class'=>'grid_1'));
                    $overAll .= '<div style="display:none; ;" id="'.$formName.'_overall_grade_aa_em_" class="errorMessage popup"></div>'.'</div>';
                    $overAll .= '<div class="left">A '.CHtml::dropDownList($formName.'[overall_grade_a]', '', $gradeList, array( 'rel' => $formName.'[overall_grade_a]', 'id' => $formName.'_overall_grade_a', 'class'=>'grid_1')).'</div>';

                    $overAll .= '<div class="left">B '.CHtml::dropDownList($formName.'[overall_grade_b]', '', $gradeList, array( 'rel' => $formName.'[overall_grade_b]', 'id' => $formName.'_overall_grade_b', 'class'=>'grid_1')).'</div>';

                    $overAll .= '<div class="left">C '.CHtml::dropDownList($formName.'[overall_grade_c]', '', $gradeList, array( 'rel' => $formName.'[overall_grade_c]', 'id' => $formName.'_overall_grade_c', 'class'=>'grid_1')).'</div>';
                    $overAll .= '<div class="left">D '.CHtml::dropDownList($formName.'[overall_grade_d]', '', $gradeList, array( 'rel' => $formName.'[overall_grade_d]', 'id' => $formName.'_overall_grade_d', 'class'=>'grid_1')).'</div>';
                    $html = '<div class="row visible clearfix gutter_vertical">
                    <div class="left grid_4">
                        Overall Grades
                    </div>'.$overAll.'
            </div>';

                break;
            }
            case 'Marks': {
                $overAll = CHtml::textField($formName.'[overall_marks]', '', array('id' => $formName.'_overall_' . $overallType , 'maxlength' => 3, 'placeholder' => 'Enter Overall Marks', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="'.$formName.'_overall_marks_em_" class="errorMessage popup"></div>';

                    $html = '<div class="row visible clearfix gutter_vertical">
                    <div class="left grid_4">
                        Overall Marks
                    </div>
                    <div class="left grid_4 relative">
                    '.$overAll.'
                </div>
            </div>';
                break;
            }
            case 'Points':
            {
                $pointsList = range(1, $overallMax);
                $pointsList = array_combine($pointsList, $pointsList);
                arsort($pointsList);

                $overAll = CHtml::dropDownList($formName.'[overall_points]', '', $pointsList, array('empty' => 'Points', 'id' => $formName.'_overall_'.$overallType, 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="'.$formName.'_overall_'.$overallType.'_em_" class="errorMessage popup"></div>';

                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_4">
                    Overall Points
                </div>
                <div class="left grid_4 relative">
                '.$overAll.'
                </div>
                </div>';

                break;
            }
        }
        echo $content.$html;
    }
    public function actionUpdateBoardData() {
        $boardId = Yii::app()->request->getParam('boardId');
        $class_level = Yii::app()->request->getParam('class_level');
        $userId = Yii::app()->request->getParam('userId');
        $overall_marks = Yii::app()->request->getParam('overall_marks');
        $educationType = Yii::app()->request->getParam('educationType');

        $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>$class_level));
        if ($edu_det->student_education_id) {
            $criteria = new CDbCriteria;
            $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
            StudentGradeCount::model()->deleteAll($criteria);
            $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
        } else {
            $edu_obj = new StudentEducation();
            $edu_obj->user_ref_id=$userId;
            $edu_obj->class_level=$class_level;
            $edu_obj->added_on=date('Y-m-d H:i:s');
        }
        $edu_obj->board_ref_id = $boardId;
        switch($educationType) {
            case 'grades':
                $edu_obj->overall_marks = NULL;
                break;
            case 'marks':
            case 'points':
            case 'marks-gpa':
                $edu_obj->overall_marks =$overall_marks;
                break;
        }
        $edu_obj->save(false);
        if ($educationType == 'grades') {
            $gradeArr = json_decode($overall_marks,true);
            $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>$class_level));
            if ($edu_det_new->student_education_id) {
                if ($gradeArr['aa']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 1;$grade_model->grade_count = $gradeArr['aa'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
                if ($gradeArr['a']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 2;$grade_model->grade_count = $gradeArr['a'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['b']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 3;$grade_model->grade_count = $gradeArr['b'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['c']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 4;$grade_model->grade_count = $gradeArr['c'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }if ($gradeArr['d']) {
                    $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                    $grade_model->grade_ref_id = 5;$grade_model->grade_count = $gradeArr['d'];
                    $grade_model->added_on = date('Y-m-d H:i:s');
                    $grade_model->save(false);
                }
            }
        }
        if($class_level == "12") {
            $updateSql = "UPDATE student_b2cform_lookup SET education_pref=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
            Yii::app()->db->createCommand($updateSql)->execute();
        } else {
            $updateSql = "UPDATE student_b2cform_lookup SET education_pref_10=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
            Yii::app()->db->createCommand($updateSql)->execute();
        }
        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        if($class_level == "12") {
            $profile_verify->marks_12 = $profile_verify->board_12 = 1;
            $profile_verify->board_12_date = $profile_verify->marks_12_date = date('Y-m-d H:i:s');
        } else {
            $profile_verify->marks_10 = $profile_verify->board_10 = 1;
            $profile_verify->board_10_date = $profile_verify->marks_10_date = date('Y-m-d H:i:s');
        }
        if (($profile_verify->marks_100 != 1) && ($profile_verify->marks_above_95 != 1) && ($profile_verify->marks_diff != 1) && ($profile_verify->marks_10 == 1) && ($profile_verify->board_10 == 1) && ($profile_verify->marks_12 == 1) && ($profile_verify->board_12 == 1)) {
            Yii::import('application.components.profilevalidation.*');
            $marks_obj = new ValidateMarks();
            $marks_obj->userId = $userId;
            $profile_verify->marks_100 = $marks_obj->ValidateMarks('equals100');
            if ($profile_verify->marks_100 == 1) {
                $profile_verify->marks_100_date = date('Y-m-d H:i:s');
            }
            $profile_verify->marks_above_95 = $marks_obj->ValidateMarks('above95');
            if ($profile_verify->marks_above_95 == 1) {
                $profile_verify->marks_above_95_date = date('Y-m-d H:i:s');
            }
            $profile_verify->marks_diff = $marks_obj->ValidateMarks('diff');
            if ($profile_verify->marks_diff == 1) {
                $profile_verify->marks_diff_date = date('Y-m-d H:i:s');
            }
        }
        $profile_verify->save(false);
        if ($class_level == 12) {
            Yii::import('application.components.profilevalidation.*');
            $obj = new StudentPassoutYear();
            $obj->userId = $userId;
            $obj->recalculateStudentPassoutYear();
        }
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET board=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
		
    }
    public function actionUpdateCitizenship() {
        $ctry1 = Yii::app()->request->getParam('ctry1');
        $ctry2 = Yii::app()->request->getParam('ctry2');
        $userId = Yii::app()->request->getParam('userId');
        if($ctry1 != '') {
            $obj = new StudentCitizenship();
            $obj->{user_ref_id} = $userId;
            $obj->{citizenship_ref_id} = $ctry1;
            $obj->{added_on} = date('Y-m-d H:i:s');
            $obj->save();
        }
        if($ctry2 != '') {
            $obj = new StudentCitizenship();
            $obj->{user_ref_id} = $userId;
            $obj->{citizenship_ref_id} = $ctry2;
            $obj->{added_on} = date('Y-m-d H:i:s');
            $obj->save();
        }
		
		//Updating in tbl_user_prof_critical_completion added on 11th Aug 2014.
		$sql1 = "UPDATE tbl_user_prof_critical_completion SET citizenship=1 WHERE user_ref_id=".$userId;
        Yii::app()->db->createCommand($sql1)->execute();
		
    }
    public function actionUpdateCountryProfile() {
        $ctry1 = Yii::app()->request->getParam('ctry1');
        $ctry2 = Yii::app()->request->getParam('ctry2');
        $userId = Yii::app()->request->getParam('userId');
        if($ctry1 != '') {
            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            $criteria->condition .= " AND preference_order = 1";
            StudentPreferredCountry::model()->deleteAll($criteria);
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} = $ctry1;
            $obj->{preference_order} = 1;
            $obj->{added_on} = date('Y-m-d H:i:s');
            $obj->save();
        }
        if($ctry2 != '') {
            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            $criteria->condition .= " AND preference_order = 2";
            StudentPreferredCountry::model()->deleteAll($criteria);
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $userId;
            $obj->{country_ref_id} = $ctry2;
            if($ctry1 == '')
                $obj->{preference_order} = 1;
            else
                $obj->{preference_order} = 2;
            $obj->{added_on} = date('Y-m-d H:i:s');
            $obj->save();
        }
        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
        if (!$profile_verify->pref_country_score) {
            $profile_verify->pref_country = 1;
            $profile_verify->pref_country_date = date('Y-m-d H:i:s');
            $country_obj = new ValidateCountry();
            $country_obj->userId = $userId;
            $profile_verify->pref_country_score = $country_obj->validateCountryB2C();
            if ($profile_verify->pref_country_score == 1) {
                $profile_verify->pref_country_score_date = date('Y-m-d H:i:s');
            }
            $profile_verify->save(false);
        }
        $updateSql = "UPDATE student_b2cform_lookup SET country_pref=1 WHERE user_ref_id=".Yii::app()->user->sub_id;
        Yii::app()->db->createCommand($updateSql)->execute();
    }


    public function actionMilestoneBlock() {
        $userId = Yii::app()->user->sub_id;
        $userData = TblUserMaster::getUserDetails($userId);
        $passoutYear = $userData->passout_year;
        $boardId = $userData->present_board_ref_id;
        $confirmedMilestoneDetails = UserMilestone::getUserConfirmedMilestoneDetails($userId);
        foreach ($confirmedMilestoneDetails as $confirmedMilestone) {
            $arr = array('css' => 'green-bg', 'text' => 'Completed on ' . date("F d, Y", strtotime($confirmedMilestone->added_on)));
            $milestoneArr["m" . $confirmedMilestone->milestone_id] = $arr;
        }
        $siMilestoneDetails = TblSiStudents::getStudentSiMilestoneDetail($userId, $boardId, $passoutYear);

        if ($siMilestoneDetails) {
            for ($i = 1; $i <= 6; $i++) {
                $milestonedate = '';
                if (!is_array($milestoneArr["m" . $i])) {
                    $milestonedate = $siMilestoneDetails["milestone" . $i . "_date"];
                    if ($milestonedate) {
                        if (strtotime(date("Y-m-d")) <= strtotime($milestonedate)) {
                            $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'Due on ' . date("F d, Y", strtotime($milestonedate)));
                        } else { // student missed deadline
                            $milestoneArr["m" . $i] = array('css' => 'red-bg', 'text' => 'Due on ' . date("F d, Y", strtotime($milestonedate)));
                        }
                    } else {
                        $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'No date decided yet');
                    }
                }
            }
        } else {
            for ($i = 1; $i <= 6; $i++) {
                if (!is_array($milestoneArr["m" . $i])) {
                    $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'No date decided yet');
                }
            }
        }
        echo json_encode($milestoneArr);
    }

    public function actionTrackVideoClick() {
        UnivarietyStudentVideoTrack::trackVideoClick();
    }
}
