<?php

/*
 * sign-up controller for student
 * 
 */

class RegistrationController extends Controller {

    public $layout = "//layouts/partnership";

    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'dynamicpassoutyear', 'getboardlist'),
                'users' => array('*'),
            //'expression' => 'Yii::app()->user->isAdmin()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actions() {
        return array(
            // captcha action renders the CAPTCHA image displayed on the registration page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
                'minLength'=>'5',
                'maxLength'=>'5',
                'testLimit'=>'1',
                'transparent'=>true,
            ),
        );
    }

    public function actionIndex() {
        
        if(Yii::app()->session->itemAt('sUserUnivariety')!='' && Yii::app()->session->itemAt('sInstituteUnivariety')==''){
            $this->redirect(Yii::app()->params['cbasepath'].'/'.Yii::app()->params['userDir'].'/dashboard.php');
        }
        $yearList = array();
        $studentSignupModel = new StudentSignup;
        $this->performAjaxValidation($studentSignupModel);
        //$a = $studentSignupModel->user_login('rahultest11@test.com','admin123');// print_r($_SESSION);die;//$userLink=$studentSignupModel->redirect_url(3409, 1);
        // $redirectUrl =  Yii::app()->params['cbasepath'].Yii::app()->createUrl("profile/country-preference");
        //        $this->redirect($redirectUrl);
        $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
        $studentSignupModel->set_session("unique_id", $uniqueId);
        $emailHash = '';
        $instId = '';
        $emailHash = Yii::app()->request->getParam('hashkey');
        if (Yii::app()->session->itemAt('sInstituteUnivariety') != '' && $emailHash != '' || $emailHash !='') {
            $instId = $studentSignupModel->unserializeSession('sInstituteUnivariety', 'inst_id');
            $partnerStudentData = $studentSignupModel->getStudentDetailOfSI($instId, $emailHash);
            $postData['present_school'] = $partnerStudentData['present_school'];
            $postData['present_class'] = $partnerStudentData['present_class'];
            if(Yii::app()->session->itemAt('sInstituteUnivariety') !=''){
                $totalSiStudentsCount = $studentSignupModel->getLimitCountOfCSS($instId);
            }
        }
        $schoolLookup = new LookupSchool;
        $boardlookup = new LookupBoard;
        $schoolList = CHtml::listData($schoolLookup->findAll(array('condition' => 'user_entered=false')), 'school_id', 'school_name');
        $id = 0;
        foreach ($schoolList as $key => $val) {
            $value[$id]['id'] = $key;
            $value[$id]['value'] = $val;
            $id++;
        }
        $schoolList = $value;
        $boardList = CHtml::listData($boardlookup->findAll(), 'board_id', 'board_desc');
        $subDomainSlugName = CommonUtils::getSubdomain();
        if($subDomainSlugName !=''){
           $getSchoolDetail = $studentSignupModel->getSchoolNameBySubdomain($subDomainSlugName);
           $partnerStudentData['present_school'] = $getSchoolDetail->school_name;
           $partnerStudentData['school_id'] = $getSchoolDetail->school_id;
           $boardList = CHtml::listData($studentSignupModel->getBoardListBySchoolName($getSchoolDetail->school_name, $getSchoolDetail->school_id), 'board_id', 'board_desc');
        }
        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            // validates user input and redirect to previous page if validation failed.
            if ($studentSignupModel->validate()) {
                $userRoleId = $studentSignupModel->getUserRefId();
                $userSchoolRefId = $studentSignupModel->getSchoolRefId($postData['present_school'], $postData['presentSchoolId']);
                if ($userSchoolRefId == '') {
                    $schoolLookupData = array('school_name' => $postData['present_school'], 'user_entered' => true, 'added_on' => date('Y-m-d H:i:s'));
                    $schoolLookup->attributes = $schoolLookupData;
                    $schoolLookup->save();
                    $userSchoolRefId = $schoollookup->school_id;
                    $userMembershipRefId = $studentSignupModel->getMembershipId('Guest');
                } else {
                    $userMembershipRefId = $studentSignupModel->getMembershipId('SI Student');
                }
                $loginMasterData = array('username' => $postData['username'], 'pass_word' => $postData['pass_word'], 'user_type_ref_id' => $userRoleId['user_type_id'], 'is_active' => true, 'added_on' => date('Y-m-d H:i:s'));
                $loginMasterModel = new LoginMaster;
                // collects user input data
                $loginMasterModel->attributes = $loginMasterData;
                $loginMasterModel->save();
                $userMasterModel = new TblUserMaster;
                $login_ref_id = $loginMasterModel->login_id;
                $presentClass = substr($postData['present_class'], 0, $postData['present_class'] == '9p' ? 1 : 2);
                $presentClassStatus = substr($postData['present_class'], -1, 1);
                if ($presentClassStatus == 'p') {
                    $presentClassStatus = 'Pursuing';
                } else {
                    $presentClassStatus = 'Complete';
                }
                if(Yii::app()->session->itemAt('sInstituteUnivariety')!=''){
                    $userUNO	= $studentSignupModel->generateUNO($postData['country_code'], $instId);
                }else{
                    $userUNO = $studentSignupModel->generateUserUNO($postData['country_code']);
                }
                $userMasterData = array('login_ref_id' => $login_ref_id, 'membership_ref_id' => $userMembershipRefId['membership_id'], 'uno' => $userUNO, 'first_name' => $postData['first_name'], 'last_name' => $postData['last_name'],
                    'present_class' => $presentClass, 'class_status' => $presentClassStatus, 'present_board_ref_id' => $postData['present_board_ref_id'], 'present_school' => $postData['present_school'],
                    'school_ref_id' => $userSchoolRefId, 'passout_year' => $postData['passout_year'], 'passout_month' => $postData['passout_month'], 'gender' => $postData['gender'], 'is_newsletter_subscribe' => $postData['newsletter']);
                $userMasterModel->attributes = $userMasterData;

                $userMasterModel->save();
                $userId = $userMasterModel->user_id;
                if(!isset($_SESSION['sInstituteUnivariety']) || $emailHash ==''){
                    $instId = $studentSignupModel->getInstIdBySachoolName($postData['present_school'],$postData['present_school_id']);
                }
                
                $studentSignupModel->setRbacAssignment('Student', $login_ref_id);
                $studentSignupModel->setSiStudents($userId, $instId);
                $studentSignupModel->setEmailAlias($login_ref_id,$postData['username']);
                $emailExistsinMasterList = !empty($postData['emailExistsinMasterList'])?$postData['emailExistsinMasterList']:'';
                if(($emailHash != '') || (!empty($emailExistsinMasterList) && ($emailExistsinMasterList == 'yes')) || (count($partnerStudentData) > 0)){
                    $studentSignupModel->updateStudentUploadMatser($userId,$postData['username']);
                }
                if(isset($_SESSION['sPartnersSlug'])){
                    $hasCSSAccess = $studentSignupModel->unserializeSession('sPartnersSlug', 'hasCSSAccess');
                }
                
                $userProfileUpdate = new TblUserProfCriticalCompletion;
                if ($postData['first_name'] != '' && $postData['last_name'] != '') {
                    $isName = 1;
                }
                if ($postData['gender'] != '') {
                    $isGender = 1;
                }

                $userProfileUpdate->attributes = array('user_ref_id' => $userId, 'name' => $isName, 'gender' => $isGender, 'edu_study_level' => 1);
                $userProfileUpdate->save();
                $pClass = '';
                if ($presentClass == 9) {
                    $pClass = 10;
                } else {
                    $pClass = $presentClass;
                }
                $boardRefId = $studentSignupModel->getBoardEquivalentId($pClass, $postData['board_equivalent_id']);
                if ($boardRefId == 0) {
                    $board_ref_id = 'NULL';
                } else {
                    $board_ref_id = $boardRefId;
                }
                $studentEducationModel = new StudentEducation;
                if ($presentClassStatus == 'Complete') {
                    $presentClassStatus = 'Completed';
                }
                if ($presentClass == 12) {
                    $studentEducationData = array('user_ref_id' => $userId, 'class_level' => $pClass, 'status' => $presentClassStatus, 'school_name' => $postData['present_school'], 'board_ref_id' => $board_ref_id, 'month' => $postData['passout_month'], 'year' => $postData['passout_year'], 'added_on' => date('Y-m-d H:i:s'));
                    $studentEducationModel->attributes = $studentEducationData;
                    $studentEducationModel->save();
                } else {
                    $studentEducationData = array('user_ref_id' => $userId, 'class_level' => $pClass, 'status' => $presentClassStatus, 'school_name' => $postData['present_school'], 'board_ref_id' => $board_ref_id, 'added_on' => date('Y-m-d H:i:s'));
                    $studentEducationModel->attributes = $studentEducationData;
                    $studentEducationModel->save();
                }
                if(isset($_SESSION['sInstituteUnivariety']) && isset($_SESSION['sPartnersSlug'] ) && (@$slugnameDetails['hasCSSAccess'] == '1')){
                     $studentSignupModel->user_login($postData['username'], $postData['pass_word'],$hasCSSAccess=1);
                }else{
                     $studentSignupModel->user_login($postData['username'], $postData['pass_word']);
                }
               
//                 echo "<script language=JavaScript type='text/JavaScript'>";
//				echo "window.location= 'http://univartest.com/app/index.php/profile/country-preference'";
//				echo "</script>";
//				die();
                $redirectUrl = Yii::app()->params['cbasepath'] . Yii::app()->createUrl("profile/country-preference");
                $this->redirect($redirectUrl);
            }
        }
        if ((isset($_POST) && count($_POST) > 0) || $emailHash != '' ) {
            $schoolName = $postData['present_school'];
            $boardList1 = CHtml::listData($studentSignupModel->getBoardListBySchoolName($schoolName, $partnerStudentData['school_id']), 'board_id', 'board_desc');
            if (count($boardList1) != 0) {
                $boardList = $boardList1;
            }
            $yearList = $this->completeYear($postData['present_class']);
            $yearList = array_combine($yearList, $yearList);
        }
        $loginModel = new CommonLogin();
        $this->render('signup', array('userMasterModel' => $studentSignupModel, 'loginModel'=>$loginModel, 'schoolList' => $schoolList, 'boardList' => $boardList, 'postData' => $postData, 'year' => $yearList, 'partnerStudentData' => $partnerStudentData,'emailHash'=>$emailHash,'uniqueId' =>$uniqueId));
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionDynamicpassoutyear() {
        $yearlist = $this->completeYear($_POST['StudentSignup']['present_class']);
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('Select Year'), true);
        foreach ($yearlist as $key => $value) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($value), true);
        }
    }

    public function completeYear($class) {
        $classNumeric = substr($class, 0, $class == '9p' ? 1 : 2);
        switch ($class) {
            case '9p':
            case '10p':
            case '11p':
            case '12p':
                $startLimit = date("Y") + (12 - $classNumeric);
                $endLimit = $startLimit + 3;
                $arr = range($startLimit, $endLimit);
                break;
            case '12c':
                $startLimit = date("Y");
                $endLimit = $startLimit - 2;
                $arr = range($startLimit, $endLimit);
                break;
            default:
                $startLimit = date("Y");
                $endLimit = $startLimit - 2;
                $arr = range($startLimit, $endLimit);
                break;
        }
        return $arr;
    }

    public function actionGetBoardList() {
        $schoolName = $_POST['school_name'];
        $schoolHiddenId = $_POST['school_id'];
        $signUpModel = new StudentSignup();

        $userBoardList = $signUpModel->getBoardListBySchoolName($schoolName, $schoolHiddenId);
        //print_r($userBoardList);die;
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('--Select Board--'), true);
        if (count($userBoardList) > 0 && $_POST['school_name'] != '') {
            foreach ($userBoardList as $key => $value) {
                echo CHtml::tag('option', array('value' => $value['board_id']), CHtml::encode($value['board_desc']), true);
            }
        } else {
            $boardlookup = new LookupBoard;
            $boardList = CHtml::listData($boardlookup->findAll(), 'board_id', 'board_desc');
            foreach ($boardList as $key => $value) {
                echo CHtml::tag('option', array('value' => $key), CHtml::encode($value), true);
            }
        }
    }

    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'postRegistration') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAjaxDisplayMasterSchool() {
        $schoolId = Yii::app()->request->getPost('schoolId');
        $type = Yii::app()->request->getPost('type');
        $emailId = Yii::app()->request->getPost('emailId');
        $studentSignupModel = new StudentSignup;
        if (!empty($type) && $type == 'yes') {
            $schoolData = $studentSignupModel->getSchoolNameBySchoolid($schoolId);
            $fldschool_name = $schoolData->school_name;
            $fldschool_id = $schoolData->school_id;
            echo "$fldschool_name|$fldschool_id \n"; 
                    
        } else {
            $result = $studentSignupModel->deleteStudentFromStudentMaster($emailId);
        }
    }

}

?>
