<?php

class SignupsController extends Controller {

    public $currentStudyLevelArray = array(
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );
    public $current_class;
    public $loginRefId;

    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
    }

    public function actionIndex() {
        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $userId = $userSession['UserId'];
            CommonUtils::checkUserRedirection($userId);
        }

        $this->setPageTitle(Yii::app()->name ." - Create a new account");

        $model = new StudentSignupB2C('firstPage');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {

            $model->attributes=$_POST['StudentSignupB2C'];
            if ($model->validate()) {

                if((Yii::app()->session['boardId'] != '') && (Yii::app()->session['countryId'] != '') && (Yii::app()->session['departmentId'] != '') && (Yii::app()->session['educationType'] != '')  &&   (Yii::app()->session['overallMarks'] != '') )
                {
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_ideal_list',), 1);
                } else {
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_finish',), 1);

                }

                $redirectUrlRefId = $urlDetails[0]['url_id'];
                $afterSignupRedirectUrl = $urlDetails[0]['url'];

                $postData = Yii::app()->request->getPost('StudentSignupB2C');
                $studentSignupModel = new StudentSignup('firstPage');
                $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
                $studentSignupModel->set_session("unique_id", $uniqueId);
                $this->current_class = $postData['present_class'];

                $loginMasterData = array('username' => $postData['username'], 'pass_word' => md5($postData['password']),
                    'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $userMembershipRefId = $studentSignupModel->getMembershipId('Guest');
                $class_data = $this->DynamicPassoutYearAndMonth();

                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,
                    'first_name' => ucwords(strtolower(trim($postData['first_name']))), 'last_name' => ucwords(strtolower(trim($postData['last_name']))),
                    'membership_ref_id' => $userMembershipRefId['membership_id'], 'gender' => $postData['gender'],
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'redirect_url_ref_id' => $redirectUrlRefId,
                    'profile_status_ref_id' => '3', 'passout_year' => $class_data['passout_year'],
                    'passout_month' => $class_data['passout_month'],
                    added_on => date('Y-m-d H:i:s'),
                );

                $userMasterModel = new TblUserMaster;
                $userMasterModel->attributes = $userMasterData;
                $userMasterModel->save(false);

                $student_det = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$this->loginRefId));
                StudentPreferredStudyLevel::addStudentPreferences($student_det->user_id, array(5));

                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($student_det->user_id);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 4);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 5);

                $criticalFields = array(
                    'name' => 1,
                    'gender' => 1,
                    'study_level'=>1,
                    'preferred_course_duration'=>1,
                    'edu_study_level'=>1,
                    'completion_year'=>1,
                );

                if(Yii::app()->session['countryId'] != '') {
                    // add country preference
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                    StudentPreferredCountry::model()->deleteAll($criteria);

                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $student_det->user_id;
                    $obj->{country_ref_id} = Yii::app()->session['countryId'];
                    $obj->{preference_order} = 1;
                    $obj->save();

                    Yii::app()->session['countryId'] = null;
                    $criticalFields['country'] = 1;
                }

                if(Yii::app()->session['departmentId'] != '') {
                    // add department preference
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                    StudentPreferredDepartment::model()->deleteAll($criteria);

                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $student_det->user_id;
                    $obj->{main_dept_ref_id} = Yii::app()->session['departmentId'];
                    $obj->{sub_dept_ref_id} = '';
                    $obj->{preference_order} = 1;
                    $obj->{course_ref_id} = null;
                    $obj->save(false);

                    Yii::app()->session['departmentId'] = null;
                    $criticalFields['intended_subjects'] = 1;
                }


                if((Yii::app()->session['educationType'] != '') && (Yii::app()->session['overallMarks'] != '') && (Yii::app()->session['boardId'] != '') ) {
                    $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                    if ($edu_det->student_education_id) {
                        $criteria = new CDbCriteria;
                        $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                        StudentGradeCount::model()->deleteAll($criteria);

                        $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                    } else {
                        $edu_obj = new StudentEducation();
                        $edu_obj->user_ref_id = $student_det->user_id;
                        $edu_obj->class_level = 12;
                        $edu_obj->added_on = date('Y-m-d H:i:s');
                    }
                    $edu_obj->board_ref_id = Yii::app()->session['boardId'];

                    switch(Yii::app()->session['educationType']) {
                        case 'grades':
                            $edu_obj->overall_marks = NULL;
                            break;
                        case 'marks':
                        case 'points':
                        case 'marks-gpa':
                            $edu_obj->overall_marks =Yii::app()->session['overallMarks'];
                            break;
                    }
                    $edu_obj->save(false);

                   
                    if (Yii::app()->session['educationType'] == 'grades') {
                        $gradeArr = json_decode(Yii::app()->session['overallMarks'],true);
                        $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                        if ($edu_det_new->student_education_id) {
                            if ($gradeArr['aa']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 1;$grade_model->grade_count = $gradeArr['aa'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }
                            if ($gradeArr['a']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 2;$grade_model->grade_count = $gradeArr['a'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['b']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 3;$grade_model->grade_count = $gradeArr['b'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['c']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 4;$grade_model->grade_count = $gradeArr['c'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['d']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 5;$grade_model->grade_count = $gradeArr['d'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }
                        }


                    }
                    Yii::app()->session['educationType'] = null;
                    Yii::app()->session['overallMarks'] = null;
                    Yii::app()->session['boardId'] = null;
                    $criticalFields['board'] = 1;
                    $criticalFields['overall_marks'] = 1;

                }
                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);
                $this->sendConfirmationEmail($postData['first_name'], $postData['username']);
                Yii::app()->session['signupProcess'] = 'guestSignup';

                setFlashMessage('success_notify', 'globalnotifications.profile_created');
                $loginModel = new LoginMaster();
                $loginModel->loginWithRedirect($postData['username'], md5($postData['password']), $afterSignupRedirectUrl);
            }
        }

        $this->render('index', array('model'=>$model));
    }

    public function actionFinish() {
        $this->render('finish');
    }

    public function DynamicPassoutYearAndMonth() {
        $current_month = date('n');
        $year = date('Y');
        $return = array();
        switch ($this->current_class) {
            case '11p':
                    if ($current_month < 6) {
                        $return['passout_year'] = $year + 1;
                    } else {
                        $return['passout_year'] = $year + 2;
                    }
                    $return['passout_month'] = 6;
                    $return['present_class'] = 11;
                    $return['class_status'] = 'Pursuing';
                break;
            case '12p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year;
                } else {
                    $return['passout_year'] = $year + 1;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 12;
                $return['class_status'] = 'Pursuing';
                break;
            case '12c':
                $return['passout_year'] = 0;
                $return['passout_month'] = 0;
                $return['present_class'] = 12;
                $return['class_status'] = 'Completed';
                break;
        }
        return $return;
    }

    public function sendConfirmationEmail($firstName = false, $email = false) {

        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        $siteURL = $protocol . '://' . $_SERVER['SERVER_NAME'];

        $msg = $this->renderPartial('../signup/confirmationTemplateMail', array('firstName' => $firstName, 'email' => $email, 'siteURL' => $siteURL), true);

        $params = array();
        $params['EmailMessage']['subject'] = 'Registration Confirmation';
        $params['EmailMessage']['body'] = $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] = '';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] = $email;
        $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);

        $status = Yii::app()->runController("sms/email/addMessage");
    }
}