<?php

/*
 * Student profile controller for student
 * 
 */

class StudentProfileController extends Controller {

    public $userId, $loginRefId, $rbacRole, $likelyStartPeriodYear, $userSession;
    public $hasEdit = false;
    public $isDI = false;
    public $schoolRefId, $schoolName, $slugName = null;
    public $studentExtraParams = array();
    public $schoolNameOnBlur = 'Type & select your school name...';
    public $aspireSchoolOnBlur = 'Type college name...';
    public $userProfCriticalFields = array();
    public $imageUploadErrorMessage = '';
    public $userImage = '';
    public $isUserImageAvailable = false;
    public $isUploading = false;
    public $userParams = array();
    public $userData;
    public $currentStudyLevelArray = array(
        '12c' => 'Completed - 12th or equivalent',
        '12p' => 'Pursuing - 12th or equivalent',
        '11p' => 'Pursuing - 11th or equivalent',
            //'10p' => 'Pursuing - 10th or equivalent',
            //'9p' => 'Pursuing - 9th or equivalent',
    );
    public $defaultUserData = array('M' => array('gender' => 'Male', 'defaultImage' => 'user_img_male.jpg'), 'F' => array('gender' => 'Female', 'defaultImage' => 'user_img_female.jpg'));

    public function filters() {
        return array(
            'rights',
        );
    }

    public function init() {
        parent::init();
        Yii::app()->theme = 'uni_avada';
		
		   $this->layout = "//layouts/inner_page";
				
		$this->pageTitle = 'Univariety - Edit Profile';

        $this->userId = CommonUtils::getSessionValue('sUserUnivariety', 'UserId');
        $this->loginRefId = Yii::app()->user->id;
        $this->rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if ($this->userId < 1 && Yii::app()->request->getParam('uid') > 0 && ($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin' || $this->rbacRole == 'DI')) {
            $this->userId = Yii::app()->request->getQuery('uid');
        }
        if ($this->rbacRole == 'Student' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin') {
            $this->hasEdit = true;
        }

        if ($this->userId == '' || $this->userId <= 0) {
            $this->redirect(Yii::app()->createUrl('login'));
        }

        if ($this->rbacRole == 'SI') {
            $siDetail = TblSiDi::GetSchoolLookupId($this->loginRefId);
            $userDetail = TblUserMaster::getUserDetails($this->userId);
            if ($userDetail->school_ref_id != $siDetail->school_ref_id) {
                $this->redirect(Yii::app()->createUrl('login'));
            }
        }

        if ($this->rbacRole == 'DI') {
            $this->isDI = true;
            $this->hasEdit = false;
        }

        if ($this->rbacRole != 'Student') {
            $this->userParams = array('uid' => $this->userId);
        }



        if ($this->userData->present_class == 9 || $this->userData->present_class == 10) {
            $this->hasEdit = false;
        }
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'uni_ranking') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    /* Student profile basic information tab */

    public function actionIndex() {
        //echo '<pre>';
        $loginId = Yii::app()->user->id;
        $userId = $this->userId;
        $this->pageTitle = 'Univariety - Edit Basic Info';
        if (count($_POST) == 0) {
            $tblUserMasterModel = TblUserMaster::model()->with('schoolRef', 'loginRef')->findByPk($userId);
            $studentBasicInfoModel = new StudentEditProfile();
            foreach ($studentBasicInfoModel->attributes as $key => $value) {
                $studentBasicInfoModel->{$key} = $tblUserMasterModel->attributes[$key];
            }
            //print_r($tblUserMasterModel->attributes);print_r($tblUserMasterModel->schoolRef->attributes);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            $studentBasicInfoModel->gender = $tblUserMasterModel->gender;
            if ($tblUserMasterModel->user_photo != '') {
                if (file_exists($userImagePath . $tblUserMasterModel->user_photo)) {
                    $this->userImage = $userImagePath . $tblUserMasterModel->user_photo;
                    $this->isUserImageAvailable = true;
                } else {
                    $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
                }
            }
            if ($this->userImage == '') {
                $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
            }
            $emailId = $tblUserMasterModel->loginRef->username;
            $dob = explode('-', $tblUserMasterModel->attributes['dob']);
            $studentBasicInfoModel->dob_date = $dob[2];
            $studentBasicInfoModel->dob_month = $dob[1];
            $studentBasicInfoModel->dob_year = $dob[0];
            $studentBasicInfoModel->school_name = $tblUserMasterModel->schoolRef->school_name;
            $ethnicityList = CHtml::listData(MasterEthnicity::getEthnicityDetails(), 'ethnicity_id', 'ethnicity_name');
            $citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');
            $tblStudentContactModel = StudentContactNumber::model()->with('contactTypeRef')->find(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id ="1"'));
            $studentBasicInfoModel->student_country_code = $tblStudentContactModel->country_code;
            $studentBasicInfoModel->student_number = $tblStudentContactModel->number;
            $i = 1;
            if (trim($tblUserMasterModel->father_first_name) != '') {
                $fatherContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '2');
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 2;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->father_first_name;
                $parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->father_last_name;
                foreach ($fatherContactInfos as $key => $fatherContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $fatherContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $fatherContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $fatherContactInfo->student_contact_number_id;
                    $id++;
                }
                $fatherEmailInfos = StudentAlternateEmail::getEmailsOfParent($loginId, '2');
                $id = 1;
                foreach ($fatherEmailInfos as $key => $fatherEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $fatherEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $fatherEmailInfo->student_alternate_email_id;
                    $id++;
                }
                $i++;
            }
            if (trim($tblUserMasterModel->mother_first_name) != '') {
                $motherContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '3');
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 3;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->mother_first_name;
                $parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->mother_last_name;
                foreach ($motherContactInfos as $key => $motherContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $motherContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $motherContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $motherContactInfo->student_contact_number_id;
                    $id++;
                }
                $motherEmailInfos = StudentAlternateEmail::getEmailsOfParent($loginId, '3');
                $id = 1;
                foreach ($motherEmailInfos as $key => $motherEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $motherEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $motherEmailInfo->student_alternate_email_id;
                    $id++;
                }
                $i++;
            }
            if (trim($tblUserMasterModel->guardian_first_name) != '') {
                $guardianContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '4');
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 4;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->guardian_first_name;
                $parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->guardian_last_name;
                foreach ($guardianContactInfos as $key => $guardianContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $guardianContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $guardianContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $guardianContactInfo->student_contact_number_id;
                    $id++;
                }
                $guardianEmailInfos = StudentAlternateEmail::getEmailsOfParent($loginId, '4');
                $id = 1;
                foreach ($guardianEmailInfos as $key => $guardianEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $guardianEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $guardianEmailInfo->student_alternate_email_id;
                    $id++;
                }
            }

            //print_r($parentDetailModels);die('dd');
            if (!$parentDetailModels) {
                $parentDetailModels[1] = new ParentDetail();
            }

            $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
        } else {
            $studentBasicPostData = Yii::app()->request->getPost('StudentEditProfile');
            $parentPostData = array();
            $parentPostData = Yii::app()->request->getPost('ParentDetail');
            $tblUserMasterModel = TblUserMaster::model()->with('schoolRef', 'loginRef')->findByPk($userId);
            $studentBasicInfoModel = new StudentEditProfile('basicInfo');
            $studentBasicInfoModel->attributes = $studentBasicPostData;
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($tblUserMasterModel->user_photo != '') {
                if (file_exists($userImagePath . $tblUserMasterModel->user_photo)) {
                    $this->userImage = $userImagePath . $tblUserMasterModel->user_photo;
                    $this->isUserImageAvailable = true;
                } else {
                    $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
                }
            }
            if ($this->userImage == '') {
                $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
            }
            $errorCounter1 = 0;
            $errorCounter2 = 0;
            if ($studentBasicInfoModel->validate()) {
                $errorCounter1++;
            }
            if ($studentBasicInfoModel->hasErrors()) {
                foreach ($studentBasicInfoModel->getErrors() as $key => $value) {
                    foreach ($value as $errorMsg) {
                        $studentBasicInfoModel->clearErrors();
                        $studentBasicInfoModel->addError($key, $errorMsg);
                        $customError = $errorMsg;
                        break 2;
                    }
                }
            }
            $parentArray = array();
            foreach ($parentPostData as $key => $data) {
                if ($data['contact_type_ref_id'] != '' && $data['parent_first_name'] != '') {
                    $parentDetailModels[$key] = new ParentDetail('basicInfo');
                    $parentDetailModels[$key]->attributes = $data;
                    if (in_array($parentDetailModels[$key]->contact_type_ref_id, $parentArray)) {
                        $parentDetailModels[$key]->addError('contact_type_ref_id', 'Duplicate parent selected. Please select another parent.');
                        $errorCounterParentUnique = 1;
                    } else {
                        $parentArray[] = $parentDetailModels[$key]->contact_type_ref_id;
                    }
                }
            }
            foreach ($parentDetailModels as $key => $data) {
                if ($errorCounter1 > 0 && $errorCounterParentUnique == 0) {
                    if ($parentDetailModels[$key]->validate()) {
                        $errorCounter2++;
                    }
                }
                if ($parentDetailModels[$key]->hasErrors()) {
                    foreach ($parentDetailModels[$key]->getErrors() as $k => $val) {
                        foreach ($val as $errorMsg) {
                            $parentDetailModels[$key]->clearErrors();
                            $parentDetailModels[$key]->addError($k, $errorMsg);
                            $customError = $errorMsg;
                            break 3;
                        }
                    }
                }
            }
            $ethnicityList = CHtml::listData(MasterEthnicity::getEthnicityDetails(), 'ethnicity_id', 'ethnicity_name');
            $citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');
            $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
            //$studentBasicInfoModel->gender = ($tblUserMasterModel->gender != '') ? $tblUserMasterModel->gender : 'M';
            $emailId = $tblUserMasterModel->loginRef->username;

            if (!$customError) {
                $nameFlag = 0;
                $genderFlag = 0;
                $schoolFlag = 0;
                $citizenshipFlag = 0;
                $studentContactFlag = 0;
                $tblUserMasterModel->attributes = $studentBasicInfoModel->attributes;
                $tblUserMasterModel->introduce_yourself = substr($studentBasicInfoModel->introduce_yourself, 0, 2000);
                $tblUserMasterModel->dob = implode('-', array($studentBasicInfoModel->dob_year, $studentBasicInfoModel->dob_month, $studentBasicInfoModel->dob_date));
                if ($tblUserMasterModel->first_name != '') {
                    $nameFlag = 1;
                }
                if ($tblUserMasterModel->gender != '') {
                    $genderFlag = 1;
                }
                $schoolExistID = LookupSchool::getSchoolID($studentBasicInfoModel->school_name);
                if ($schoolExistID) {
                    $tblUserMasterModel->school_ref_id = $schoolExistID;
                } else {
                    LookupSchool::addStudentSchool($studentBasicInfoModel->school_name);
                    $schoolExistID = LookupSchool::getSchoolID($studentBasicInfoModel->school_name);
                    $tblUserMasterModel->school_ref_id = $schoolExistID;
                }
                if ($tblUserMasterModel->school_ref_id != '') {
                    $schoolFlag = 1;
                }
                if ($tblUserMasterModel->studentCitizenships->citizenship_ref_id != '') {
                    $citizenshipFlag = 1;
                }
                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->save(false);
                $tblStudentContactModel = StudentContactNumber::model()->with('contactTypeRef')->find(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id ="1"'));
                if (!$tblStudentContactModel) {
                    $tblStudentContactModel = new StudentContactNumber();
                }
                $tblStudentContactModel->country_code = $studentBasicInfoModel->student_country_code;
                $tblStudentContactModel->number = $studentBasicInfoModel->student_number;
                if ($tblStudentContactModel->number != '') {
                    $studentContactFlag = 1;
                }
                $tblStudentContactModel->contact_type_ref_id = 1;
                $studentCountryInfo = TblCountryMaster::getCountryInfoByCode($studentBasicInfoModel->student_country_code);
                $tblStudentContactModel->country_ref_id = $studentCountryInfo->country_id;
                $tblStudentContactModel->user_ref_id = $userId;
                $tblStudentContactModel->is_primary = 1;
                if ($tblStudentContactModel->student_contact_number_id) {
                    $tblStudentContactModel->modified_by = $loginId;
                    $tblStudentContactModel->modified_on = date('Y-m-d H:i:s');
                    $tblStudentContactModel->setIsNewRecord(false);
                } else {
                    $tblStudentContactModel->added_by = $loginId;
                }
                $tblStudentContactModel->save(false);
                $userMasterModel = TblUserMaster::model()->findByPk($userId);
                $userMasterModel->father_first_name = NULL;
                $userMasterModel->father_last_name = NULL;
                $userMasterModel->mother_first_name = NULL;
                $userMasterModel->mother_last_name = NULL;
                $userMasterModel->guardian_first_name = NULL;
                $userMasterModel->guardian_last_name = NULL;
                foreach ($parentDetailModels as $key => $parentDetailModel) {
                    //$fatherContactModels = StudentContactNumber::model()->with('contactTypeRef')->findAll(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id = "2"'));
                    
                    if ($parentDetailModel->contact_type_ref_id == 2) {
                        $userMasterModel->father_first_name = $parentDetailModel->parent_first_name;
                        $userMasterModel->father_last_name = $parentDetailModel->parent_last_name;
                    } elseif ($parentDetailModel->contact_type_ref_id == 3) {
                        $userMasterModel->mother_first_name = $parentDetailModel->parent_first_name;
                        $userMasterModel->mother_last_name = $parentDetailModel->parent_last_name;
                        ;
                    } elseif ($parentDetailModel->contact_type_ref_id == 4) {
                        $userMasterModel->guardian_first_name = $parentDetailModel->parent_first_name;
                        $userMasterModel->guardian_last_name = $parentDetailModel->parent_last_name;
                        ;
                    }
                    
                    if ($parentDetailModel->number1 != '') {
                        $fatherContactModel = new StudentContactNumber();
                        $id = 1;
                        $fatherContactModel->user_ref_id = $userId;
                        $fatherContactModel->is_primary = 0;
                        $fatherContactModel->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherContactModel->country_code = $parentDetailModel->country_code1;
                        $fatherContactModel->number = $parentDetailModel->number1;
                        $countryId = TblCountryMaster::getCountryInfoByCode($parentDetailModel->country_code1);
                        $fatherContactModel->country_ref_id = $countryId->country_id;
                        if ($parentDetailModel->student_contact_number_id1 > 0) {
                            $fatherContactModel->student_contact_number_id = $parentDetailModel->student_contact_number_id1;
                            $fatherContactModel->modified_by = $loginId;
                            $fatherContactModel->modified_on = date('Y-m-d H:i:s');
                            $fatherContactModel->setIsNewRecord(false);
                        } else {
                            $fatherContactModel->added_by = $loginId;
                        }
                        $fatherContactModel->save(false);
                    } elseif ($parentDetailModel->student_contact_number_id1 > 0) {
                        //delete contact
                        StudentContactNumber::model()->deleteByPk($parentDetailModel->student_contact_number_id1);
                    }
                    if ($parentDetailModel->number2 != '') {
                        $fatherContactModel1 = new StudentContactNumber();
                        $id = 1;
                        $fatherContactModel1->user_ref_id = $userId;
                        $fatherContactModel1->is_primary = 0;
                        $fatherContactModel1->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherContactModel1->country_code = $parentDetailModel->country_code2;
                        $fatherContactModel1->number = $parentDetailModel->number2;
                        $countryId = TblCountryMaster::getCountryInfoByCode($parentDetailModel->country_code2);
                        $fatherContactModel1->country_ref_id = $countryId->country_id;
                        if ($parentDetailModel->student_contact_number_id2 > 0) {
                            $fatherContactModel1->student_contact_number_id = $parentDetailModel->student_contact_number_id2;
                            $fatherContactModel1->modified_by = $loginId;
                            $fatherContactModel1->modified_on = date('Y-m-d H:i:s');
                            $fatherContactModel1->setIsNewRecord(false);
                        } else {
                            $fatherContactModel1->added_by = $loginId;
                        }
                        $fatherContactModel1->save(false);
                    } elseif ($parentDetailModel->student_contact_number_id2 > 0) {
                        //delete contact
                        StudentContactNumber::model()->deleteByPk($parentDetailModel->student_contact_number_id2);
                    }

                    if ($parentDetailModel->email_id1 != '') {
                        $fatherEmailModel = new StudentAlternateEmail();
                        $fatherEmailModel->login_ref_id = $loginId;
                        $fatherEmailModel->is_primary = 0;
                        $fatherEmailModel->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherEmailModel->email_id = $parentDetailModel->email_id1;
                        if ($parentDetailModel->student_alternate_email_id1 > 0) {
                            $fatherEmailModel->student_alternate_email_id = $parentDetailModel->student_alternate_email_id1;
                            $fatherEmailModel->modified_by = $loginId;
                            $fatherEmailModel->modified_on = date('Y-m-d H:i:s');
                            $fatherEmailModel->setIsNewRecord(false);
                        } else {
                            $fatherEmailModel->added_by = $loginId;
                        }
                        $fatherEmailModel->save(false);
                    } elseif ($parentDetailModel->student_alternate_email_id1 > 0) {
                        //delete contact email
                        StudentAlternateEmail::model()->deleteByPk($parentDetailModel->student_alternate_email_id1);
                    }
                    if ($parentDetailModel->email_id2 != '') {
                        $fatherEmailModel1 = new StudentAlternateEmail();
                        $fatherEmailModel1->login_ref_id = $loginId;
                        $fatherEmailModel1->is_primary = 0;
                        $fatherEmailModel1->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherEmailModel1->email_id = $parentDetailModel->email_id2;
                        if ($parentDetailModel->student_alternate_email_id2 > 0) {
                            $fatherEmailModel1->student_alternate_email_id = $parentDetailModel->student_alternate_email_id2;
                            $fatherEmailModel1->modified_by = $loginId;
                            $fatherEmailModel1->modified_on = date('Y-m-d H:i:s');
                            $fatherEmailModel1->setIsNewRecord(false);
                        } else {
                            $fatherEmailModel1->added_by = $loginId;
                        }
                        $fatherEmailModel2->save(false);
                    } elseif ($parentDetailModel->student_alternate_email_id2 > 0) {
                        //delete contact email
                        StudentAlternateEmail::model()->deleteByPk($parentDetailModel->student_alternate_email_id2);
                    }
                }
                // Saving parent name into TblUserMaster
                $userMasterModel->save(false);

                $criticalFields = array(
                    'name' => $nameFlag,
                    'gender' => $genderFlag,
                    'school_name' => $schoolFlag,
                    'citizenship' => $citizenshipFlag,
                    'phone' => $studentContactFlag,
                    'overall_marks' => $overallMarksFlag,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'Basic Information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/studentProfile/educationDetail', $this->userParams));
            }
        }

        $this->render('basicInfo', array('tblUserMasterModel' => $tblUserMasterModel, 'studentBasicInfoModel' => $studentBasicInfoModel, 'parentDetailModels' => $parentDetailModels, 'ethnicityList' => $ethnicityList, 'citizenshipList' => $citizenshipList, 'tblParentContactModel' => $tblParentContactModel,
            'tblParentEmailModel' => $tblParentEmailModel, 'contactTypeList' => $contactTypeList, 'parentRelationship' => $parentRelationship, 'emailId' => $emailId, 'tblStudentContactModel' => $tblStudentContactModel, 'customError' => $customError));
    }

    public function actionEducationDetail() {
        $this->breadcrumbs = array(
            'Home' => array('/home'),
            'My Profile' => array('/student/studentProfile'),
            'Edit Profile',
        );

        $this->pageTitle = Yii::app()->name . ' - Edit Education Detail';
        $loginId = Yii::app()->user->id;
        $userId = $this->userId;
        $customError = "";
        $testYearList = range((date("Y") - 3), (date("Y") + 4));
        $testYearList = array_combine($testYearList, $testYearList);
        if (count($_POST) == 0) {
            $studentEducationInfoModel12 = new StudentEducationProfile();
            $tblUserMasterModel = TblUserMaster::model()->findByPk($userId);
            if ($tblUserMasterModel->class_status == 'Pursuing') {
                $classStatus = 'p';
            } elseif ($tblUserMasterModel->class_status == 'Completed') {
                $classStatus = 'c';
            }
            $studentEducationInfoModel12->present_class = $tblUserMasterModel->present_class . $classStatus;
            $studentEducationInfoModel12->passout_month = $tblUserMasterModel->passout_month;
            $studentEducationInfoModel12->passout_year = $tblUserMasterModel->passout_year;
            $boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
            $boardList12 = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');
            $yearList12 = UniversityHelper::complitionYearList('12', $tblUserMasterModel->passout_year);
            $gradeData = LookupGrade::getgradeList();
            $gradeArray = CHtml::listData($gradeData, 'grade_id', 'grade_type');
            $gradeArray = str_replace('aa', 'a*', $gradeArray);
            $studentEducation12Profile = StudentEducation::getStudentEducationDetails($userId, '12');
            $boardId12 = $studentEducation12Profile->board_ref_id;
            $studentEducationInfoModel12->board_equivalent_id = $studentEducation12Profile->board_ref_id;
            $studentEducationInfoModel12->school_name = $studentEducation12Profile->school_name;
            if ($studentEducation12Profile->board_ref_id != '') {
                $boardDetail12 = LookupBoardEquivalent::getBoardDetailById($boardId12);
            }
            $subjectDetail12 = StudentEducation::getSubjectDetail('12', $userId);

            //$subjectDetail = array();
            if ($boardDetail12['overall_type'] == 'Marks') {
                $studentEducationInfoModel12->overall_marks = $studentEducation12Profile->overall_marks;
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->marks = $value->marks;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail12['overall_type'] == 'Points') {
                $studentEducationInfoModel12->overall_points = $studentEducation12Profile->overall_points;
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->points = $value->points;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail12['overall_type'] == 'Grades') {
                $gradeDetail = StudentEducation::getGradeDetail('12', $userId);
                foreach ($gradeDetail as $k => $val) {
                    foreach ($val->studentGradeCounts as $key => $value) {
                        $studentEducationInfoModel12->{'overall_grades_' . $value->gradeRef->grade_type} = $value->grade_count;
                    }
                }
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            }
            if (!$marksDetailModels12) {
                $marksDetailModels12[1] = new StudentSubjectDetail();
            } else {
                $marksDetailModels12[$key + 2] = new StudentSubjectDetail();
            }
            $modelSubjects12 = LookupSubjectMaster::getSubjectsList($boardId12);
            $marksSubjectList12 = CHtml::listData($modelSubjects12, 'student_subject_id', 'subject_name');
            // For 10th 
            $studentEducationInfoModel10 = new StudentEducationProfile();
            $boardLookup10 = LookupBoardEquivalent::GetSchoolBoardList('10');
            $boardList10 = CHtml::listData($boardLookup10, 'board_equivalent_id', 'board_desc');
            $yearList10 = UniversityHelper::complitionYearList('10', $studentEducationInfoModel12->passout_year);
            $studentEducation10Profile = StudentEducation::getStudentEducationDetails($userId, '10');
            $boardId10 = $studentEducation10Profile->board_ref_id;
            $studentEducationInfoModel10->board_equivalent_id = $studentEducation10Profile->board_ref_id;
            $studentEducationInfoModel10->school_name = $studentEducation10Profile->school_name;
            $studentEducationInfoModel10->passout_year = $studentEducation10Profile->year;
            $studentEducationInfoModel10->passout_month = $studentEducation10Profile->month;
            if ($studentEducation10Profile->board_ref_id != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($boardId10);
            }
            $subjectDetail10 = StudentEducation::getSubjectDetail('10', $userId);

            if ($boardDetail10['overall_type'] == 'Marks') {
                $studentEducationInfoModel10->overall_marks = $studentEducation10Profile->overall_marks;
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels10[$key + 1]->marks = $value->marks;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail10['overall_type'] == 'Points') {
                $studentEducationInfoModel10->overall_points = $studentEducation10Profile->overall_points;
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels10[$key + 1]->points = $value->points;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail10['overall_type'] == 'Grades') {
                $gradeDetail = StudentEducation::getGradeDetail('10', $userId);
                foreach ($gradeDetail as $k => $val) {
                    foreach ($val->studentGradeCounts as $key => $value) {
                        $studentEducationInfoModel10->{'overall_grades_' . $value->gradeRef->grade_type} = $value->grade_count;
                    }
                }
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels10[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            }
            if (!$marksDetailModels10) {
                $marksDetailModels10[1] = new StudentSubjectDetail();
            } else {
                $marksDetailModels10[$key + 2] = new StudentSubjectDetail();
            }
            $modelSubjects10 = LookupSubjectMaster::getSubjectsList($boardId10);
            $marksSubjectList10 = CHtml::listData($modelSubjects10, 'student_subject_id', 'subject_name');

            // Test Module

            $userTestInfo = UserEntranceExam::getUserExamsInfo($userId);
            if ($userTestInfo) {
                foreach ($userTestInfo as $key => $data) {
                    $userTestModels[$key + 1] = new StudentTestDetail();
                    $userTestModels[$key + 1]->attributes = $data->attributes;
                    if ($data->userEntranceExamModules) {
                        foreach ($data->userEntranceExamModules as $k => $value) {
                            $userTestModels[$key + 1]->child[$k + 1] = new StudentTestModuleDetail();
                            $userTestModels[$key + 1]->child[$k + 1]->attributes = $value->attributes;
                        }
                    } else {
                        $userTestModels[$key + 1]->child[1] = new StudentTestModuleDetail();
                    }
                    if ($data->entrance_exam_ref_id) {
                        $testModulelist = EntranceExamModule::getEntranceModuleList($data->entrance_exam_ref_id);
                        $userTestModels[$key + 1]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                    }
                }
            } else {
                $userTestModels[1] = new StudentTestDetail();
            }
            $getAllTest = EntranceExam::getAllEntranceExams();
            $examlist = CHtml::listData($getAllTest, 'entrance_id', 'entrance_short_name');
        } else {
            //print_r($_POST);
            $customError = '';
            $studentEducationInfoData = Yii::app()->request->getPost('StudentEducationProfile');
            $studentEducationMarksData = Yii::app()->request->getPost('StudentSubjectDetail');
            if ($studentEducationInfoData['12']['board_equivalent_id'] != '') {
                $boardDetail12 = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoData['12']['board_equivalent_id']);
            }
            if ($boardDetail12['overall_type'] == 'Marks') {
                $scenario = $boardDetail12['overall_type'];
                unset($studentEducationMarksData['12']['Points']);
                unset($studentEducationMarksData['12']['Grades']);
            } elseif ($boardDetail12['overall_type'] == 'Points') {
                $scenario = $boardDetail12['overall_type'];
                unset($studentEducationMarksData['12']['Marks']);
                unset($studentEducationMarksData['12']['Grades']);
            } elseif ($boardDetail12['overall_type'] == 'Grades') {
                $scenario = $boardDetail12['overall_type'];
                unset($studentEducationMarksData['12']['Marks']);
                unset($studentEducationMarksData['12']['Points']);
            }
            $studentEducationInfoModel12 = new StudentEducationProfile($scenario);
            $studentEducationInfoModel12->attributes = $studentEducationInfoData['12'];
            $schoolNameFlag = 0;
            $passoutYearFlag = 0;
            $boardFlag = 0;
            $overallMarksFlag = 0;
            $currentStudyFlag = 0;
            if ($studentEducationInfoModel12->present_class) {
                $currentStudyFlag = 1;
            }
            if ($studentEducationInfoModel12->school_name) {
                $schoolNameFlag = 1;
            }
            if ($studentEducationInfoModel12->passout_month && $studentEducationInfoModel12->passout_year) {
                $passoutYearFlag = 1;
            }
            if ($studentEducationInfoModel12->board_equivalent_id) {
                $boardFlag = 1;
            }
            if ($scenario == 'Marks' && $studentEducationInfoModel12->overall_marks != '') {
                $overallMarksFlag = 1;
            } elseif ($scenario == 'Points' && $studentEducationInfoModel12->overall_points != '') {
                $overallMarksFlag = 1;
            } elseif ($scenario == 'Grades' && ($studentEducationInfoModel12->overall_grades_aa != '' || $studentEducationInfoModel12->overall_grades_a != '' || $studentEducationInfoModel12->overall_grades_b != '' || $studentEducationInfoModel12->overall_grades_c != '' || $studentEducationInfoModel12->overall_grades_d != '')) {
                $overallMarksFlag = 1;
            }
            $studentEducationInfoModel12->validate();
            $errorCounter12_1 = 0;
            $errorCounter12_2 = 0;
            if ($studentEducationInfoModel12->validate()) {
                $errorCounter12_1++;
            }
            if ($studentEducationInfoModel12->hasErrors()) {
                foreach ($studentEducationInfoModel12->getErrors() as $key => $value) {
                    foreach ($value as $errorMsg) {
                        $studentEducationInfoModel12->clearErrors();
                        $studentEducationInfoModel12->addError($key, $errorMsg);
                        $customError = $errorMsg;
                        break 2;
                    }
                }
            }
            $id = 1;
            $marksDetailModels12 = array();
            $subjectArray12 = array();
            foreach ($studentEducationMarksData['12'][$scenario] as $key => $data) {
                $marksDetailModels12[$id] = new StudentSubjectDetail();
                $marksDetailModels12[$id]->attributes = $data;
                $marksDetailModels12[$id]->scenario = $scenario;
                if ($errorCounter12_1 > 0) {
                    if ($scenario == 'Marks') {
                        $studentMarks = $marksDetailModels12[$id]->marks;
                    } elseif ($scenario == 'Grades') {
                        $studentMarks = $marksDetailModels12[$id]->grade_ref_id;
                        if ($marksDetailModels12[$id]->grade_ref_id) {
                            $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels12[$id]->grade_ref_id);
                            $marksDetailModels12[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                        }
                    } elseif ($scenario == 'Points') {
                        $studentMarks = $marksDetailModels12[$id]->points;
                    }
                    if ($customError == "" && $marksDetailModels12[$id]->student_subject_ref_id != '' && $studentMarks != '') {
                        $marksDetailModels12[$id]->insertFlag = 1;
                        if (in_array($marksDetailModels12[$id]->student_subject_ref_id, $subjectArray12)) {
                            $marksDetailModels12[$id]->addError('student_subject_ref_id', 'Duplicate subject selected. Please select another subject.');
                            $errorCounter12_unique = 1;
                        } else {
                            $subjectArray12[] = $marksDetailModels12[$id]->student_subject_ref_id;
                        }
                    }
                }
                $id++;
            }
            foreach ($marksDetailModels12 as $key => $data) {
                if ($customError == "") {
                    if ($marksDetailModels12[$key]->validate()) {
                        $errorCounter12_2++;
                    }
                }
                if ($marksDetailModels12[$key]->hasErrors()) {
                    foreach ($marksDetailModels12[$key]->getErrors() as $k => $val) {
                        foreach ($val as $errorMsg) {
                            $marksDetailModels12[$key]->clearErrors();
                            $marksDetailModels12[$key]->addError($k, $errorMsg);
                            $customError = $errorMsg;
                            break 3;
                        }
                    }
                }
            }
//            
            if ($studentEducationInfoData['10']['board_equivalent_id'] != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoData['10']['board_equivalent_id']);
            }
            if ($boardDetail10['overall_type'] == 'Marks') {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Points']);
                unset($studentEducationMarksData['10']['Grades']);
            } elseif ($boardDetail10['overall_type'] == 'Points') {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Marks']);
                unset($studentEducationMarksData['10']['Grades']);
            } elseif ($boardDetail10['overall_type'] == 'Grades') {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Marks']);
                unset($studentEducationMarksData['10']['Points']);
            }
            $studentEducationInfoModel10 = new StudentEducationProfile($scenario);
            $studentEducationInfoModel10->attributes = $studentEducationInfoData['10'];
            $studentEducationInfoModel10->present_class = $studentEducationInfoModel12->present_class;
            $errorCounter10_1 = 0;
            $errorCounter10_2 = 0;
            if ($customError == "") {
                if ($studentEducationInfoModel10->validate()) {
                    $errorCounter10_1++;
                }

                if ($studentEducationInfoModel10->hasErrors()) {
                    foreach ($studentEducationInfoModel10->getErrors() as $key => $value) {
                        foreach ($value as $errorMsg) {
                            $studentEducationInfoModel10->clearErrors();
                            $studentEducationInfoModel10->addError($key, $errorMsg);
                            $customError = $errorMsg;
                            break 2;
                        }
                    }
                }
            }
            $id = 1;
            $marksDetailModels10 = array();
            $subjectArray = array();
            foreach ($studentEducationMarksData['10'][$scenario] as $key => $data) {
                $marksDetailModels10[$id] = new StudentSubjectDetail();
                $marksDetailModels10[$id]->attributes = $data;
                $marksDetailModels10[$id]->scenario = $scenario;
                if ($errorCounter10_1 > 0) {
                    if ($scenario == 'Marks') {
                        $studentMarks = $marksDetailModels10[$id]->marks;
                    } elseif ($scenario == 'Grades') {
                        $studentMarks = $marksDetailModels10[$id]->grade_ref_id;
                        if ($marksDetailModels10[$id]->grade_ref_id) {
                            $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                            $marksDetailModels10[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                        }
                    } elseif ($scenario == 'Points') {
                        $studentMarks = $marksDetailModels10[$id]->points;
                    }
                    if ($customError == "" && $marksDetailModels10[$id]->student_subject_ref_id != '' && $studentMarks != '') {
                        $marksDetailModels10[$id]->insertFlag = 1;
                        if (in_array($marksDetailModels10[$id]->student_subject_ref_id, $subjectArray)) {
                            $marksDetailModels10[$id]->addError('student_subject_ref_id', 'Duplicate subject selected. Please select another subject.');
                            $errorCounter10_unique = 1;
                        } else {
                            $subjectArray[] = $marksDetailModels10[$id]->student_subject_ref_id;
                        }
                    }
                }
                $id++;
            }
            foreach ($marksDetailModels10 as $key => $data) {
                if ($customError == "") {
                    if ($marksDetailModels10[$key]->validate()) {
                        $errorCounter10_2++;
                    }
                    if ($marksDetailModels10[$key]->hasErrors()) {
                        foreach ($marksDetailModels10[$key]->getErrors() as $k => $val) {
                            foreach ($val as $errorMsg) {
                                $marksDetailModels10[$key]->clearErrors();
                                $marksDetailModels10[$key]->addError($k, $errorMsg);
                                $customError = $errorMsg;
                                break 3;
                            }
                        }
                    }
                }
            }

            $studentTestInfoData = Yii::app()->request->getPost('StudentTestDetail');
            $studentTestModuleData = Yii::app()->request->getPost('StudentTestModuleDetail');
            if (!$studentTestModuleData) {
                $studentTestModuleData = array();
            }
            if (!$studentTestInfoData) {
                $studentTestInfoData = array();
            }
            $testCounter = 0;
            $testModuleCounter = 0;
            $errorCounterTestUnique = $errorCounterTestUniqueFlag = 0;
            $userTestModels = array();
            $testSubjectArray = $testArray = array();
            foreach ($studentTestInfoData as $key => $data) {
                $userTestModels[$key] = new StudentTestDetail();
                $userTestModels[$key]->attributes = $data;
                if ($customError == "" && $userTestModels[$key]->entrance_exam_ref_id != '') {
                    if (in_array($userTestModels[$key]->entrance_exam_ref_id, $testArray)) {
                        $userTestModels[$key]->addError('entrance_exam_ref_id', 'Duplicate test selected. Please select another test.');
                        $errorCounterTestUniqueFlag = 1;
                    } else {
                        $testArray[] = $userTestModels[$key]->entrance_exam_ref_id;
                    }
                }
                foreach ($studentTestModuleData[$key] as $k => $value) {
                    $userTestModels[$key]->child[$k] = new StudentTestModuleDetail();
                    $userTestModels[$key]->child[$k]->attributes = $value;
                    $userTestModels[$key]->child[$k]->user_entrance_exam_ref_id = $userTestModels[$key]->user_entrance_exam_id;
                    if ($customError == "" && $userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id != '' && $userTestModels[$key]->child[$k]->marks != '') {
                        if (in_array($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id, $testSubjectArray)) {
                            $userTestModels[$key]->child[$k]->addError('entrance_exam_module_entrance_exam_ref_id', 'Duplicate subject selected. Please select another subject.');
                            $errorCounterTestUnique = 1;
                        } else {
                            $testSubjectArray[] = $userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id;
                        }
                    }
                }
                if ($data['entrance_exam_ref_id']) {
                    $testModulelist = EntranceExamModule::getEntranceModuleList($data['entrance_exam_ref_id']);
                    $userTestModels[$key]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                }
            }
            foreach ($userTestModels as $key => $data) {
                if ($customError == "" && $userTestModels[$key]->entrance_exam_ref_id && $errorCounterTestUniqueFlag == 0) {
                    if ($userTestModels[$key]->validate()) {
                        $testCounter = 1;
                    }

                    if ($userTestModels[$key]->hasErrors()) {
                        foreach ($userTestModels[$key]->getErrors() as $k => $val) {
                            foreach ($val as $errorMsg) {
                                $userTestModels[$key]->clearErrors();
                                $userTestModels[$key]->addError($k, $errorMsg);
                                $customError = $errorMsg;
                                break 3;
                            }
                        }
                    }
                }
                foreach ($userTestModels[$key]->child as $k => $value) {
                    if ($customError == "") {
                        if ($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id && $errorCounterTestUnique == 0) {
                            if ($userTestModels[$key]->child[$k]->validate()) {
                                $testModuleCounter = 1;
                            }
                        }
                        if ($userTestModels[$key]->child[$k]->hasErrors()) {
                            foreach ($userTestModels[$key]->child[$k]->getErrors() as $i => $val) {
                                foreach ($val as $errorMsg) {
                                    $userTestModels[$key]->child[$k]->clearErrors();
                                    $userTestModels[$key]->child[$k]->addError($i, $errorMsg);
                                    $customError = $errorMsg;
                                    break 4;
                                }
                            }
                        }
                    }
                }
            }

            if (!$customError) {
                // saving 12th data
                $tblUserModelObj = TblUserMaster::model()->findByPk($userId);
                $presentClass = substr($studentEducationInfoModel12->present_class, 0, 2);
                $classStatus = substr($studentEducationInfoModel12->present_class, 2, 1);
                $classStatus = $classStatus == 'c' ? 'Completed' : 'Pursuing';
                $oldValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;
                $tblUserModelObj->present_class = $presentClass;
                $tblUserModelObj->class_status = $classStatus;
                $newValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;
                if ($oldValueOfClassLevel != $newValueOfClassLevel) {
                    $getUserData = TblUserMaster::getUserDetails($userId);
                    $tblLoginMaster = LoginMaster::model()->findByPk($getUserData->login_ref_id);
                    if ($this->rbacRole == 'Student') {

                        $tblLoginMaster->is_class_status_confirmed = 0;
                    } else {
                        $tblLoginMaster->is_class_status_confirmed = 1;
                    }
                    $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
                    $tblLoginMaster->save(false);
                    StudentProfileValidationLog::saveLogData($userId, 'ClassLevel', $tblLoginMaster->is_class_status_confirmed, $loginId);
                }
                $tblUserModelObj->passout_month = $studentEducationInfoModel12->passout_month;
                $tblUserModelObj->passout_year = $studentEducationInfoModel12->passout_year;
                $tblUserModelObj->user_id = $userId;
                $tblUserModelObj->modified_on = date('Y-m-d H:i:s');
                $tblUserModelObj->setIsNewRecord(false);
                $tblUserModelObj->save(false);
                $studentEducationModel12 = new StudentEducation();
                $studentData12['user_ref_id'] = $userId;
                $studentData12['board_ref_id'] = $studentEducationInfoModel12->board_equivalent_id;
                if ($studentEducationInfoModel12->getScenario() == 'Marks') {
                    $studentData12['overall_marks'] = $studentEducationInfoModel12->overall_marks;
                    $studentData12['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel12->getScenario() == 'Points') {
                    $studentData12['overall_points'] = $studentEducationInfoModel12->overall_points;
                    $studentData12['overall_marks'] = NULL;
                } elseif ($studentEducationInfoModel12->getScenario() == 'Grades') {
                    $studentData12['overall_points'] = NULL;
                    $studentData12['overall_marks'] = NULL;
                }
                $studentData12['year'] = $studentEducationInfoModel12->passout_year;
                $studentData12['month'] = $studentEducationInfoModel12->passout_month;
                $studentData12['class_level'] = '12';
                $studentData12['status'] = $classStatus;
                $studentData12['school_name'] = $studentEducationInfoModel12->school_name;
                $studentEducation12 = StudentEducation::getStudentEducationDetails($userId, '12');
                if ($studentEducation12->student_education_id) {
                    $studentEducationModel12->attributes = $studentData12;
                    $studentEducationModel12->student_education_id = $studentEducation12->student_education_id;
                    $studentEducationModel12->setIsNewRecord(false);
                    $studentEducationModel12->save(false);
//                    Yii::app()->user->setFlash('error', "Data saving failed due to some technical issues. Kindly report a bug to site admin.");
//                    $this->redirect(Yii::app()->createUrl('student/studentProfile/educationDetail'));
                } else {
                    $studentEducationModel12->attributes = $studentData12;
                    $studentEducationModel12->insert();
                }
                StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $studentEducationModel12->student_education_id);
                if ($studentEducationInfoModel12->getScenario() == 'Grades') {
                    if ($studentEducationInfoModel12->overall_grades_aa) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 1, $studentEducationInfoModel12->overall_grades_aa);
                    }
                    if ($studentEducationInfoModel12->overall_grades_a) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 2, $studentEducationInfoModel12->overall_grades_a);
                    }
                    if ($studentEducationInfoModel12->overall_grades_b) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 3, $studentEducationInfoModel12->overall_grades_b);
                    }
                    if ($studentEducationInfoModel12->overall_grades_c) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 4, $studentEducationInfoModel12->overall_grades_c);
                    }
                    if ($studentEducationInfoModel12->overall_grades_d) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 5, $studentEducationInfoModel12->overall_grades_d);
                    }
                } StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $studentEducationModel12->student_education_id);
                foreach ($marksDetailModels12 as $key => $value) {
                    //print_r($marksDetailModels12[$key]->attributes);
                    if ($marksDetailModels12[$key]->insertFlag == 1) {
                        $studentSubjectModel[$key] = new StudentEducationDetail();
                        $studentSubjectModel[$key]->attributes = $marksDetailModels12[$key]->attributes;
                        $studentSubjectModel[$key]->student_education_ref_id = $studentEducationModel12->student_education_id;
                        $studentSubjectModel[$key]->save(false);
                    }
                }

                // saving 10th data
                $studentEducationModel10 = new StudentEducation();
                $studentData10['user_ref_id'] = $userId;
                $studentData10['board_ref_id'] = $studentEducationInfoModel10->board_equivalent_id;
                if ($studentEducationInfoModel10->getScenario() == 'Marks') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Points') {
                    $studentData10['overall_points'] = $studentEducationInfoModel10->overall_points;
                    $studentData10['overall_marks'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Grades') {
                    $studentData10['overall_points'] = NULL;
                    $studentData10['overall_marks'] = NULL;
                }
                $studentData10['year'] = $studentEducationInfoModel10->passout_year;
                $studentData10['month'] = $studentEducationInfoModel10->passout_month;
                $studentData10['class_level'] = '10';
                $studentData10['status'] = 'Completed';
                $studentData10['school_name'] = $studentEducationInfoModel10->school_name;
                $studentEducation10 = StudentEducation::getStudentEducationDetails($userId, '10');
                if ($studentEducation10->student_education_id) {
                    $studentEducationModel10->attributes = $studentData10;
                    $studentEducationModel10->student_education_id = $studentEducation10->student_education_id;
                    $studentEducationModel10->setIsNewRecord(false);
                    $studentEducationModel10->save(false);
//                    Yii::app()->user->setFlash('error', "Data saving failed due to some technical issues. Kindly report a bug to site admin.");
//                    $this->redirect(Yii::app()->createUrl('student/studentProfile/educationDetail'));
                } else {
                    $studentEducationModel10->attributes = $studentData10;
                    $studentEducationModel10->insert();
                }
                StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $studentEducationModel10->student_education_id);
                if ($studentEducationInfoModel10->getScenario() == 'Grades') {
                    if ($studentEducationInfoModel10->overall_grades_aa) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 1, $studentEducationInfoModel10->overall_grades_aa);
                    }
                    if ($studentEducationInfoModel10->overall_grades_a) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 2, $studentEducationInfoModel10->overall_grades_a);
                    }
                    if ($studentEducationInfoModel10->overall_grades_b) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 3, $studentEducationInfoModel10->overall_grades_b);
                    }
                    if ($studentEducationInfoModel10->overall_grades_c) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 4, $studentEducationInfoModel10->overall_grades_c);
                    }
                    if ($studentEducationInfoModel10->overall_grades_d) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 5, $studentEducationInfoModel10->overall_grades_d);
                    }
                } StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $studentEducationModel10->student_education_id);
                foreach ($marksDetailModels10 as $key => $value) {
                    //print_r($marksDetailModels12[$key]->attributes);
                    if ($marksDetailModels10[$key]->insertFlag == 1) {
                        $studentSubjectModel[$key] = new StudentEducationDetail();
                        $studentSubjectModel[$key]->attributes = $marksDetailModels10[$key]->attributes;
                        $studentSubjectModel[$key]->student_education_ref_id = $studentEducationModel10->student_education_id;
                        $studentSubjectModel[$key]->save(false);
                    }
                }

                // Saving Test Data
                $resultCount = UserEntranceExam::deleteUserAllExamData($userId);
                foreach ($userTestModels as $key => $data) {
                    if ($data->entrance_exam_ref_id) {
                        $userEntranceExamModel = new UserEntranceExam();
                        $userEntranceExamModel->user_ref_id = $userId;
                        $userEntranceExamModel->attributes = $data->attributes;
                        $userEntranceExamModel->added_by = $loginId;
                        $userEntranceExamModel->save(false);

                        foreach ($data->child as $k => $value) {
                            if ($value->entrance_exam_module_entrance_exam_ref_id != '' && $value->marks != '') {
                                $userEntranceExamModuleModel = new UserEntranceExamModule();
                                $userEntranceExamModuleModel->attributes = $value->attributes;
                                $userEntranceExamModuleModel->user_entrance_exam_ref_id = $userEntranceExamModel->user_entrance_exam_id;
                                $userEntranceExamModuleModel->added_by = $loginId;
                                $userEntranceExamModuleModel->save(false);
                            }
                        }
                    }
                }

                $criticalFields = array(
                    'edu_study_level' => $currentStudyFlag,
                    'school_name' => $schoolNameFlag,
                    'completion_year' => $passoutYearFlag,
                    'board' => $boardFlag,
                        // 'overall' => $overallMarksFlag,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);


                $shortList = new ShortListEngine();
                $shortList->profileUpdated();
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'Education Information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/studentProfile/preferences', $this->userParams));
            }

            $boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
            $boardList12 = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');
            $yearList12 = UniversityHelper::complitionYearList('12', $studentEducationInfoModel12->passout_year);
            $gradeData = LookupGrade::getgradeList();
            $boardId12 = $studentEducationInfoModel12->board_equivalent_id;
            $modelSubjects12 = LookupSubjectMaster::getSubjectsList($boardId12);
            $gradeArray = CHtml::listData($gradeData, 'grade_id', 'grade_type');
            $gradeArray = str_replace('aa', 'a*', $gradeArray);
            $marksSubjectList12 = CHtml::listData($modelSubjects12, 'student_subject_id', 'subject_name');
            $boardLookup10 = LookupBoardEquivalent::GetSchoolBoardList('10');
            $boardList10 = CHtml::listData($boardLookup10, 'board_equivalent_id', 'board_desc');
            $yearList10 = UniversityHelper::complitionYearList('10', $studentEducationInfoModel12->passout_year);
            $boardId10 = $studentEducationInfoModel10->board_equivalent_id;
            $modelSubjects10 = LookupSubjectMaster::getSubjectsList($boardId10);
            $marksSubjectList10 = CHtml::listData($modelSubjects10, 'student_subject_id', 'subject_name');
            $getAllTest = EntranceExam::getAllEntranceExams();
            $examlist = CHtml::listData($getAllTest, 'entrance_id', 'entrance_short_name');

            // Test module
        }
        $this->render('educationDetail', array('studentEducationInfoModel12' => $studentEducationInfoModel12, 'marksDetailModels12' => $marksDetailModels12, 'marksSubjectList12' => $marksSubjectList12, 'gradeArray' => $gradeArray, 'yearList12' => $yearList12, 'boardList12' => $boardList12, 'boardDetail12' => $boardDetail12, 'customError' => $customError,
            'studentEducationInfoModel10' => $studentEducationInfoModel10, 'marksDetailModels10' => $marksDetailModels10, 'marksSubjectList10' => $marksSubjectList10, 'yearList10' => $yearList10, 'boardList10' => $boardList10, 'boardDetail10' => $boardDetail10,
            'userTestModels' => $userTestModels, 'examlist' => $examlist, 'testYearList' => $testYearList));
    }

    public function actionUploadUserImage() {
        $userId = $this->userId;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
        $this->isUserImageAvailable = false;

        $path = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $valid_formats = array(".jpg", ".png", ".gif");
        if (isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST") {
            $name = $_FILES['photoimg']['name'];
            $size = $_FILES['photoimg']['size'];

            if (strlen($name)) {
                //list($txt, $ext) = strrchr($name, '.');//explode(".", $name);
                $ext = strrchr($name, '.');
                $ext = strtolower($ext);
                if (in_array($ext, $valid_formats)) {
                    if ($size < (1024 * 1024)) {
                        $actual_image_name = 'img_U_' . time() . $ext; //time() . substr(str_replace(" ", "_", $txt), 5) . "." . $ext;
                        $tmp = $_FILES['photoimg']['tmp_name'];
                        if (move_uploaded_file($tmp, $path . $actual_image_name)) {
                            $this->actionDeleteUserImage(false);
                            $this->isUserImageAvailable = true;
                            $this->userImage = $actual_image_name;

                            $studentModel = TblUserMaster::model()->findByPk($userId);
                            $studentModel->setAttributes(array('user_photo' => $this->userImage));
                            $studentModel->save(false);
                            $criticalFields = array(
                                'picture' => 1,
                            );
                            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                        } else {
                            $this->isUploading = true;
                            $this->imageUploadErrorMessage = "Image upload failed";
                        }
                    } else {
                        $this->isUploading = true;
                        $this->imageUploadErrorMessage = "Image file size max 1 MB";
                    }
                } else {
                    $this->isUploading = true;
                    $this->imageUploadErrorMessage = "Invalid file format..";
                }
            } else {
                $this->isUploading = true;
                $this->imageUploadErrorMessage = "Please select image..!";
            }

            $this->userData = TblUserMaster::getUserDetails($userId);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($this->userData->user_photo != '') {
                if (file_exists($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = true;
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                } else {
                    $this->isUserImageAvailable = false;
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                }
            } else {
                $this->isUserImageAvailable = false;
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
            $this->renderPartial('_studentImage');
            exit;
        }
    }

    public function actionDeleteUserImage($useSubView = true) {
        $userId = $this->userId;
        $this->isUserImageAvailable = false;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');

        $this->userData = TblUserMaster::getUserDetails($userId);
        //$studentModel = TblUserMaster::model()->find()
        $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                if (unlink($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = false;
                    $studentModel = TblUserMaster::model()->findByPk($userId);
                    $studentModel->setAttributes(array('user_photo' => ''));
                    $studentModel->save(false);
                    $criticalFields = array(
                        'picture' => 0,
                    );
                    TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                } else {
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                    $this->isUserImageAvailable = true;
                }
            }
        } else {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }
        if ($useSubView) {
            $this->renderPartial('_studentImage');
        }
    }

    public function actionGetSchoolList() {

        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            $res = LookupSchool::model()->findAll(array('condition' => 'school_name like "%' . $term . '%" AND user_entered <> 1 ', 'limit' => '10', 'order' => 'CASE WHEN school_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(school_name), school_name'));
            $val = array();
            if ($res) {
                foreach ($res as $r) {
                    $val[] = array(
                        'id' => $r->attributes['school_id'],
                        'label' => $r->attributes['school_name'],
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionGetStatesList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblState::getStateByCountry($countryId);
        echo json_encode($result);
    }

    public function actionGetCountryCode() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblCountryMaster::getPhoneCode($countryId);
        echo $result;
    }

    public function actionGetCityList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $stateId = Yii::app()->request->getQuery('stateId');
        $result = array();
        if ($stateId > 0) {
            //$result = TblCityMaster::getCityListByState($stateId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND state_ref_id = '" . $stateId . "'", "order" => "city_name"));
        } else if ($countryId > 0) {
            //$result = TblCityMaster::getCityListByCountry($countryId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '" . $countryId . "'", "order" => "city_name"));
        }
        $cityResults = array();
        foreach ($result as $city) {
            $cityResults[$city->attributes['city_id']] = $city->attributes['city_name'];
        }
        echo json_encode($cityResults);
    }

    public function actionGetBoardList() {
        $class = Yii::app()->request->getParam('class');
        $status = Yii::app()->request->getParam('status');
        //$boardlookup = LookupBoardEquivalent::GetSchoolBoardList($class);
        //$boardList = CHtml::listData($boardlookup, 'board_equivalent_id', 'board_desc');
        $yearList = UniversityHelper::completeYear($class . $status, 1);
        //$data['boardList'] =$boardList;
        $data['yearList'] = $yearList;
        echo json_encode($data);
    }

    public function actionDeleteSubject() {
        $id = Yii::app()->request->getPost('id');
        $count = StudentEducationDetail::model()->deleteByPk($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteTest() {
        $id = Yii::app()->request->getPost('id');
        $count = UserEntranceExam::deleteUserExamData($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteTestModule() {
        $id = Yii::app()->request->getPost('id');
        $count = UserEntranceExamModule::model()->deleteByPk($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteContact() {
        $id = Yii::app()->request->getPost('id');
        StudentContactNumber::model()->deleteByPk($id);
    }

    public function actionDeleteEmail() {
        $id = Yii::app()->request->getPost('id');
        StudentAlternateEmail::model()->deleteByPk($id);
    }

    public function actionGetSubjectsList() {
        $boardId = Yii::app()->request->getParam('boardId');
        $modelSubjects = LookupSubjectMaster::getSubjectsList($boardId);
        $subjectList = CHtml::listData($modelSubjects, 'student_subject_id', 'subject_name');
        $boardDetail = LookupBoardEquivalent::getBoardDetailById($boardId);
        $data['subjectList'] = $subjectList;
        $data['boardData'] = $boardDetail;
        echo json_encode($data);
    }

    public function actionGetModuleList() {
        $testId = Yii::app()->request->getParam('testId');
        $testModulelist = EntranceExamModule::getEntranceModuleList($testId);
        $moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
        $data['moduleList'] = $moduleList;
        echo json_encode($data);
    }

    public function actionGetMarksBlock() {
        $boardId = Yii::app()->request->getParam('boardId');
        $class = Yii::app()->request->getParam('class');
    }

    public function actionPreferences() {
        $this->breadcrumbs = array(
            'Home' => array('/home'),
            'My Profile' => array('/student/studentProfile'),
            'Edit Profile',
        );
        $subDeptList1 = $subDeptList2 = $subDeptList3 = array();

        $this->pageTitle = Yii::app()->name . ' - Edit Preferences';

        $studentPreferencesModel = new StudentPreferencesForm();

        //Collect student data
        $userId = $this->userId;
        $loginId = Yii::app()->user->id;
        $studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
        $counter = 1;
        foreach ($studentPreferredCountries as $studentPreferredCountry) {
            if ($counter <= 3) {
                $studentPreferencesModel->{countryPreference . $counter} = $studentPreferredCountry['country_ref_id'];
                $counter++;
            }
        }

        $studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);
        $counter = 1;
        foreach ($studentPreferredDepartments as $studentPreferredDept) {
            if ($counter <= 3) {
                $studentPreferencesModel->{departmentPreference . $counter} = $studentPreferredDept['main_dept_ref_id'];
                $studentPreferencesModel->{subDepartmentPreference . $counter} = $studentPreferredDept['sub_dept_ref_id'];

                if ($counter == 1)
                    $deptId1 = $studentPreferredDept['main_dept_ref_id'];
                if ($counter == 2)
                    $deptId2 = $studentPreferredDept['main_dept_ref_id'];
                if ($counter == 3)
                    $deptId3 = $studentPreferredDept['main_dept_ref_id'];
            }
            $counter++;
        }

        $studentPreferredStudyLevel = StudentPreferredStudyLevel::getStudyLevelsByUserId($userId);
        //$levelIds = LookupCourseLevel::getParentIdByLevelId($studentPreferredStudyLevel->course_level_ref_id);

        $counter = 1;
        foreach ($studentPreferredStudyLevel as $data) {
            $studentPreferencesModel->{levelOfStudy . $counter} = $data->course_level_ref_id;
            $studentPreferencesModel->{levelOfStudyId . $counter} = $data->preferred_study_level_id;
            $counter++;
        }

        $studentPreferredLikelyPeriods = StudentPreferredPeriod::getStudentPreferredPeriods($userId);
        $counter = 1;
        foreach ($studentPreferredLikelyPeriods as $studentPreferredLikelyPeriod) {
            $studentPreferencesModel->{likelyStartPeriod . $counter} = $studentPreferredLikelyPeriod['period_ref_id'];
            $studentPreferencesModel->{likelyStartPeriodYear . $counter} = $studentPreferredLikelyPeriod['year'];
            $counter++;
        }

        $studentStudyDurations = StudentPreferredDuration::getStudentStudyDuration($userId);
        $counter = 1;
        foreach ($studentStudyDurations as $studentStudyDuration) {
            $studentPreferencesModel->{studyDuration . $counter} = $studentStudyDuration->duration_ref_id;
            $studentPreferencesModel->{studyDurationId . $counter} = $studentStudyDuration->preferred_duration_id;
            $counter++;
        }


        $studyLevel = LookupCourseLevel::getParentCourseLevel(array(14));
        $studyLevel = CHtml::listData($studyLevel, 'level_id', 'course_level');

        $countryList = TblCountryMaster::getStudentInterestedCountryList();
        $countryList = CHtml::listData($countryList, 'country_id', 'country_name');

        $departmentList = LookupDepartment::getMainDepartmentList();

        $likelyperiod = LookupLikelyPeriod::model()->findAll();
        $likelyperiod = CHtml::listData($likelyperiod, 'period_id', 'months');

        $userDetail = TblUserMaster::getUserDetails($userId);
        $likelyperiodYear = UniversityHelper::complitionYearList("YearRangeArr", $userDetail['passout_year'] ? $userDetail['passout_year'] : date("Y"), 3);

        $studyDuration = LookupDuration::getDurations();
        $studyDuration = CHtml::listData($studyDuration, 'duration_id', 'name');


        $postData = Yii::app()->request->getParam('StudentPreferencesForm');

        $deptId1 = $postData['departmentPreference1'] ? $postData['departmentPreference1'] : $deptId1;
        if ($deptId1) {
            $subDeptList1 = LookupDepartment::getSubDepartmentsList($deptId1);
            $subDeptList1 = CHtml::listData($subDeptList1, 'department_id', 'department_name');
        }

        $deptId2 = $postData['departmentPreference2'] ? $postData['departmentPreference2'] : $deptId2;
        if ($deptId2) {
            $subDeptList2 = LookupDepartment::getSubDepartmentsList($deptId2);
            $subDeptList2 = CHtml::listData($subDeptList2, 'department_id', 'department_name');
        }

        $deptId3 = $postData['departmentPreference3'] ? $postData['departmentPreference3'] : $deptId3;
        if ($deptId3) {
            $subDeptList3 = LookupDepartment::getSubDepartmentsList($deptId3);
            $subDeptList3 = CHtml::listData($subDeptList3, 'department_id', 'department_name');
        }

        if (isset($_POST['StudentPreferencesForm'])) {

            $studentPreferencesModel->attributes = $postData;

            if ($studentPreferencesModel->validate()) {

                // Saving preferred Country Section
                $countryPreferenceObj = new StudentPreferredCountry();
                $getListOfStudentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountries($userId);
                foreach ($getListOfStudentPreferredCountries as $key => $data) {
                    $oldListOfPreferredCountries[$data->preference_order] = $data->country_ref_id;
                }

                $countryPreferenceObj->deleteCountryPreferenceByUserId($userId);

                if ($postData['countryPreference1']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference1'], 1);
                    $newListOfPreferredCountries['1'] = $postData['countryPreference1'];
                }

                if ($postData['countryPreference2']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference2'], 2);
                    $newListOfPreferredCountries['2'] = $postData['countryPreference2'];
                }

                if ($postData['countryPreference3']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference3'], 3);
                    $newListOfPreferredCountries['3'] = $postData['countryPreference3'];
                }

                $flagCriticalCountry = 0;
                if ($postData['countryPreference1'] || $postData['countryPreference2'] || $postData['countryPreference3']) {
                    $flagCriticalCountry = 1;
                }

                // Saving prefered Department Section
                $departmentPreferenceObj = new StudentPreferredDepartment;
                $getListOfStudentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartments($userId);
                foreach ($getListOfStudentPreferredDepartments as $key => $data) {
                    $oldListOfPreferredDepartments[$data->preference_order] = $data->main_dept_ref_id;
                }
                $departmentPreferenceObj->deleteDepartmentPreferenceByUserId($userId);

                if ($postData['departmentPreference1']) {
                    $subDeptId = $postData['subDepartmentPreference1'] ? $postData['subDepartmentPreference1'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference1'], $subDeptId, 1);
                    $newListOfPreferredDepartments['1'] = $postData['departmentPreference1'];
                }
                if ($postData['departmentPreference2']) {
                    $subDeptId = $postData['subDepartmentPreference2'] ? $postData['subDepartmentPreference2'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference2'], $subDeptId, 2);
                    $newListOfPreferredDepartments['2'] = $postData['departmentPreference2'];
                }
                if ($postData['departmentPreference3']) {
                    $subDeptId = $postData['subDepartmentPreference3'] ? $postData['subDepartmentPreference3'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference3'], $subDeptId, 3);
                    $newListOfPreferredDepartments['3'] = $postData['departmentPreference3'];
                }

                $flagCriticalDepartment = 0;
                if ($postData['departmentPreference1'] || $postData['departmentPreference2'] || $postData['departmentPreference3']) {
                    $flagCriticalDepartment = 1;
                }
                $flagForPreferenceChange = false;
                for ($i = 1; $i <= 3; $i++) {
                    if ($oldListOfPreferredCountries[$i] != $newListOfPreferredCountries[$i] || $oldListOfPreferredDepartments[$i] != $newListOfPreferredDepartments[$i]) {
                        $flagForPreferenceChange = true;
                    }
                }
                if ($flagForPreferenceChange) {
                    $getUserData = TblUserMaster::getUserDetails($userId);
                    $tblLoginMaster = LoginMaster::model()->findByPk($getUserData->login_ref_id);
                    if ($this->rbacRole == 'Student') {
                        $tblLoginMaster->is_preference_confirmed = 0;
                    } else {
                        $tblLoginMaster->is_preference_confirmed = 1;
                    }
                    $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
                    $tblLoginMaster->save(false);
                    StudentProfileValidationLog::saveLogData($userId, 'Preference', $tblLoginMaster->is_preference_confirmed, $loginId);
                }

                // Saving Preferred Period
                $preferredPeriodObj = new StudentPreferredPeriod();
                $preferredPeriodObj->deletePreferredPeriodByUserId($userId);

                if ($postData['likelyStartPeriod1']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod1'], $postData['likelyStartPeriodYear1']);
                }

                if ($postData['likelyStartPeriod2']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod2'], $postData['likelyStartPeriodYear2']);
                }

                if ($postData['likelyStartPeriod3']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod3'], $postData['likelyStartPeriodYear3']);
                }

                $flagCriticalLikelyStartPeriod = 0;
                if ($postData['likelyStartPeriod1'] || $postData['likelyStartPeriod2'] || $postData['likelyStartPeriod3']) {
                    $flagCriticalLikelyStartPeriod = 1;
                }

                $preferredStudyLevelObj = new StudentPreferredStudyLevel();
                $preferredStudyLevelObj->deletePreferredStudyLevelUserId($userId);

                if ($postData['levelOfStudy1']) {
                    $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($userId, $postData['levelOfStudy1']);
                }

                if ($postData['levelOfStudy2']) {
                    $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($userId, $postData['levelOfStudy2']);
                }

                $flagCriticalStudyLevel = 0;
                if ($postData['levelOfStudy1'] || $postData['levelOfStudy2']) {
                    $flagCriticalStudyLevel = 1;
                }

                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($userId);

                if ($postData['studyDuration1']) {
                    $studyDurationObj->insertStudyDurationByUserId($userId, $postData['studyDuration1']);
                }

                if ($postData['studyDuration2']) {
                    $studyDurationObj->insertStudyDurationByUserId($userId, $postData['studyDuration2']);
                }

                $flagCriticalStudyDuration = 0;
                if ($postData['studyDuration1'] || $postData['studyDuration2']) {
                    $flagCriticalStudyDuration = 1;
                }
                $tblUserMasterModel = TblUserMaster::model()->find('user_id=' . $userId);
                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->save(false);
                $criticalFields = array(
                    'country' => $flagCriticalCountry,
                    'intended_subjects' => $flagCriticalDepartment,
                    'likely_start_period' => $flagCriticalLikelyStartPeriod,
                    'study_level' => $flagCriticalStudyLevel,
                    'preferred_course_duration' => $flagCriticalStudyLevel
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);


                $shortList = new ShortListEngine();
                $shortList->profileUpdated();
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'Preferences Information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/studentProfile/extraCurricular', $this->userParams));
            } elseif ($studentPreferencesModel->hasErrors()) {
                foreach ($studentPreferencesModel->getErrors() as $key => $value) {
                    foreach ($value as $errorMsg) {
                        $studentPreferencesModel->clearErrors();
                        $studentPreferencesModel->addError($key, $errorMsg);
                        $customError = $errorMsg;
                        break 2;
                    }
                }
            }
        }

        $this->render('preferences', array(
            'studentPreferencesModel' => $studentPreferencesModel,
            'studyLevel' => $studyLevel,
            'studyDuration' => $studyDuration,
            'countryList' => $countryList,
            'departmentList' => $departmentList,
            'likelyperiod' => $likelyperiod,
            'likelyperiodYear' => $likelyperiodYear,
            'subDeptList1' => $subDeptList1,
            'subDeptList2' => $subDeptList2,
            'subDeptList3' => $subDeptList3,
            'customError' => $customError,
        ));
    }

    public function actionGetSubDeptList() {
        $deptId = Yii::app()->request->getParam('deptId');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('DEPARTMENT 1'), true);
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $subDeptList = CHtml::listData($modelSubDept, 'department_id', 'department_name');
        foreach ($subDeptList as $key => $value) {
            echo CHtml::tag('option', array('value' => $key), CHtml::encode($value), true);
        }
    }

    public function actionExtraCurricular() {
        $this->breadcrumbs = array(
            'Home' => array('/home'),
            'My Profile' => array('/student/studentProfile'),
            'Edit Profile',
        );
        $this->pageTitle = Yii::app()->name . ' - Edit Extra Curricular';
        $loginId = Yii::app()->user->id;
        $userId = $this->userId;
        $interestData = LookupUserInterest::model()->findAll();
        foreach ($interestData as $key => $data) {
            $interestArray[$data->user_interest_id]['name'] = $data->interest;
            $interestArray[$data->user_interest_id]['id'] = $data->user_interest_id;
        }
        $tblUserMasterModel = TblUserMaster::model()->find('user_id=' . $userId);
        if (!count($_POST)) {

            foreach ($interestData as $key => $data) {
                $userInterestData = TblUserInterest::getUserInterestsByInterestId($userId, $data->user_interest_id);
                foreach ($userInterestData as $k => $value) {
                    $models[$data->user_interest_id][$k + 1] = new StudentCurricular();
                    $models[$data->user_interest_id][$k + 1]->attributes = $value->attributes;
                }
                if ($models[$data->user_interest_id]) {
                    $models[$data->user_interest_id][$k + 2] = new StudentCurricular();
                } else {
                    $models[$data->user_interest_id][1] = new StudentCurricular();
                }
            }
        } else {

            $studentCurricularPostData = Yii::app()->request->getPost('StudentCurricular');
            $userMasterData = Yii::app()->request->getPost('TblUserMaster');
            foreach ($studentCurricularPostData as $key => $data) {

                foreach ($data as $k => $value) {
                    $models[$key][$k] = new StudentCurricular();
                    $models[$key][$k]->attributes = $value;
                }
            }
            foreach ($models as $key => $data) {
                $interestTypeArray = array();
                foreach ($data as $k => $value) {
                    if ($models[$key][$k]->user_interest_type_ref_id != '') {
                        if (in_array($models[$key][$k]->user_interest_type_ref_id, $interestTypeArray)) {
                            $models[$key][$k]->addError('user_interest_type_ref_id', 'Duplicate interest selected. Please select another interest.');
                            $customError = 'Duplicate interest selected. Please select another interest.';
                            break 2;
                        } else {
                            $interestTypeArray[] = $models[$key][$k]->user_interest_type_ref_id;
                        }
                    }
                }
            }
            $tblUserMasterModel->ps_leadership = substr($userMasterData['ps_leadership'], 0, 2000);
            $tblUserMasterModel->other_activities = substr($userMasterData['other_activities'], 0, 2000);
            if (!$customError) {
                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->save(false);

                TblUserInterest::model()->deleteAll('user_ref_id=' . $userId);
                foreach ($models as $key => $data) {
                    foreach ($data as $k => $value) {
                        if ($models[$key][$k]->user_interest_type_ref_id != '') {
                            $tblUserInterest = new TblUserInterest();
                            $tblUserInterest->attributes = $models[$key][$k]->attributes;
                            $tblUserInterest->user_ref_id = $userId;
                            $tblUserInterest->user_interest_ref_id = $key;
                            $tblUserInterest->save();
                        }
                    }
                }
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'Extra Curricular Information'));
                $this->redirect(Yii::app()->createUrl('student/studentProfile/extraCurricular', $this->userParams));
            }
        }


        $this->render('extraCurricular', array('interestData' => $interestData, 'models' => $models, 'interestArray' => $interestArray, 'tblUserMasterModel' => $tblUserMasterModel, 'customError' => $customError));
    }

    public function actionDeleteInterest() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = TblUserInterest::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteStudyLevel() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = StudentPreferredStudyLevel::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteStudyDuration() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = StudentPreferredDuration::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

     
    public function actionDeleteParentInfo() {
        $userId = $this->userId;
        $getUserData = TblUserMaster::getUserDetails($userId);
        $id = Yii::app()->request->getPost('id');
        $count1 = StudentAlternateEmail::deleteAlternateEmail($getUserData->login_ref_id, $id);
        echo $count1;
        $count2 = StudentContactNumber::deleteContactNumbers($userId, $id);
        echo $count2;
        $userMasterModel = TblUserMaster::model()->findByPk($userId);
        if ($id == 2) {
            $userMasterModel->father_first_name = NULL;
            $userMasterModel->father_last_name = NULL;
        } elseif ($id == 3) {
            $userMasterModel->mother_first_name = NULL;
            $userMasterModel->mother_last_name = NULL;
            ;
        } elseif ($id == 4) {
            $userMasterModel->guardian_first_name = NULL;
            $userMasterModel->guardian_last_name = NULL;
            ;
        }
        $userMasterModel->save(false);
        Yii::app()->end();
    }
}