<?php

class ParentDetail extends CFormModel {

    public $parent_first_name;
    public $parent_last_name;
    public $country_code1;
    public $number1;
    public $country_code2;
    public $number2;
    public $email_id1;
    public $email_id2;
    public $contact_type_ref_id;
    public $student_contact_number_id1;
    public $student_contact_number_id2;
    public $student_alternate_email_id1;
    public $student_alternate_email_id2;
    public $userId = 0;
    public $loginId = 0 ;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'country_code1' => 'Country code',
            'number1' => 'number',
            'country_code2' => 'Country code',
            'number2' => 'number',
            'email_id1' => 'email id',
            'email_id2' => 'email id',
            'parent_first_name' => 'first name',
            'parent_last_name' => 'last name',
            'contact_type_ref_id' => 'contact type',
        );
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('parent_first_name', 'checkFirstName', 'on' => 'basicInfo'),
            //array('parent_last_name', 'checkLastName', 'on' => 'basicInfo'),
            array('parent_first_name','match', 'pattern'=>'/^([a-zA-Z ])+$/', 'message' => '<div class="holder"><p>First name should contain only alphabets</p></div>', 'on' => 'basicInfo'),
            //array('parent_last_name', 'match', 'pattern'=>'/^([a-zA-Z ])+$/', 'message' => '<div class="holder"><p>Last name should contain only alphabets</p></div>', 'on' => 'basicInfo'),
            array('country_code1', 'match', 'pattern' => '/^[0-9 ]{0,5}$/i', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>', 'on' => 'basicInfo'),
            array('country_code1', 'numerical', 'min' => '1', 'tooSmall' => '<div class="holder"><p> {attribute} is invalid</p></div>', 'on' => 'basicInfo'),
            array('number1', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Numbers only</p></div>', 'on' => 'basicInfo'),
            array('number1', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Atleast 5 digits</p></div>', 'tooLong' => '<div class="holder"><p>Maximum 12 digits</p></div>', 'on' => 'basicInfo'),
            array('number1', 'match', 'pattern' => '/^[1-9]+[0-9]{0,12}$/i', 'message' => '<div class="holder"><p>Phone number is invalid</p></div>', 'on' => 'basicInfo'),
            array('country_code1', 'validateContact1', 'on' => 'basicInfo'),

            array('number1', 'duplicateNumber1', 'on' => 'basicInfo'),
            array('country_code2', 'match', 'pattern' => '/^[0-9 ]{0,5}$/i', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>', 'on' => 'basicInfo'),
            array('country_code2', 'numerical', 'min' => '1', 'tooSmall' => '<div class="holder"><p> {attribute} is invalid</p></div>', 'on' => 'basicInfo'),
            array('number2', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Numbers only</p></div>', 'on' => 'basicInfo'),
            array('number2', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Atleast 5 digits</p></div>', 'tooLong' => '<div class="holder"><p>Maximum 12 digits</p></div>', 'on' => 'basicInfo'),
            array('number2', 'match', 'pattern' => '/^[1-9]+[0-9]{0,12}$/i', 'message' => '<div class="holder"><p>Phone number is invalid</p></div>', 'on' => 'basicInfo'),
            array('country_code2', 'validateContact2', 'on' => 'basicInfo'),
            array('number2', 'duplicateNumber2', 'on' => 'basicInfo'),
            array('number1', 'studentPhoneValidation', 'on' => 'basicInfo'),
            array('number2', 'studentPhoneValidation2', 'on' => 'basicInfo'),

            //array('email_id1,email_id2', 'email', 'message' => 'Email address is invalid', 'on' => 'basicInfo'),
            array('email_id1,email_id2', 'match', 'pattern' => '/^[ a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Email address is invalid</p></div>', 'on' => 'basicInfo'),
            array('email_id1', 'duplicateEmail1', 'on' => 'basicInfo'),
            array('email_id2', 'duplicateEmail2', 'on' => 'basicInfo'),
            array('parent_first_name, parent_last_name, contact_type_ref_id, student_contact_number_id1,student_contact_number_id2, student_alternate_email_id1, student_alternate_email_id2', 'safe')

                //array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'basicInfo'),
        );
    }



    public function checkFirstName($attribute, $params) {
        if ($this->parent_first_name == '') {
            if ($this->contact_type_ref_id != '' || $this->number1 != '' || $this->number1 != '' || $this->email_id1 != '' || $this->email_id2 != '') {
                $this->addError($attribute, '<div class="holder"><p>Your parent\'s first name is required</p></div>');
            }
        }
    }

    public function checkLastName($attribute, $params) {
        if ($this->parent_last_name == '') {
            if ($this->contact_type_ref_id != '' || $this->number1 != '' || $this->number1 != '' || $this->email_id1 != '' || $this->email_id2 != '' || $this->parent_first_name !='' ) {
                $this->addError($attribute, '<div class="holder"><p>Last name is required</p></div>');
            }
        }
    }

    public function validateContact1($attribute, $params) {

//        if($this->parent_first_name != '' && ($this->country_code1 == '' && ($this->number1 == ''))){
//            $this->addError('number1', '<div class="holder"><p>Parent phone number is required</p></div>');
//        }

        if($this->country_code1 == 91 && ($this->number1 == '')){
            $this->addError('number1', '<div class="holder"><p>Phone number is required</p></div>');
        }

        if(($this->country_code1 != 91 && $this->country_code1 != '') && $this->number1 == ''){
            $this->addError('number1', '<div class="holder"><p>Phone number is required</p></div>');
        }
        if ($this->number1 != '' && $this->country_code1 == '') {
            $this->addError($attribute, '<div class="holder"><p>Country code is required</p></div>');
        }
    }

    public function validateContact2($attribute, $params) {

        if($this->country_code2 == 91 && $this->number2 == ''){
            $this->addError('number2', '<div class="holder"><p>Phone number is required</p></div>');
        }
        if(($this->country_code2 != 91 && $this->country_code2 != '') && $this->number2 == ''){
            $this->addError('number2', '<div class="holder"><p>Phone number is required</p></div>');
        }
        if ($this->number2 != '' && $this->country_code2 == '') {
            $this->addError($attribute, '<div class="holder"><p>Country code is required</p></div>');
        }
    }

    public function duplicateNumber1($attribute, $params) {
        //Commented by Ravi
        //Reason: Because of Heritage issue. Our counselors want to allow duplicate number for the student and parent
        //Ref: #1017
        /*if ($this->number1 != '' && $this->number1 == $_POST['StudentEditProfile']['student_number']) {
            $this->addError($attribute, 'You have entered same contact number again1');
        }*/
    }

    public function studentPhoneValidation() {

        if ($this->country_code1 == 91 && $this->number1 != '') {/*
            $res = file_get_contents('http://www.bmobile.in/'.$this->number1);

            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->number1); */

            if($this->number1[0] < 7){
                $this->addError('number1', '<div class="holder"><p>Enter a valid mobile number</p></div>');
            }
        }
    }

    public function studentPhoneValidation2() {

        if ($this->country_code2 == 91 && $this->number2 != '') { /*
            $res = file_get_contents('http://www.bmobile.in/'.$this->number2);

            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->number2);
            */
            if($this->number2[0] < 7){
                $this->addError('number2', '<div class="holder"><p>Enter a valid mobile number</p></div>');
            }
        }
    }

    public function duplicateNumber2($attribute, $params) {

        if ($this->number2 != '' && ($this->number1 == $this->number2 || $this->number2 == $_POST['StudentEditProfile']['student_number'])) {
            $this->addError($attribute, '<div class="holder"><p>You have entered same contact number again.Please change</p></div>');
        }
    }

    public function duplicateEmail1($attribute, $params) {
        $emailExist = LoginMaster::model()->find('username = "' . trim($this->email_id1) . '" AND login_id =' . $this->loginId);
        if ($this->email_id1 != '' && $emailExist->username != '') {
            $this->addError($attribute, '<div class="holder"><p>This is your primary email address. Enter different email.</p></div>');
        }
    }

    public function duplicateEmail2($attribute, $params) {

        if (trim($this->email_id1) && trim($this->email_id2)) {
            if(strtolower(trim($this->email_id1)) == strtolower(trim($this->email_id2))){
                $this->addError($attribute,'<div class="holder"><p>Entered same email address.Please change</p></div>');
            }
            $emailExist = LoginMaster::model()->find('username = "' . trim($this->email_id2) . '" AND login_id =' . $this->loginId);

            if ($this->email_id2 != '' && $emailExist->username != '') {
                $this->addError($attribute, '<div class="holder"><p>This is your primary email address. Enter different email.</p></div>');
            }
        }

    }


    public function getCountryCodes() {
        $result = TblCountryMaster::model()->findAll('is_active= "Y" AND country_code <> "" ORDER BY country_code ASC ');
        return CHtml::listData($result, 'phone_code', function($country) { return $country->country_name." (+".$country->phone_code.")"; } );
    }


}

?>