<?php

class StudentPreferencesForm10 extends CFormModel {

    public $change_school;
    public $interested_stream;
    public $countryPreference1;
    public $countryPreference2;
    public $countryPreference3;
    public $countryPreferenceNotSure;
    public $careerPreference1;
    public $careerPreference2;
    public $careerPreference3;
    public $careerPreferenceNotSure;
    public $subjectPreference1;
    public $subjectPreference2;
    public $subjectPreference3;
    public $subjectPreferenceNotSure;
    public $likelyStartPeriod1;
    public $likelyStartPeriod2;
    public $likelyStartPeriod3;
    public $likelyStartPeriodYear1;
    public $likelyStartPeriodYear2;
    public $likelyStartPeriodYear3;
    public $departmentPreference1;
    public $departmentPreference2;
    public $departmentPreference3;
    public $departmentPreferenceNotSure;
    public $subDepartmentPreference1;
    public $subDepartmentPreference2;
    public $subDepartmentPreference3;

    public $weakSubjectPreference1;
    public $weakSubjectPreference2;
    public $weakSubjectPreference3;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'countryPreference1' => 'Country Preference 1',
            'careerPreference1' => 'Career Preference 1',
        );
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            //array('countryPreference1', 'required', 'message' => 'Your first country preference is required'),
            array('countryPreference1', 'validateCountryPreference'),
            array('careerPreference1', 'validateCareerPreference'),
            array('subjectPreference1', 'validateSubjectPreference'),
            array('weakSubjectPreference1,weakSubjectPreference2,weakSubjectPreference3', 'validateWeakSubjectPreference'),
            array('likelyStartPeriod1', 'validateLikelyStartPeriodMonthAndYear'),
            array('likelyStartPeriod1', 'validateLikelyStartPeriod'),
            array('departmentPreference1', 'validateDepartment'),
            array('change_school, interested_stream, countryPreference1, countryPreference2, countryPreference3, careerPreference1, careerPreference2, careerPreference3, countryPreferenceNotSure,
             departmentPreference1, departmentPreference2, departmentPreference3, subDepartmentPreference1, subDepartmentPreference2, subDepartmentPreference3,
                subjectPreference1, subjectPreference2, subjectPreference3, likelyStartPeriod1, likelyStartPeriod2, likelyStartPeriod3, likelyStartPeriodYear1,
                likelyStartPeriodYear2, likelyStartPeriodYear3, subjectPreferenceNotSure, careerPreferenceNotSure, weakSubjectPreference1, weakSubjectPreference2, weakSubjectPreference3', 'safe'),
        );
    }

    public function validateCountryPreference($attribute, $params) {
        $arrCountryPref = array('1' => $this->countryPreference1, '2' => $this->countryPreference2, '3' => $this->countryPreference3);
        $arr = array();
        if (($this->countryPreference1 != '' || $this->countryPreference2 != '' || $this->countryPreference3 != '')) {
            if (!$this->countryPreference1) {
                $this->addError('countryPreference1', '<div class="holder"><p>Your first country preference is required</p></div>');
            }
            foreach ($arrCountryPref as $key => $val) {
                if ($val != '' && in_array($val, $arr)) {
                    $this->addError('countryPreference' . $key, '<div class="holder"><p>You selected the same country.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }
        } else if (!$this->countryPreferenceNotSure) {
            if (!$this->countryPreference1) {
                $this->addError('countryPreference1', '<div class="holder"><p>Your first country preference is required</p></div>');
            }
        }
    }

    public function validateCareerPreference($attribute, $params) {
        $arrCareerPref = array('1' => $this->careerPreference1, '2' => $this->careerPreference2, '3' => $this->careerPreference3);
        $arr = array();
        if (($this->careerPreference1 != '' || $this->careerPreference2 != '' || $this->careerPreference3 != '')) {
            if (!$this->careerPreference1) {
                $this->addError('careerPreference1', '<div class="holder"><p>Your first career preference is required</p></div>');
            }
            foreach ($arrCareerPref as $key => $val) {
                if ($val != '' && in_array($val, $arr)) {
                    $this->addError('careerPreference' . $key, '<div class="holder"><p>You selected the same career preference again.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }
        } else if (!$this->careerPreferenceNotSure) {
            if (!$this->careerPreference1) {
                $this->addError('careerPreference1', '<div class="holder"><p>Your first career preference is required</p></div>');
            }
        }
    }

    public function validateSubjectPreference($attribute, $params) {
        $arrSubjectPref = array('1' => $this->subjectPreference1, '2' => $this->subjectPreference2, '3' => $this->subjectPreference3);
        $arr = array();
        if (($this->subjectPreference1 != '' || $this->subjectPreference2 != '' || $this->subjectPreference3 != '')) {
            if (!$this->subjectPreference1) {
                $this->addError('subjectPreference1', '<div class="holder"><p>Your first subject preference is required</p></div>');
            }
            foreach ($arrSubjectPref as $key => $val) {
                if ($val != '' && in_array($val, $arr)) {
                    $this->addError('subjectPreference' . $key, '<div class="holder"><p>You selected the same subject again.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }
        } else if (!$this->subjectPreferenceNotSure) {
            if (!$this->subjectPreference1) {
                $this->addError('subjectPreference1', '<div class="holder"><p>Your first subject preference is required</p></div>');
            }
        }
    }

    public function validateWeakSubjectPreference($attribute, $params) {
        $arrWeakSubjects = array('1' => $this->weakSubjectPreference1, '2' => $this->weakSubjectPreference2, '3' => $this->weakSubjectPreference3);
        $arrStrongSubjects = array('1' => $this->subjectPreference1, '2' => $this->subjectPreference2, '3' => $this->subjectPreference3);
        $arr = array();
        $arr2 = array();
        if (($this->weakSubjectPreference1 != '' || $this->weakSubjectPreference2 != '' || $this->weakSubjectPreference3 != '')) {
            foreach ($arrWeakSubjects as $key => $val) {
                if ($val != '' && in_array($val, $arr)) {
                    $this->addError('weakSubjectPreference' . $key, '<div class="holder"><p>You selected the same subject again.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }

            foreach ($arrStrongSubjects as $key => $val) {
                    $arr2[] = $val;
            }
            foreach ($arrWeakSubjects as $key => $val) {
                if ($val != '' && in_array($val, $arr2)) {
                    $this->addError('weakSubjectPreference' . $key, '<div class="holder"><p>You selected the same strong and weak subject again.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }
        }
    }

    public function validateLikelyStartPeriodMonthAndYear($attribute, $params) {
        $arrLikelyStartPeriodMonth = array(
            '1' => $this->likelyStartPeriod1,
            '2' => $this->likelyStartPeriod2,
            '3' => $this->likelyStartPeriod3
        );
        $arrLikelyStartPeriodYear = array(
            '1' => $this->likelyStartPeriodYear1,
            '2' => $this->likelyStartPeriodYear2,
            '3' => $this->likelyStartPeriodYear3
        );

        for($i = 1; $i <= 3; $i++) {
            if($arrLikelyStartPeriodMonth[$i] == '' && $arrLikelyStartPeriodYear[$i] != '') {
                $this->addError('likelyStartPeriod' . $i, '<div class="holder"><p>You need to select a prospective starting session month</p></div>');
            } elseif($arrLikelyStartPeriodMonth[$i] != '' && $arrLikelyStartPeriodYear[$i] == '') {
                $this->addError('likelyStartPeriodYear' . $i, '<div class="holder"><p>Select starting session year</p></div>');
            }
        }
    }

    public function validateLikelyStartPeriod($attribute, $params) {
        $arrLikelyStartPeriod = array(
            '1' => $this->likelyStartPeriod1 . $this->likelyStartPeriodYear1,
            '2' => $this->likelyStartPeriod2 . $this->likelyStartPeriodYear2,
            '3' => $this->likelyStartPeriod3 . $this->likelyStartPeriodYear3
        );
        $arr = array();
        foreach ($arrLikelyStartPeriod as $key => $val) {
            if ($val != '' && in_array($val, $arr)) {
                $this->addError('likelyStartPeriod' . $key, '<div class="holder"><p>You have selected same prospective starting session</p></div>');
            } else {
                $arr[] = $val;
            }
        }
    }

    public function validateDepartment($attribute, $params){

        if($this->departmentPreference1)
        {
            $main_dept = array();
            if($this->departmentPreference1) $main_dept[1] = $this->departmentPreference1;
            if($this->departmentPreference2) $main_dept[2] = $this->departmentPreference2;
            if($this->departmentPreference3) $main_dept[3] = $this->departmentPreference3;

            $sub_dept = array();
            if($this->subDepartmentPreference1) $sub_dept[1] = $this->subDepartmentPreference1;
            if($this->subDepartmentPreference2) $sub_dept[2] = $this->subDepartmentPreference2;
            if($this->subDepartmentPreference3) $sub_dept[3] = $this->subDepartmentPreference3;

            if(empty($main_dept[1])){
                $this->addError('departmentPreference1', '<div class="holder"><p>Your first major preference is required</p></div>');
            }else{
                $main_sub = array();
                foreach($main_dept as $key => $md){
                    if(array_key_exists($key, $sub_dept)){
                        if(in_array($md.$sub_dept[$key], $main_sub)){
                            $this->addError('subDepartmentPreference' . $key, '<div class="holder"><p>Choose different department</p></div>');
                            unset($main_dept[$key]);
                        }
                        $main_sub[] = $md.$sub_dept[$key];

                    }

                }

                $non_duplicate = array_unique($main_dept);
                $missed = array_diff_assoc($main_dept,$non_duplicate);

                if($missed){
                    $missed[array_search($missed[key($missed)], $main_dept)] = $main_dept[array_search($missed[key($missed)], $main_dept)];
                    ksort($missed);
                    foreach($missed as $key => $v){
                        if(!array_key_exists($key, $sub_dept)) $this->addError('subDepartmentPreference'.$key, '<div class="holder"><p>Choose a department</p></div>');
                    }
                }
            }
    }
    }


}

?>