<?php

/**
 * This is the model class for table "lookup_school".
 *
 * The followings are the available columns in table 'lookup_school':
 * @property string $first_name
 * @property string $last_name
 * @property string $username
 * @property string $pass_word
 * @property string $confirm_password
 * @property string $gender
 * @property string $present_school
 * @property integer $present_class
 * @property integer $present_board_ref_id
 * @property integer $passout_month
 * @property integer $passout_year
 * @property string $verifyCode
 *
 */
class StudentSignupB2C extends CFormModel {

    public $first_name;
    public $last_name;
    public $username;
    public $confirm_username;
    public $password;
    public $gender;
    public $present_class;
    public $country;
    public $department;
    public $country_code;
    public $phone;
    public $board;
    public $overall_marks;
    public $overall_marks_gpa;
    public $overall_aa;
    public $overall_a;
    public $overall_b;
    public $overall_c;
    public $overall_d;
    public $overall_points;
    public $overall_type;
    public $overall_max;
    public $full_name;
    public $is_visited_school;
    public $coupon_code;
    public $school_name;
    public $band;
    public $city;
    public $city_id;
    public $school_code;

    public function rules() {
        return array(
            array('username', 'required', 'on' => 'firstPage, new_signup, profile, profileregistration, old_signup', 'message' => '<div class="holder"><p>Enter your {attribute}</p></div>'),
            array('first_name,last_name', 'required', 'on' => 'profileregistration, new_signup', 'message' => '<div class="holder"><p>Enter your {attribute}</p></div>'),
            array('full_name', 'required', 'on' => 'profile', 'message' => '<div class="holder"><p>Enter your {attribute}</p></div>'),
            array('full_name', 'match', 'pattern' => '/^[a-zA-Z.\' ][a-zA-Z.\'\s]+$/', 'message' => '<div class="holder"><p>No special characters allowed.</p></div>', 'on' => 'profile'),
            array('country, department', 'required', 'on' => 'new_signup', 'message' => '<div class="holder"><p>Select {attribute}</p></div>'),
            array('board', 'required', 'on' => 'new_signup', 'message' => '<div class="holder"><p>Select {attribute}</p></div>'),
            array('username,password', 'required', 'on' => 'new_signup,firstPage,profileregistration', 'message' => '<div class="holder"><p>{attribute} can\'t be blank</p></div>'),
            array('present_class', 'required', 'message' => '<div class="holder"><p>Select your current study level</p></div>', 'on' => 'firstPage,profileregistration, old_signup'),
            array('confirm_username', 'required', 'on' => 'firstPage', 'message' => '<div class="holder"><p>Confirm your email</p></div>'),
            array('password', 'required', 'on' => 'firstPage, new_signup, profile, old_signup', 'message' => '<div class="holder"><p>Enter a password</p></div>'),
            array('gender', 'required', 'message' => '<div class="holder"><p>Select your gender</p></div>', 'on' => 'firstPage, new_signup, profile'),
            array('is_visited_school', 'required', 'message' => '<div class="holder"><p>Select your school visit</p></div>', 'on' => 'profile'),
            array('is_visited_school', 'ValidateCouponCode', 'on' => 'profile'),

            array('present_class', 'required', 'message' => '<div class="holder"><p>Select your current study level</p></div>', 'on' => 'firstPage, new_signup,profile'),
            array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Email already registered. <a href="/app/login/PopupLogin">Sign In</a> to your account</p></div>', 'on' => 'firstPage, new_signup,profile,profileregistration,old_signup'),
            array('username, confirm_username', 'match', 'pattern' => '/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo, cssContactInfo10'),
            array('username', 'match', 'pattern' => '/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'new_signup,profile,profileregistration'),
            array('confirm_username', 'compare', 'compareAttribute' => 'username', 'message' => '<div class="holder"><p>Email doesn\'t match</p></div>', 'on' => 'firstPage'),
            array('password', 'length', 'min' => 6, 'max' => 20, 'tooShort' => '<div class="holder"><p>Password should be atleast 6 characters </p></div>', 'tooLong' => '<div class="holder"><p>Password shouldn\'t be more than 20 characters</p></div>', 'on' => 'firstPage, new_signup,profile,profileregistration'),
            array('phone', 'ValidateCountryPhone', 'on' => 'new_signup'),
            //array('board', 'validateEducation', 'on' => 'new_signup'),
            array('first_name, confirm_username, country, country_code, department, phone,board, overall_marks, overall_aa, overall_a, overall_b, overall_c, overall_d, overall_points, overall_type, overall_max, overall_marks_gpa,full_name, is_visited_school, coupon_code,school_name,band,city,city_id, school_code', 'safe'),
        );
    }

    public function attributeLabels() {
        return array(
            'username' => 'email',
            'confirm_username' => 'confirm email',
            'password' => 'Password',
            'gender' => 'Gender',
            'first_name' => 'First name',
            'last_name' => 'Last name',
            'present_school' => 'School name',
            'full_name' => 'name'
        );
    }

    public function ValidateCountryPhone(){
        if($this->country_code || $this->phone){
            if(!$this->country_code) $this->addError('country_code', '<div class="holder"><p>Select Your country code</p></div>');
            if(!preg_match('/^[7-9][0-9]{9}$/', $this->phone) && $this->country_code == 91) $this->addError('phone', '<div class="holder"><p>Enter a valid phone number</p></div>');
            if(!preg_match('/^[0-9]{7,15}$/', $this->phone) && $this->country_code != 91) $this->addError('phone', '<div class="holder"><p>Enter a valid phone number</p></div>');
        }
    }

    public function validatePhone() {
        if ($this->country_code == 91) { /*
          $res = file_get_contents('http://www.bmobile.in/'.$this->phone);

          $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
          $res_arr1 = explode('</tbdy>', $res_arr[1]);

          $count = 0;
          $count = @substr_count($res_arr1[0], $this->phone); */
            if ($this->phone[0] > 6) {
                
            } else {
                $this->addError('phone', '<div class="holder"><p>Enter a valid phone number</p></div>');
            }
        }

        if ($this->phone && !$this->country_code) {
            $this->addError('country_code', '<div class="holder"><p>Select Your country code</p></div>');
        }

        if ($this->phone) {
            if (!(int) $this->phone) {
                $this->addError('phone', '<div class="holder"><p>Should contain numbers only</p></div>');
            }

            if (strlen($this->phone) < 7) {
                $this->addError('phone', '<div class="holder"><p>Enter a valid phone number</p></div>');
            }
        }
    }

    public function validateEducation() {
        if ($this->board) {
            $classLevel = 12;
            $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $this->board);

            switch ($boardDetails['overall_type']) {
                case 'Marks-GPA':
                    if (!trim($this->overall_marks_gpa)) {
                        $this->addError('overall_marks_gpa', '<div class="holder"><p>Enter overall marks</p></div>');
                    }

                    if (!is_numeric($this->overall_marks_gpa)) {
                        $this->addError('overall_marks_gpa', '<div class="holder"><p>Your overall marks should be number</p></div>');
                    }

                    if ($this->overall_marks_gpa > 0.6 && $this->overall_marks_gpa <= 100) {
                        
                    } else {
                        $this->addError('overall_marks_gpa', '<div class="holder"><p>Marks should be in between 1 to 100</p></div>');
                    }
                    break;
                case 'Marks':
                    if (!trim($this->overall_marks)) {
                        $this->addError('overall_marks', '<div class="holder"><p>Enter overall marks</p></div>');
                    }

                    if (!(int) $this->overall_marks) {
                        $this->addError('overall_marks', '<div class="holder"><p>Your overall marks should be number</p></div>');
                    }

                    if ($this->overall_marks > 1 && $this->overall_marks <= 100) {
                        
                    } else {
                        $this->addError('overall_marks', '<div class="holder"><p>Marks should be in between 1 to 100</p></div>');
                    }

                    break;
                case 'Points':
                    if (!$this->overall_points) {
                        $this->addError('overall_points', '<div class="holder"><p>Select overall points</p></div>');
                    }

                    break;
                case 'Grades':
                    if (!$this->overall_aa && !$this->overall_a && !$this->overall_b && !$this->overall_c && !$this->overall_d) {
                        $this->addError('overall_aa', '<div class="holder"><p>Select overall grades</p></div>');
                    }

                    break;
            }
        }
    }

    public function ValidateCouponCode(){
        if($this->is_visited_school == 'Y'){
            if(!$this->city){
                $this->addError('city', '<div class="holder"><p>Enter your City</p></div>');
            }
            /*if(!$this->coupon_code){
                $this->addError('coupon_code', '<div class="holder"><p>Enter your school Coupon Code</p></div>');
            }*/
            if(!$this->school_name){
                $this->addError('school_name', '<div class="holder"><p>Enter School name</p></div>');
            }
            if($this->coupon_code)
            {
                /*$couponDetails = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => $this->coupon_code));
                if(!$couponDetails){
                    $this->addError('coupon_code', '<div class="holder"><p>Invalid coupon code</p></div>');
                }*/
                /*
                $schoolExistID = LookupSchool::getSchoolID(trim($this->school_name));
                $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
                if($schoolExistID) {
                    if($couponDetails->inst_ref_id != $siDiData->inst_id) {
                        $this->addError('coupon_code', '<div class="holder"><p>Coupon code not match with the School</p></div>');
                    }
                }*/
            }
            /*if($this->school_code){
                $siDiData = TblSiDi::getInstIdFromSchoolCode($this->school_code);
                if(!$siDiData){
                    $this->addError('school_code', '<div class="holder"><p>Invalid school code</p></div>');
                }
            }*/
            /*if(!$this->band){
                $this->addError('band', '<div class="holder"><p>Enter your Band</p></div>');
            }*/
        }
    }

}

?>
