<?php
$majorInterests = StudentPreferredDepartment::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
?>
<div class="row multi_line white no-border color-dark-gray container" style="margin: 0 !important;">
    <div class="titles border-bottom row gutter_vertical">
        <h3 class="uppercase gutter_vertical left">Major Preferences</h3>
    </div>

    <?php
    Yii::app()->clientScript->corePackages = array();
    $form = $this->beginWidget('CActiveForm', array(
        'enableClientValidation' => false,
        'enableAjaxValidation'=>true,
        'clientOptions' =>array(
            'validateOnSubmit'=>true,
            'validateOnChange' => true,
            'validateOnType' => true,
            'beforeValidate'  => 'js:function(form){
                    $("div.errorMessage").hide();
                    return true;
                }',
            'afterValidate' => 'js:function(form, data, hasError){
                    if(!$.isEmptyObject(data)){
                        for(var i in data) {
                           var id = i, message = data[i][0];
                           $("#"+i+"_em_").html(message).show();
                        }
                        $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 250 }, 1000);
                        return false;
                    }else{
                        $.post($(form).attr("action"), $(form).serialize() , function(r){
                            $.notification({class: r.msg_cls, notification:r.msg_notification, replaceKeys: r.replaceKeys, time:4E3});
                            if(r.msg_cls != "error_notify"){
                                angular.element($("#customcareerplan")).scope().getWidgetData(triggerActiveBlock);
                                $.fancybox.close();
                            }
                        }, "json")
                    }
                }',
        )
    ));
    echo $form->hiddenField($formModel,'hidden_temp');
    echo $form->error($formModel,'hidden_temp');

    $majorInterests = $majorInterests ? $majorInterests : array(0);
    $first = true; $totalCount = count($majorInterests);
    foreach($majorInterests as $chosenMajor ){
        $chosenMajor = (object) $chosenMajor;
        $this->renderPartial('_major_of_interest', array(
            'model'=>$formModel, 'first'=>$first,
            'chosenMajor' => $chosenMajor, 'totalCount'=>$totalCount
        ), true);
        echo $this->clips['majorOfInterest'];
        $first = false;
    }
    ?>

    <div class="center gutter-verticle-auto">
        <button class="button-blue tny small_gutter_r">Save</button>
        <button type="button" onclick="$.fancybox.close();" class="button-default tny small_gutter_r">Cancel</button>
    </div>
    <?php
    $this->endWidget();
    ?>
</div>
