<?php
Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/tip-yellowsimple.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.poshytip.js");

    $countriesList = TblCountryMaster::getUnivarietyCountries();
    $countries = CHtml::listData($countriesList,'country_id', 'country_name');

    $allCountryList = TblCountryMaster::getCountryList();
    $uniqueCountryList = array_diff($allCountryList, $countries);
    $countries['Others'] = $uniqueCountryList;


    $model = new B2CDashboard('countryMissing');
    $prefCountires = $user->getPreferredCountries();
    $keys = array();
    foreach($prefCountires as $pref=>$value) {
        $keys[] = $pref;
    }
    $model->country_pref1 = $keys[0];$model->country_pref2 = $keys[1];$model->country_pref3 = $keys[2];

	$form = $this->beginWidget('CActiveForm', array(
        'id' => 'countryMissing',
        'enableAjaxValidation' => true,
        'enableClientValidation' => false,
        'clientOptions' => array(
            'validateOnSubmit' => true,
            'validateOnChange' => false,
            'validateOnType' => false,
        ),
    ));
    $i = 0;

$titles = array(223=>'UK: Average tuition fees is around $14,000 per year. Please factor this in your choice.', 224=>'US: Average tuition fees can range from $15,000 - 50,000 per year. Please factor this in your choice.', 190=>'Singapore: Average tuition fees is around $20,000 per year. Please factor this in your choice.', 12=>'Australia / NZ: Average tuition fees is around $30,000 per year. Please factor this in your choice.', 154=>'Australia / NZ: Average tuition fees is around $30,000 per year. Please factor this in your choice.', 36=>'Canada: Average tuition fees is around $20,000 per year. Please factor this in your choice.', 'oth'=>': Ask us the fees involved with studying in this country.', 222=>'UNITED ARAB EMIRATES: Average tuition fees is around $18,000 per year. Please factor this in your choice.', 97=>'HONGKONG: Average tuition fees is around $20,000 - $32,000 per year. Please factor this in your choice.', 82=>'GERMANY: Average tuition fees is around $40,800 - $60,900 per year. Please factor this in your choice.', 151=>'NETHERLANDS: Ask us the fees involved with studying in this country.' );
    foreach($prefCountires as $pref=>$value) {
        $i++;
        $title = $titles[$pref] ? $titles[$pref] : $value.' '.$titles['oth'];
    ?>
    <div class="row visible clearfix gutter_vertical" id="countrySection<?php echo $pref; ?>">
        <div class="grid_0 left grid_index">#<?php echo $i; ?></div>
        <div class="grid_4 left" id="countryView<?php echo $i; ?>" style="display: none;">
            <?php echo $value; ?>
        </div>
        <div class="grid_4 left relative"  id="countryShow<?php echo $i; ?>">
            <?php
            echo $form->dropDownList($model, 'country_pref'.$i, $countries, array('empty' => 'Country Preference '.$i,'title'=>$title, 'class'=>'select grid_4 drpdwn', 'onchange'=>"changeToolTipTitle(this.value, $i, 'all');show_options('B2CDashboard_country_pref', $i);"));
            echo $form->error($model, 'country_pref'.$i, array("class" => "errorMessage popup"));
            ?>
        </div>
        <div class="left grid_3">
            &nbsp;
        </div>
        <div class="left grid_1" id="countryButton<?php echo $i; ?>">
            <a style="cursor: pointer" onclick="$('#countryView<?php echo $i; ?>').hide();$('#countryShow<?php echo $i; ?>').show();$('#countryButton<?php echo $i; ?>').html('&nbsp;');">&nbsp;</a>
        </div>
        <?php //if ($i != 1) { ?>
        <div class="pull">
            <a style="cursor: pointer" class="remove_country" onclick="removeCountry('<?php echo $pref; ?>')">Remove</a>
        </div>
        <?php //} ?>
    </div>
    <?php } ?>
</div>
    <div style="text-align: center;" class="row gutter_vertical">
        <input type="hidden" name="userId" value="<?echo $userId;?>" id="userId">
        <?php echo $form->hiddenField($model,'formType',array('value'=>'countryMissing'));
        echo CHtml::submitButton('Save', array('value' => 'Confirm', 'class' => "button-blue tny", 'id'=>'submitCountry')); ?>
    </div>
    <?php $this->endWidget(); ?>
<script>
    $(document).ready(function() {
        $('#B2CDashboard_countryPref1').poshytip({ className: 'tip-yellowsimple', showOn: 'focus', alignTo: 'target', alignX: 'left', alignY: 'center', offsetX: 5, showTimeout: 100 });
        $('#B2CDashboard_countryPref2').poshytip({ className: 'tip-yellowsimple', showOn: 'focus', alignTo: 'target', alignX: 'left', alignY: 'center', offsetX: 5, showTimeout: 100 });
        $('#B2CDashboard_countryPref3').poshytip({ className: 'tip-yellowsimple', showOn: 'focus', alignTo: 'target', alignX: 'left', alignY: 'center', offsetX: 5, showTimeout: 100 });

        $("#submitCountry").click(function(){
            var ctry1 = $("#B2CDashboard_country_pref1").val();
            var ctry2 = $("#B2CDashboard_country_pref2").val();
            var ctry3 = $("#B2CDashboard_country_pref3").val();
            var userId = $("#userId").val();

            $.ajax({
                type: "POST",
                data: {ctry1 : ctry1, ctry2:ctry2, ctry3:ctry3, userId:userId },
                url: ibase_url + "student/Dashboard/updateValidCountries",
                async: false,
                success: function(data){
                    getNextBlock();
                }
            });


            return false;
        });
    });

</script>
