<?php
$form=$this->beginWidget('CActiveForm', array(
    'enableAjaxValidation'=>true,
    'clientOptions' =>array(
        'validateOnSubmit'=>true,
    )
));
$this->beginClip("examOfInterest");
?>
<div id="examDiv_<?php echo $examID; ?>" class="examDiv">
    <div class="visible clearfix border-bottom gutter_vertical">
        <div class="gutter_vertical visible clearfix">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small"><?php echo $examName; ?></div>
            <div class="grid_5 pull small_gutter_r styledSelect2 relative">
                <?php
                echo $form->dropDownList($model, "exams_info[$examID][status]",
                    array('Planned' => 'Planned', 'Completed' => 'Completed'),
                    array('empty' => 'Choose Your Status','class' => "full-width examStatus", 'rel'=>$examID,
                        'options' => array( $chosenExam->exam_status =>array('selected'=>true))
                    )
                );
                echo $form->error($model, "exams_info[$examID][status]", array('class'=>'popup errorMessage'));
                ?>
            </div>
        </div>
        <div class="gutter_vertical visible clearfix">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Year</div>
            <div class="grid_5 pull small_gutter_r styledSelect2 relative">
                <?php
                $testYearList = UniversityHelper::testYearList($chosenExam->exam_status);
                echo $form->dropDownList($model, "exams_info[$examID][year]", $testYearList,
                        array('class'=>'full-width examYear',
                        'empty' => $chosenExam->exam_status == 'Completed' ? 'Last Year of appearance' : 'Year of appearance',
                        'options' => array( $chosenExam->exam_year =>array('selected'=>true)))
                );
                echo $form->error($model, "exams_info[$examID][year]", array('class'=>'popup errorMessage'));
                ?>
            </div>
        </div>
        <div class="plannedDiv gutter_vertical visible clearfix <?php echo $chosenExam->exam_status=='Planned' ? '' : 'hidden'; ?>">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">&nbsp;</div>
            <div class="grid_3 left small-right small_gutter_r text-right small_gutter_t small">Have you joined any coaching institute for <?php echo $examName; ?> preparation?</div>
            <div class="grid_2 pull small_gutter_l">
                <div class="styledSelect2 relative">
                    <?php
                    $model->exams_info[$examID]['joined_coaching_inst'] = $chosenExam->joined_coaching_inst;
                    echo $form->dropDownList(
                        $model, "exams_info[$examID][joined_coaching_inst]",
                        array('Y'=>'Yes', 'N'=>'No'), array('class'=>'full-width', 'empty' => 'Choose status')
                    );
                    echo $form->error($model, "exams_info[$examID][joined_coaching_inst]", array('class'=>'popup errorMessage'));
                    ?>
                </div>
            </div>
        </div>

        <div class="examMarks <?php echo $chosenExam->exam_status=='Completed' ? '' : 'hidden'; ?>">

            <div class="gutter_vertical visible clearfix" >
                <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Overall Score </div>
                <div class="grid_5 pull relative">
                    <?php
                    $chosenExam->overall_marks = floatval(str_replace(',','', $chosenExam->overall_marks));
                    $model->exams_info[$examID]['overall_marks'] = $chosenExam->overall_marks ? $chosenExam->overall_marks : '';
                    echo $form->textField(
                        $model, "exams_info[$examID][overall_marks]",
                        array(
                            'maxlength' => "4",
                            'placeholder' => $chosenExam->exam_status == 'Completed' &&
                                in_array($examID, array(77, 78, 93)) ? 'Enter best overall score' : 'Enter overall score',
                            'class' => 'full-width overallScore'
                        )
                    );
                    echo $form->error($model, "exams_info[$examID][overall_marks]", array('class'=>'popup errorMessage'));
                    ?>
                </div>
            </div>

            <?php
            $testModulelist = EntranceExamModule::getEntranceModuleList($examID);
            if($testModulelist){ ?>
                <div class="gutter_vertical visible clearfix" >
                    <div class="grid_2 pull small_gutter_r text-right small_gutter_t small"><strong>Section Score</strong></div>
                    <div class="left small-right grid_6">&nbsp;</div>
                </div>
                <?php
                foreach($testModulelist as $testModule){
                    $modId = $testModule['entrance_exam_module_entrance_exam_id'];
                    $examModule = UserEntranceExamModule::model()->find(array("condition" => "user_entrance_exam_ref_id = '" . $chosenExam->user_entrance_exam_id . "' AND entrance_exam_module_entrance_exam_ref_id = '" . $modId . "' "));
                    $marks = (float)$examModule->marks;
                ?>
                    <div class="gutter_vertical visible clearfix" >
                        <div class="grid_2 pull small_gutter_r text-right small_gutter_t small"><?php echo $testModule['module_name']; ?></div>
                        <div class="left small-right grid_5 relative">
                            <?php
                            echo $form->textField(
                                $model, "exams_info[$examID][modules][$modId]",
                                array(
                                    'maxlength' => "4", 'placeholder' => 'Enter Score',
                                    'class' => 'full-width', 'value'=>$marks ? $marks : ''
                                )
                            );
                            echo $form->error($model, "exams_info[$examID][modules][$modId]", array('class'=>'popup errorMessage'));
                            ?>
                        </div>
                    </div>
                    <?php
                }
                ?>
            <?php } ?>

            <div class="gutter_vertical visible clearfix" >
                <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">&nbsp;</div>
                <div class="left small-right grid_6">
                    <div class="grid_6 pull small_gutter_t small clearfix ">
                        <?php
                        $model->exams_info[$examID]['reappear_exam'] = ($chosenExam->reappear_exam == 'Y') ? 1 : 0; ?>
                        <div class="left small-right">
                        <?php echo $form->checkBox($model,"exams_info[$examID][reappear_exam]",array('value'=>1,'uncheckValue'=>0,'style'=>'margin-top:-11px;')); ?>
                        </div>
                        <div class="left small-right">
                            Are you planning to reappear for <?php echo $examName; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$this->endClip();
$this->endWidget();
?>